/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import eu.qimpress.dtmc.DtmcPackage;
import eu.qimpress.ide.analysis.reliability.jobs.PrepareReliabilityBlackboardPartitionConf;
import klaper.core.CorePackage;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EPackage;

public class PrepareReliabiltyBlackboardPartionJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(PrepareReliabiltyBlackboardPartionJob.class);
    private static final String JOB_NAME = "Prepare Reliability Blackboard Partions";
    public static final EPackage[] RELIABILITY_EPACKAGES = new EPackage[]{CorePackage.eINSTANCE, DtmcPackage.eINSTANCE};
    private MDSDBlackboard blackboard;
    private PrepareReliabilityBlackboardPartitionConf conf;

    public PrepareReliabiltyBlackboardPartionJob(PrepareReliabilityBlackboardPartitionConf conf) {
        this.conf = conf;
    }

    private void check() throws JobFailedException {
        if (!this.conf.isValid()) {
            throw new JobFailedException(this.conf.getErrorMessage());
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.check();
        logger.debug((Object)"Creating Reliability Model Partition");
        ResourceSetPartition myPartion = new ResourceSetPartition();
        this.blackboard.addPartition(this.conf.getPartitionName(), (Object)myPartion);
        logger.debug((Object)"Initialising Reliability EPackages");
        myPartion.initialiseResourceSetEPackages(RELIABILITY_EPACKAGES);
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        this.blackboard.removePartition(this.conf.getPartitionName());
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

