/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJob;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJobConf;
import eu.qimpress.ide.backbone.core.operations.SaveQModelUIOperation;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.Reliability;
import eu.qimpress.resultmodel.ReliabilityPredictionResult;
import eu.qimpress.resultmodel.ResultDistribution;
import eu.qimpress.resultmodel.ResultModelFactory;
import eu.qimpress.resultmodel.ResultModelPackage;
import eu.qimpress.samm.usagemodel.SystemCall;
import eu.qimpress.samm.usagemodel.UsageScenario;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class FillResultsModelJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private Logger logger = Logger.getLogger(FillResultsModelJob.class);
    private static final String JOB_NAME = "Fill Results Model Job";
    private MDSDBlackboard blackboard;
    private SysCallAnalysisJob sysCallAnalysis;
    private SysCallAnalysisJobConf conf;
    private ReliabilityPredictionResult reliabilityPredictionResult;

    public FillResultsModelJob(SysCallAnalysisJobConf conf, SysCallAnalysisJob sysCallAnalysis) {
        this.conf = conf;
        this.sysCallAnalysis = sysCallAnalysis;
    }

    private void check() throws JobFailedException {
        if (!this.conf.isValid()) {
            throw new JobFailedException(this.conf.getErrorMessage());
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.check();
        ResultModelFactory factory = ResultModelPackage.eINSTANCE.getResultModelFactory();
        AlternativeEvaluation ae = this.conf.getReliabilityConf().getAlternativeEvaluation();
        if (ae == null) {
            throw new JobFailedException("Failed to retrieve analysis result model.");
        }
        this.logger.debug((Object)"Adding prediction results...");
        this.reliabilityPredictionResult = factory.createReliabilityPredictionResult();
        ae.getAnalysisResults().add((Object)this.reliabilityPredictionResult);
        this.reliabilityPredictionResult.getReliabilities();
        ResultDistribution distribution = factory.createResultDistribution();
        distribution.set_10PercentQuantile(this.sysCallAnalysis.getResult().getReliability());
        distribution.set_90PercentQuantile(this.sysCallAnalysis.getResult().getReliability());
        distribution.setArithmeticMean(this.sysCallAnalysis.getResult().getReliability());
        distribution.setMedian(this.sysCallAnalysis.getResult().getReliability());
        Reliability reliability = factory.createReliability();
        reliability.setResultDistribution(distribution);
        for (UsageScenario us : this.conf.getReliabilityConf().getUsageModel().getUsageScenarios()) {
            if (!us.getId().contentEquals(this.conf.getUsageScenarioId())) continue;
            reliability.setSystemCall((SystemCall)us.getSystemCalls().get(0));
        }
        this.logger.debug((Object)"Adding reliability result...");
        this.reliabilityPredictionResult.getReliabilities().add((Object)reliability);
        this.logger.debug((Object)"Update alternative evaluation...");
        ae.setAlternativeId(this.conf.getReliabilityConf().getAlternativeId());
        ae.setRunDate(new Date());
        this.logger.debug((Object)"Loading samm...");
        ae.setServiceArchitectureModel(this.conf.getReliabilityConf().getServiceArchitecturalModel());
        this.logger.debug((Object)"Set usage model...");
        ae.setUsageModel(this.conf.getReliabilityConf().getUsageModel());
        try {
            new SaveQModelUIOperation(this.conf.getReliabilityConf().getResultsModel()).run(monitor);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JobFailedException("Failed to save result model.");
        }
        catch (InterruptedException interruptedException) {
            throw new JobFailedException("Failed to save result model.");
        }
    }

    public String getName() {
        return JOB_NAME;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

