/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.derivation;

import de.fzi.kamp.derivation.CorrespondingContainerFinder;
import de.fzi.kamp.derivation.DiffModelVisitor;
import de.fzi.kamp.derivation.IArchitectureModelResolver;
import de.fzi.kamp.derivation.IContainerFactory;
import de.fzi.kamp.derivation.IWorkplanBuilderResolver;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import eu.qimpress.samm.core.NamedEntity;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.ecore.EObject;

public class DiffWorkplanBuilder {
    private static final Logger logger = Logger.getLogger(DiffWorkplanBuilder.class);
    private DiffModel diff;
    private Workplan workplan;
    private IArchitectureModelResolver architectureModelResolver;
    private EffortAnalysisInstance analysisInstance;
    private CompositeTask rootTaskInWorkplan;
    private CompositeTaskDerivationContainer compositeTaskDerivationContainer;
    private IWorkplanBuilderResolver builderResolver;
    private DiffModelVisitor diffModelVisitor;
    private CorrespondingContainerFinder containerFinder;

    public DiffWorkplanBuilder(DiffModel diff, EffortAnalysisInstance analysisInstance, IArchitectureModelResolver architectureModelResolver, IContainerFactory containerFactory, IWorkplanBuilderResolver builderResolver) {
        this.diff = diff;
        this.architectureModelResolver = architectureModelResolver;
        this.analysisInstance = analysisInstance;
        this.builderResolver = builderResolver;
        if (analysisInstance.getWorkplan() == null) {
            analysisInstance.setWorkplan(WorkplanFactory.eINSTANCE.createWorkplan());
        }
        this.workplan = analysisInstance.getWorkplan();
        this.addRootCompositeToWorkplan();
        this.createWorkplanDerivationContainer(architectureModelResolver, containerFactory);
        this.containerFinder = new CorrespondingContainerFinder(this.getCompositeTaskDerivationContainer());
        this.diffModelVisitor = new DiffModelVisitor(this);
    }

    private void addRootCompositeToWorkplan() {
        this.rootTaskInWorkplan = WorkplanFactory.eINSTANCE.createCompositeTask();
        this.rootTaskInWorkplan.setName("Workplan");
        TaskRationale rationale = WorkplanFactory.eINSTANCE.createTaskRationale();
        rationale.setDescription("");
        rationale.setKeyword("Complete Workplan");
        this.rootTaskInWorkplan.setTaskrationale(rationale);
        this.workplan.getTasks().add((Object)this.rootTaskInWorkplan);
    }

    private void createWorkplanDerivationContainer(IArchitectureModelResolver architectureModelProvider, IContainerFactory containerFactory) {
        this.compositeTaskDerivationContainer = containerFactory.createContainer(architectureModelProvider, this.analysisInstance, this.rootTaskInWorkplan);
        this.workplan.getCompositetaskderivationcontainer().add((Object)this.compositeTaskDerivationContainer);
    }

    public void buildWorkplanFromDiffResult() {
        TreeIterator iterator = this.diff.eAllContents();
        while (iterator.hasNext()) {
            EObject el = (EObject)iterator.next();
            this.diffModelVisitor.doSwitch(el);
        }
        this.builderResolver.fillTasklistOfWorkplan(this.compositeTaskDerivationContainer, this.workplan);
        this.builderResolver.showWorkplanChanges(this.analysisInstance);
    }

    public void findAndSelectContainer(NamedEntity modelElement, BasicActivity basicActivity) {
        AbstractModelElement proxy = this.architectureModelResolver.getProxy(modelElement);
        if (proxy != null) {
            AbstractContainer container = (AbstractContainer)this.containerFinder.doSwitch((EObject)proxy);
            if (container != null) {
                container.setSelected(true);
                container.setBasicActivity(basicActivity);
            } else {
                logger.warn((Object)("AbstractContainer for Modelelement: " + modelElement.getName() + " of Type " + modelElement.getClass().toString() + " not found."));
            }
        }
    }

    public IArchitectureModelResolver getArchitectureModelResolver() {
        return this.architectureModelResolver;
    }

    public Workplan getWorkplan() {
        return this.workplan;
    }

    public CompositeTaskDerivationContainer getCompositeTaskDerivationContainer() {
        return this.compositeTaskDerivationContainer;
    }
}

