/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui.tabs;

import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.ui.SWTHelper;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExportTab
extends AbstractLaunchConfigurationTab {
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ExportTab.this.setDirty(true);
            ExportTab.this.updateLaunchConfigurationDialog();
        }
    };
    private HashMap<String, Widget> id2widgetMap;
    public static final String SISSY2GAST_DERBY_FILEPATH = "sissy2gast.derbyfilepath";
    public static final String SISSY2GAST_SQLITE_FILEPATH = "sissy2gast.sqlitefilepath";
    public static final String SISSY2GAST_TEXT_DB_SERVERURL = "sissy2gast.dbserverurl";
    public static final String SISSY2GAST_TEXT_DB_NAME = "sissy2gast.dbname";
    public static final String SISSY2GAST_TEXT_DB_USER = "sissy2gast.dbuser";
    public static final String SISSY2GAST_TEXT_DB_PWD = "sissy2gast.dbpwd";
    public static final String SISSY2GAST_DB_DRIVER_SELECTION = "sissy2gast.dbdriverselection";

    public void createControl(Composite parent) {
        this.id2widgetMap = new HashMap();
        ScrolledComposite scrollContainer = new ScrolledComposite(parent, 2560);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite container = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)container);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(768));
        final Combo dbSelectionCombo = this.addDatabaseSelectionCombo(container);
        dbSelectionCombo.addModifyListener(this.modifyListener);
        final Group dbConfigGroup = this.createDBConfigWidgets(container);
        final Group compDerby = SWTHelper.addGroup(container, "Derby Specific Parameter");
        SWTHelper.createTextAndTwoFileChooser(SISSY2GAST_DERBY_FILEPATH, this.id2widgetMap, (Composite)compDerby, "Derby DB Filesystem Base-Path:", this.modifyListener, 2);
        final Group compSqlite = SWTHelper.addGroup(container, "Sqlite Specific Parameter");
        SWTHelper.createTextAndTwoFileChooser(SISSY2GAST_SQLITE_FILEPATH, this.id2widgetMap, (Composite)compSqlite, "Sqlite DB Filesystem Base-Path:", this.modifyListener, 2);
        dbSelectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SWTHelper.ableCompositeDemo((Composite)compDerby, dbSelectionCombo.getText().equals(DatabaseConfiguration.DatabaseDriver.DERBY.name()));
                SWTHelper.ableCompositeDemo((Composite)compSqlite, dbSelectionCombo.getText().equals(DatabaseConfiguration.DatabaseDriver.SQLITE.name()));
                SWTHelper.ableCompositeDemo((Composite)dbConfigGroup, !dbSelectionCombo.getText().equals(DatabaseConfiguration.DatabaseDriver.NONE.name()));
            }
        });
        container.setSize(container.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
    }

    private Combo addDatabaseSelectionCombo(Composite container) {
        Composite comp = SWTHelper.addComposite(container);
        SWTHelper.addLabel(comp, "Select Database Driver:");
        Combo dbDriverSelection = new Combo(comp, 0);
        dbDriverSelection.setLayoutData((Object)new GridData(768));
        DatabaseConfiguration.DatabaseDriver[] databaseDriverArray = DatabaseConfiguration.DatabaseDriver.values();
        int n = databaseDriverArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseConfiguration.DatabaseDriver value = databaseDriverArray[n2];
            dbDriverSelection.add(value.name());
            ++n2;
        }
        this.id2widgetMap.put(SISSY2GAST_DB_DRIVER_SELECTION, (Widget)dbDriverSelection);
        return dbDriverSelection;
    }

    private Group createDBConfigWidgets(Composite parent) {
        Group parentComp = SWTHelper.addGroup(parent, "Database Connection Parameters");
        this.createConnectionParamatersWidgets(parentComp);
        return parentComp;
    }

    private void createConnectionParamatersWidgets(Group parentComp) {
        Composite comp = SWTHelper.addComposite((Composite)parentComp);
        SWTHelper.addLabel(comp, "DB-ServerUrl");
        Text text = SWTHelper.addText(comp, this.modifyListener);
        this.id2widgetMap.put(SISSY2GAST_TEXT_DB_SERVERURL, (Widget)text);
        comp = SWTHelper.addComposite((Composite)parentComp);
        SWTHelper.addLabel(comp, "DB-Name:");
        text = SWTHelper.addText(comp, this.modifyListener);
        this.id2widgetMap.put(SISSY2GAST_TEXT_DB_NAME, (Widget)text);
        comp = SWTHelper.addComposite((Composite)parentComp);
        SWTHelper.addLabel(comp, "DB-Username:");
        text = SWTHelper.addText(comp, this.modifyListener);
        this.id2widgetMap.put(SISSY2GAST_TEXT_DB_USER, (Widget)text);
        comp = SWTHelper.addComposite((Composite)parentComp);
        SWTHelper.addLabel(comp, "DB-Password:");
        text = SWTHelper.addText(comp, this.modifyListener);
        text.setEchoChar('*');
        this.id2widgetMap.put(SISSY2GAST_TEXT_DB_PWD, (Widget)text);
    }

    public String getName() {
        return "Database Settings";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        for (String key : this.id2widgetMap.keySet()) {
            Widget mappedWidget = this.id2widgetMap.get(key);
            if (mappedWidget instanceof Text) {
                Text cfr_ignored_0 = (Text)mappedWidget;
                try {
                    ((Text)mappedWidget).setText(configuration.getAttribute(key, ""));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (mappedWidget instanceof Button) {
                Button button = (Button)mappedWidget;
                try {
                    if (configuration.getAttribute(key, "false").equals("true")) {
                        button.setSelection(true);
                        continue;
                    }
                    button.setSelection(false);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(mappedWidget instanceof Combo)) continue;
            Combo combo = (Combo)mappedWidget;
            try {
                combo.setText(configuration.getAttribute(key, "NONE"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        for (String key : this.id2widgetMap.keySet()) {
            Widget mappedWidget = this.id2widgetMap.get(key);
            if (mappedWidget instanceof Text) {
                Text text = (Text)mappedWidget;
                configuration.setAttribute(key, text.getText());
                continue;
            }
            if (mappedWidget instanceof Button) {
                Button button = (Button)mappedWidget;
                if (button.getSelection()) {
                    configuration.setAttribute(key, "true");
                    continue;
                }
                configuration.setAttribute(key, "false");
                continue;
            }
            if (!(mappedWidget instanceof Combo)) continue;
            Combo combo = (Combo)mappedWidget;
            configuration.setAttribute(key, combo.getText());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SISSY2GAST_DERBY_FILEPATH, "");
        configuration.setAttribute(SISSY2GAST_TEXT_DB_SERVERURL, "<hostname>[,<failoverhost>][<:port>]");
        configuration.setAttribute(SISSY2GAST_TEXT_DB_NAME, "SISSy");
        configuration.setAttribute(SISSY2GAST_TEXT_DB_PWD, "sissy");
        configuration.setAttribute(SISSY2GAST_TEXT_DB_USER, "sissy");
        configuration.setAttribute(SISSY2GAST_DB_DRIVER_SELECTION, DatabaseConfiguration.DatabaseDriver.NONE.name());
    }
}

