/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public class JDTHelper {
    private static final Logger logger = Logger.getLogger(JDTHelper.class);

    private static List<IProject> getProjectsFromWorkspace(Collection<String> projectNames) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        ArrayList<String> copyOfProjectNames = new ArrayList<String>(projectNames);
        ArrayList<IProject> foundProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (copyOfProjectNames.contains(project.getName())) {
                foundProjects.add(project);
                copyOfProjectNames.remove(project.getName());
            }
            ++n2;
        }
        for (String projectName : copyOfProjectNames) {
            logger.error((Object)("project is not in workspace: \"" + projectName + "\""));
        }
        return foundProjects;
    }

    public static List<String> extractSourceFoldersFromJavaProjects(Collection<String> projectNames) {
        List<IProject> foundProjects = JDTHelper.getProjectsFromWorkspace(projectNames);
        return new ArrayList<String>(JDTHelper.extractSourceFoldersFromJavaProjects(foundProjects));
    }

    static Set<String> extractSourceFoldersFromJavaProjects(List<IProject> projects) {
        List<IJavaProject> javaProjects = JDTHelper.filterNonJavaProjects(projects);
        HashSet<String> sourceFolders = new HashSet<String>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        for (IJavaProject javaProject : javaProjects) {
            try {
                IClasspathEntry[] resolvedClasspath;
                IClasspathEntry[] iClasspathEntryArray = resolvedClasspath = javaProject.getResolvedClasspath(false);
                int n = resolvedClasspath.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                    if (3 == classPathEntry.getEntryKind()) {
                        IFile file = root.getFile(classPathEntry.getPath());
                        sourceFolders.add(file.getLocation().toOSString());
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                logger.error((Object)("unable to determin sourcefolder for java project " + javaProject), (Throwable)e);
            }
        }
        return sourceFolders;
    }

    public static List<String> extractRequiredJavaLibraries(Collection<String> projectNames) {
        List<IProject> foundProjects = JDTHelper.getProjectsFromWorkspace(projectNames);
        return JDTHelper.extractRequiredJavaLibraries(foundProjects);
    }

    private static List<IJavaProject> filterNonJavaProjects(List<IProject> projects) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        for (IProject project : projects) {
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    logger.warn((Object)("\"" + project.getName() + "\" is not a java project -> skip project"));
                    continue;
                }
                javaProjects.add(JavaCore.create((IProject)project));
            }
            catch (CoreException e) {
                logger.error((Object)"Error converting an IProject to an IJavaProject", (Throwable)e);
            }
        }
        return javaProjects;
    }

    static List<String> extractRequiredJavaLibraries(List<IProject> projects) {
        List<IJavaProject> javaProjects = JDTHelper.filterNonJavaProjects(projects);
        ArrayList<String> resolvedLibraries = new ArrayList<String>();
        JDTHelper.collectProjectsCombinedClassPath(javaProjects, resolvedLibraries);
        JDTHelper.removeProjectsOutputFolders(javaProjects, resolvedLibraries);
        return resolvedLibraries;
    }

    public static boolean usesInclusionOrExclusionPattern(List<String> projects) throws JavaModelException {
        List<IJavaProject> javaProjects = JDTHelper.getJavaProjectsFromWorkspace(projects);
        for (IJavaProject javaProject : javaProjects) {
            IClasspathEntry[] resolvedClasspath;
            IClasspathEntry[] iClasspathEntryArray = resolvedClasspath = javaProject.getResolvedClasspath(true);
            int n = resolvedClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (3 == classPathEntry.getEntryKind()) {
                    boolean usesInclusionPattern = !JDTHelper.isArrayNullOrEmpty(classPathEntry.getInclusionPatterns());
                    boolean usesExclusionPattern = !JDTHelper.isArrayNullOrEmpty(classPathEntry.getExclusionPatterns());
                    logger.info((Object)("project \"" + javaProject.getElementName() + "\"\n\tusesInclusionPattern: " + usesInclusionPattern + "\n\tusesExclusionPattern: " + usesExclusionPattern));
                    if (usesInclusionPattern || usesExclusionPattern) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean isArrayNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static List<IJavaProject> getJavaProjectsFromWorkspace(List<String> projects) {
        List<IProject> projectsFromWorkspace = JDTHelper.getProjectsFromWorkspace(projects);
        List<IJavaProject> javaProjects = JDTHelper.filterNonJavaProjects(projectsFromWorkspace);
        return javaProjects;
    }

    public static List<String> extractAllJavaSourceFiles(List<String> projects) throws JavaModelException {
        List<IJavaProject> javaProjects = JDTHelper.getJavaProjectsFromWorkspace(projects);
        ArrayList<String> result = new ArrayList<String>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (IJavaProject project : javaProjects) {
            IPackageFragmentRoot[] packageFragmentRoots = project.getPackageFragmentRoots();
            logger.info((Object)("there are " + packageFragmentRoots.length + " PackageFragementRoots"));
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots;
            int n = packageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot pfRoot = iPackageFragmentRootArray[n2];
                if (1 == pfRoot.getKind()) {
                    IJavaElement[] iJavaElementArray = pfRoot.getChildren();
                    int n3 = iJavaElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement element = iJavaElementArray[n4];
                        IPackageFragment fragment = (IPackageFragment)element;
                        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                        int n5 = iCompilationUnitArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit compilationUnit = iCompilationUnitArray[n6];
                            result.add(root.getFile(compilationUnit.getPath()).getLocation().toOSString());
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static void collectProjectsCombinedClassPath(List<IJavaProject> javaProjects, List<String> resolvedLibraries) {
        for (IJavaProject javaProject : javaProjects) {
            try {
                String[] classPath;
                String[] stringArray = classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
                int n = classPath.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    if (!resolvedLibraries.contains(element)) {
                        resolvedLibraries.add(element);
                    } else {
                        logger.info((Object)("dependency already known: \"" + element + "\""));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                logger.error((Object)("unable to determin RefaultRuntimeClasspath of the javaproject  " + javaProject), (Throwable)e);
            }
        }
    }

    private static void removeProjectsOutputFolders(Collection<IJavaProject> projects, List<String> resolvedLibraries) {
        for (IJavaProject javaProject : projects) {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                IPath path = javaProject.getOutputLocation();
                IResource member = root.findMember(path);
                String buildFolder = member.getLocation().makeAbsolute().toOSString();
                if (resolvedLibraries.remove(buildFolder)) continue;
                throw new IllegalArgumentException();
            }
            catch (JavaModelException javaModelException) {
                logger.error((Object)"unable to remove projects bin path");
            }
        }
    }

    public static List<String> allProjectsAvailable(List<String> selectedProjects) {
        ArrayList<String> copyOfSelectedProjects = new ArrayList<String>(selectedProjects);
        List<IProject> projectsFromWorkspace = JDTHelper.getProjectsFromWorkspace(copyOfSelectedProjects);
        for (IProject project : projectsFromWorkspace) {
            copyOfSelectedProjects.remove(project.getName());
        }
        return copyOfSelectedProjects;
    }

    public static String composeToString(Collection<String> strings) {
        ArrayList<String> jars = new ArrayList<String>(strings);
        Collections.sort(jars);
        StringBuilder builder = new StringBuilder();
        for (String string : jars) {
            builder.append(string);
            builder.append(File.pathSeparator);
            builder.append("\n");
        }
        if (!strings.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private JDTHelper() {
    }
}

