/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.ui;

import de.fzi.sissy.ui.JDTHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CreateLaunchConfigDelegate {
    private List<IProject> selectedProjects;
    private String usedLaunchConfigurationType;
    private String usedLaunchPrefix;
    private Logger logger = Logger.getLogger((String)"de.fzi.sissy");
    private AbstractLaunchConfigurationTab helperWeightTab;

    public CreateLaunchConfigDelegate(String usedLaunchConfigurationType, String usedLaunchPrefix, AbstractLaunchConfigurationTab wTab) {
        this.usedLaunchConfigurationType = usedLaunchConfigurationType;
        this.usedLaunchPrefix = usedLaunchPrefix;
        this.helperWeightTab = wTab;
    }

    public void run(IAction action) {
        if (this.selectedProjects != null && !this.selectedProjects.isEmpty()) {
            String srcFolders = JDTHelper.composeToString(JDTHelper.extractSourceFoldersFromJavaProjects(this.selectedProjects));
            this.logger.debug((Object)("src: " + srcFolders));
            String libs = JDTHelper.composeToString(JDTHelper.extractRequiredJavaLibraries(this.selectedProjects));
            this.logger.debug((Object)("libs: " + libs));
            String projectName = this.selectedProjects.get(0).getName();
            String newConfigName = this.createLaunchConfiguration(this.usedLaunchPrefix, projectName, srcFolders, libs, this.usedLaunchConfigurationType);
            this.openLaunchConfiguration(newConfigName);
        }
    }

    private String createLaunchConfiguration(String prefixNewConfig, String projectName, String srcFolders, String libs, String launchTypeID) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(launchTypeID);
        ILaunchConfigurationWorkingCopy workingCopy = null;
        String newConfigName = null;
        try {
            newConfigName = manager.generateUniqueLaunchConfigurationNameFrom(String.valueOf(prefixNewConfig) + projectName);
            workingCopy = type.newInstance(null, newConfigName);
            workingCopy.setAttribute("sissy2gast.textinputfile", srcFolders);
            workingCopy.setAttribute("sissy2gast.textlibbin", libs);
            workingCopy.setAttribute("sissy2gast.optionjava", true);
            workingCopy.setAttribute("sissy2gast.optioncpp", false);
            workingCopy.setAttribute("sissy2gast.checkrunsissy", true);
            workingCopy.setAttribute("sissy2gast.checkexportyesno", true);
            workingCopy.setAttribute("sissy2gast.combosourcelevel", "5.0");
            if (this.helperWeightTab != null) {
                this.helperWeightTab.setDefaults(workingCopy);
            }
            workingCopy.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return newConfigName;
    }

    private void openLaunchConfiguration(String newConfigName) {
        if (newConfigName != null && !newConfigName.equals("")) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration configurationToOpen = null;
            configurationToOpen = this.getConfigToOpen(manager, newConfigName);
            this.logger.debug((Object)("open with " + configurationToOpen.getName()));
            DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)configurationToOpen), (String)"org.eclipse.debug.ui.launchGroup.run");
        }
    }

    private ILaunchConfiguration getConfigToOpen(ILaunchManager manager, String newConfigName) {
        ILaunchConfiguration configurationToOpen = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equals(newConfigName)) {
                    configurationToOpen = config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return configurationToOpen;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection s = (IStructuredSelection)selection;
        this.selectedProjects = new ArrayList<IProject>();
        for (Object project : s.toList()) {
            if (project instanceof IJavaProject) {
                this.selectedProjects.add(((IJavaProject)project).getProject());
                continue;
            }
            if (!(project instanceof IProject)) continue;
            this.selectedProjects.add((IProject)project);
        }
    }
}

