/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

select
	null as package_name,
	null as class_name,
	c.name as element_type,
	f.pathName as element_name,
	length(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.')) - 2 as element_name_length
from
	TFiles f inner join
	TModelElements mF on (f.id = mF.id and mF.status = 161 /*STATUS_NORMAL*/) join
	TConstants c on c.value = f.kindOfFile and
		(length(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.')) > 52 or
			length(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.')) < 4)
	
union

select
	p.fullName as package_name,
	t.name as class_name,
	c.name as element_type,
	e.name as element_name,
	length(e.name) as element_name_length
from
	TConstants c join
	TModelElements e on (e.kindOfElement = c.value and e.status = 161 /*STATUS_NORMAL*/ and
		(length(e.name) > 50 or (length(e.name) > 0 AND length(e.name) < 2)) and
		((e.kindOfElement >= 17 and e.kindOfElement <= 19) /*PACK_%*/ or
		(e.kindOfElement >= 34 and e.kindOfElement <= 38) /*TYPE_%CLASS or TYPE_%INTERFACE*/ or
		(e.kindOfElement = 49) /*FUNC_TYPE_DELEGATE*/ or
		(e.kindOfElement >=50 and e.kindOfElement <= 52) /*FUNC_METHOD or FUNC_GLOBALFUNC or FUNC_GENERIC*/ or
		(e.kindOfElement = 65) /*VAR_FIELD*/ or
		(e.kindOfElement = 67) /*VAR_GLOBALVAR*/ or
		(e.kindOfElement = 70) /*VAR_PROPERTY*/
		)) left outer join
	TSourceEntities sourceEntities on e.id = sourceEntities.id left outer join
	TFiles files on (sourceEntities.sourcefileid = files.id) left outer join
	TTypes t on e.parentId = t.id left outer join
	TPackages p on e.parentId = p.id or 
		t.packageId = p.id


UNION

/* Subsystem names, which are either too long or too short */

SELECT
	null as package_name,
	null as class_name,
	'ABSTRACTION_SUBSYSTEM' as element_type,
	abstraction.name as element_name,
	length(abstraction.name) as element_name_length
FROM
	TAbstractions abstraction
WHERE
	abstraction.kindofabstraction = 124 /*ABSTRACTION_SUBSYSTEM*/
	AND ((length(abstraction.name) > 50)  
	OR ((length(abstraction.name) > 0) AND (length(abstraction.name) < 2)))		
;
