/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT 
	subclasspackage.fullname as containing_package_name, 
	baseclasspackage.fullname as contained_package_name,
	subclass.name as subclass_full_name,
	baseclass.name as superclass_full_name,
	inheritsfrom.depthofinheritance as depth_of_inheritance,
	subfile.pathname as subclass_file_name,
	subsource.startLine as subclass_line_number,
	basefile.pathname as superclass_file_name,
	basesource.startLine as superclass_line_number
FROM 
	ttypes AS subclass join
	TModelElements AS mSubClass on (mSubClass.id = subClass.id) join
	TConstants AS cmSubClass on (cmSubClass.value = mSubClass.status AND cmSubClass.name = 'STATUS_NORMAL') join
	tinheritances AS inheritsfrom on (inheritsfrom.classid = subclass.id AND inheritsfrom.depthofinheritance = 1) join
	ttypes AS baseclass on (baseclass.id = inheritsfrom.superid) join
	TModelElements AS mBaseClass on (mBaseClass.id = baseClass.id) join
	TConstants AS cmBaseClass on (cmBaseClass.value = mBaseClass.status AND cmBaseClass.name = 'STATUS_NORMAL') join
	tpackages AS baseclasspackage on (baseclasspackage.id = baseclass.packageid AND baseclasspackage.fullName != '') join
	tpackages AS subclasspackage on (subclasspackage.id = subclass.packageid AND subclasspackage.fullName != '' AND baseclasspackage.id != subclasspackage.id) join
	TSourceEntities AS subsource on (subsource.id = subclass.id) join
	TFiles AS subfile on (subfile.id = subsource.sourcefileid) join
	TSourceEntities AS basesource on (basesource.id = baseclass.id) join
	TFiles AS basefile on (basefile.id = basesource.sourcefileid) join
	TPackageContainmentRelations AS pcr on (pcr.packageid =  baseclasspackage.id AND pcr.containingpackageid = subclasspackage.id)
ORDER BY
	inheritsfrom.depthofinheritance
;
