/* $Id: PermissiveVisibilityMethod.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */

CREATE VIEW VppsMethod AS
(
SELECT
	myfunction.id,
	myfunction.name,
	myfunction.classid
FROM
	TFunctions myfunction join 
	TModelElements mFunction on (myfunction.id = mFunction.id) join
	TConstants cmFunction on (cmFunction.value = mFunction.status and cmFunction.name = 'STATUS_NORMAL') join
	TConstants cons on (myfunction.kindoffunction = cons.value AND cons.name = 'FUNC_METHOD') join
	TMembers member on (member.id = myfunction.id) join
	TConstants cons2 on (member.visibility = cons2.value AND cons2.name ='VISIBILITY_PROTECTED')

EXCEPT

SELECT
	myfunction.id,
	myfunction.name,
	myfunction.classid
FROM
	TFunctions myfunction join
	TTypes type on (myfunction.classid = type.id) join
	TInheritances inheritance on (inheritance.superid = type.id) join
	TTypes subType on (inheritance.classid = subtype.id) join
	TAccesses access on (myfunction.id = access.targetid and access.classid = subtype.id)

EXCEPT

/* Methoden, die in einer Unterklasse berschrieben werden */
SELECT
	myfunction.id,
	myfunction.name,
	myfunction.classid
FROM
	TFunctions myfunction join
	TTypes type on (myfunction.classid = type.id) join
	TInheritances inheritance on (inheritance.superid = type.id) join
	TTypes subType on (inheritance.classid = subtype.id) join 
	TSignatures signaturOverriddenMethod on (myfunction.id = signaturOverriddenMethod.functionid) join
	TSignatures signatureOverridingMethod on (signaturOverriddenMethod.signature = signatureOverridingMethod.signature) join
	TFunctions overridingmethod on (overridingMethod.id = signatureOverridingMethod.functionid AND overridingmethod.classid = subType.id)

EXCEPT

/* Methoden, die eine Methode einer Oberklasse berschreiben */
SELECT
	myfunction.id,
	myfunction.name,
	myfunction.classid
FROM
	TFunctions myfunction join
	TTypes type on (myfunction.classid = type.id) join
	TInheritances inheritance on (inheritance.classid = type.id) join
	TTypes superType on (inheritance.superid = supertype.id) join 
	TSignatures signaturOverridingMethod on (myfunction.id = signaturOverridingMethod.functionid) join
	TSignatures signatureOverriddenMethod on (signaturOverridingMethod.signature = signatureOverriddenMethod.signature) join
	TFunctions overriddenmethod on (overriddenMethod.id = signatureOverriddenMethod.functionid AND overriddenmethod.classid = superType.id)
)
;

SELECT 
        p.fullname as package_full_name,
	type.fullname as class_full_name,
	sig.signature as signature,
        se.startline as line_number,
	file.pathname AS filename
FROM
	VppsMethod myfunction join
	TSourceEntities se on (myfunction.id = se.id) join
        TSignatures sig on (sig.functionid = myfunction.id) join
	Tfiles file on (file.id = se.sourcefileid) join
	TTypes type on (type.id = myfunction.classid) join
        TPackages p on (p.id = type.packageid)
;

drop view VppsMethod;
