/* $Id: OrphanSiblingAttributes.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */
/* FZI Forschungszentrum Informatik */





create view VAttributeInSubClasses as

select 
	variable.name as variablename,
	supertype.id as supertypeid,
	supertype.name as supertype_name,
        supertype.fullname as supertype_fullname,
	count (supertype.id)
from
	TVariables variable join
	TModelElements m on (variable.id = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join	
	TMembers vmember on (variable.id = vmember.id) join
	TTypes type on ( variable.classid = type.id) join
	TInheritances inh on (inh.classid = type.id) join
	TTypes supertype on (inh.superid = supertype.id) join
	TConstants con on ( con.value = variable.kindofvariable) join
	TSourceEntities source on (source.id = supertype.id) join
	TFiles file on (source.sourcefileid = file.id)
where
	con.name = 'VAR_FIELD' and
	inh.depthofinheritance = 1 and
	variable.name <> '<self>' and
	vmember.isstatic = 0 and

	not exists (
		select
			*
		from
			TVariables variable2 
		where
			variable2.classid = supertype.id and
			variable2.name = variable.name
	)

			
group by
	variable.name,
	supertype.id,
	supertype.name,
        supertype.fullname
;


create view VNumberOfSubclasses as
select 
	type.id,
	type.name,
	count (inh.classid)
from
	TTypes type join
	TInheritances inh on (inh.superid = type.id)
where
	inh.depthofinheritance = 1
group by
	type.id,
	type.name
;

select 
        p.fullname as package_name,
	aisc.supertype_fullname as superclass_fullname,
        file_superclass.pathname as superclass_file_name,
        aisc.variablename as field_name,
        aisc.count as number_of_sibling_attributes,
        nosc.count as number_of_subclasses
from
	VAttributeInSubClasses aisc join
	VNumberOfSubclasses nosc on (aisc.supertypeid = nosc.id) join

        TTypes superclass on (superclass.id = aisc.supertypeid) join
        TPackages p on (p.id = superclass.packageid) left outer join

        TSourceEntities src_superclass on (src_superclass.id = superclass.id) left outer join
        TFiles file_superclass on (file_superclass.id = src_superclass.sourcefileid)

where
	aisc.count > 1 and (
	aisc.count >= 10 or 
	((aisc.count * 1.0) / (nosc.count * 1.0) > 0.5)
	)
;


drop view VNumberOfSubclasses;
drop view VAttributeInSubClasses;



