/* $Id: MisleadingNamingFiles.sql,v 1.1 2010/04/19 16:31:52 stammel Exp $ */
/* FZI Forschungszentrum Informatik */




create view VShortFileNames as

select
	f.id as FileId,
	substring(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.[a-zA-Z0-9\\_]*$') from 2 for 
		strpos(substring(f.pathName from '[\\\\/][a-zA-Z0-9\\_]*\\.[a-zA-Z0-9\\_]*$'), '.') - 2) as ShortFileName
from
	TFiles f
;




select  Distinct
	f.pathname as file_name
from
	TFiles f join
	TModelElements mFile on (f.id = mFile.id) join
	TConstants cmFile on (mFile.status = cmFile.value and cmFile.name = 'STATUS_NORMAL') join
	TConstants con on (f.kindoffile = con.value) join
	TSourceEntities se on (se.sourcefileid = f.id) join
	TTypes t on (t.id = se.id)
where
	con.name = 'FILE_SOURCE'

except

select  distinct
	f.pathname as Filename

from
	TFiles f join
	VShortFileNames v on v.fileId = f.id join
	TSourceEntities s on f.id = s.sourceFileId join
	TTypes t on t.id = s.id join
	TMembers m on t.id = m.id and
		m.classId = -1
where
	strpos(lower(t.name), lower(v.shortFileName)) <> 0
;



drop view VShortFileNames;
