/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table VKnowsRel (classId int, className varchar(256), knownClassId int, knownClassName varchar(256)); 

insert into VKnowsRel 
select distinct 
	res.classId, 
	res.className,
	res.knownClassId, 
	res.knownClassName
from 
	(
	/* Type accesses including declaration type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls, 
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = knowncls.id
		
	union

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union


	
	/* Accesses to members */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TTypes as cls, 
		TAccesses acc, 
		TMembers as dm, 
		TTypes knowncls
	where	
		cls.id = acc.classId and
		acc.targetId = dm.id and
		dm.classId = knowncls.id
	) as res, 
	TTypes as types, 
	TConstants as c
where	
	res.classId != res.knownClassId and
	res.knownClassId = types.id and
	types.kindOfType = c.value and
	(c.name like '%CLASS' or 
		c.name like '%INTERFACE')
;


SELECT DISTINCT
	child.fullName AS subclass_name, 
	parent.fullName AS superclass_name,
	childFile.pathname AS subclass_file_name,
	childSource.startline as subclass_line_number,
	parentFile.pathname AS superclass_file_name,
	parentSource.startline as superclass_line_number
FROM 
    VKnowsRel vKnowsRel
	join TTypes parent on vknowsRel.classId = parent.id
	join TTypes child  on vknowsRel.knownClassId = child.id
	join TInheritances i on i.superId = parent.id and i.classId = child.id
	join TSourceEntities childSource on childSource.id = child.id
	join TSourceEntities parentSource on parentSource.id = parent.id
	join TFiles childFile on childfile.id = childsource.sourcefileid
	join TFiles parentFile on parentfile.id = parentsource.sourcefileid
	join TModelElements mChild on mChild.id = child.id 
	join TModelElements mParent on mParent.id = parent.id 
	join TConstants cmChild on mChild.status = cmChild.value
	join TConstants cmParent on mParent.status = cmParent.value
WHERE 
	cmChild.name = 'STATUS_NORMAL'
	AND cmParent.name = 'STATUS_NORMAL'
	/* auch statische Abhngigkeiten sollten bercksichtigt werden */
	/* vknowsRel.isStatic = false AND */
;

DROP TABLE VKnowsRel;
