/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table VKnowsRel (classId int, className varchar(256), knownClassId int, knownClassName varchar(256) );

insert into VKnowsRel 
select distinct 
	res.classId, 
	res.className,
	res.knownClassId, 
	res.knownClassName
from 
	(
	/* Type accesses including declaration type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls, 
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = knowncls.id
		
	union

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union

	
	/* Accesses to members */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TTypes as cls, 
		TAccesses acc, 
		TMembers as dm, 
		TTypes knowncls
	where	
		cls.id = acc.classId and
		acc.targetId = dm.id and
		dm.classId = knowncls.id
	) as res, 
	TTypes as types
where	
	res.classId != res.knownClassId and
	res.knownClassId = types.id and
	/* 35 = TYPE_CLASS */
	/* 34 = TYPE_INTERFACE */
	(types.kindOfType = 35 or types.kindOfType = 34)
;


/* Datei benutzt andere Datei ber globale Funktionen oder Variablen */
create table VGlobalDeps (fileid int, filename varchar(256), knownfileid int, knownfilename varchar(256) );

insert into VGlobalDeps
Select 
	acFile.id as fileid,
	acFile.pathname as filename,
	funcFile.id as knownfileid,
	funcFile.pathname as knownfilename
FROM
	TAccesses ac,
	TFunctions accessedFunction,
	TSourceEntities acSource,
	TFiles	acFile,
	TSourceEntities funcSource,
	TFiles funcFile
WHERE
	ac.targetid = accessedFunction.id
	AND accessedFunction.classid = -1
	AND ac.sourceid = acSource.id
	AND acSource.sourcefileid = acFile.id
	AND funcSource.id = accessedFunction.id
	AND funcSource.sourcefileid = funcFile.id

UNION

Select 
	acFile.id as fileid,
	acFile.pathname as filename,
	varFile.id as knownfileid,
	varFile.pathname as knownfilename
FROM
	TAccesses ac,
	TVariables accessedVariable,
	TSourceEntities acSource,
	TFiles	acFile,
	TSourceEntities varSource,
	TFiles varFile
WHERE
	/* 67=VAR_GLOBALVAR */
	accessedVariable.kindofvariable = 67
	AND ac.targetid = accessedVariable.id
	AND ac.sourceid = acSource.id
	AND acSource.sourcefileid = acFile.id
	AND varSource.id = accessedVariable.id
	AND varSource.sourcefileid = varFile.id

;


/* Datei enthlt Definitionen zu Elementen einer Klasse aus einer anderen Datei */
create table VDeclaresEntitiesOfFile (typeid int, typefullname varchar(256), typefile int, typefileid int, 
typefilename varchar(256), definitionfileid int, definitionfilename varchar(256));

insert into VDeclaresEntitiesOfFile
select
	type.id as typeid,
	type.fullname as typefullname,
	tType.id as typefile,
	tFile.id as typefileid,
	tFile.pathname as typefilename,
	file.id as definitionfileid,
	file.pathname as definitionfilename
from
	TTypes type,
	TMembers mType,
	TSourceEntities semType,
	TFiles file,
	TSourceEntities tType,
	TFiles tFile
where
	mType.classid = type.id
	AND semType.id = mType.id
	AND semType.sourcefileid = file.id
	AND tType.id = type.id
	AND tFile.id = tType.sourcefileid
;

create table VFileUsesType (fileid int, pathname varchar(256), classname varchar(256), knownclassname varchar(256), knownfileid int);

/* Datei benutzt Typ aus Datei*/
insert into VFileUsesType
select
	sfile.id as fileid,
	sfile.pathname,
	knows.classname,
	knows.knownclassname,
	knownFile.id as knownfileid
from
	VKnowsRel knows,
	TSourceEntities seFile,
	TFiles sfile,
	TSourceEntities knownSE,
	TFiles knownFile
where
	seFile.id = knows.classid
	AND seFile.sourcefileid = sFile.id
	AND knows.knownclassid = knownSE.id
	AND knownFile.id = knownSE.sourcefileid
;

create table VFileNeedsToImportFile (file1id int, file2id int);

insert into VFileNeedsToImportFile
	SELECT
		file1.id as file1id,
		file2.id as file2id
	FROM
			
		TFiles file1,
		TFiles file2,
		VFileUsesType fut
	WHERE
		fut.fileid = file1.id
		AND fut.knownfileid = file2.id
	
	UNION

	SELECT
		file1.id as file1id,
		file2.id as file2id
	FROM
		TFiles file1,
		TFiles file2,
		TFiles file3,
		TImports imp,
		TIncludes inc,
		VFileUsesType fut
	WHERE
		file1.id = imp.fileid
		/* File1 imports File2 directly */
		AND file2.id = imp.targetid
		/* file3 is included somehow by file2 */
		AND file2.id = inc.fileid
		AND file3.id = inc.includedfileid
		/* file1 needs file3 and therefore the include to file2 */
		AND fut.fileid = file1.id
		AND fut.knownfileid = file3.id

		UNION

		/* A File needs to include a file that declares its entities */
		SELECT
			file1.id as file1id,
			file2.id as file2id
		FROM
			TFiles file1,
			TFiles file2,
			TImports imp,
			VDeclaresEntitiesOfFile def
		WHERE
			file1.id = imp.fileid
			AND file2.id = imp.targetid
			AND file2.id = def.typefileid
			AND file1.id = def.definitionfileid


	UNION

	/* global dependencies */

	SELECT
		file1.id as file1id,
		file2.id as file2id
	FROM	
		TFiles file1,
		TFiles file2,
		VGlobalDeps gd
	WHERE
		gd.fileid = file1.id
		AND gd.knownfileid = file2.id
	
	UNION

	SELECT
		file1.id as file1id,
		file2.id as file2id
	FROM
		TFiles file1,
		TFiles file2,
		TFiles file3,
		TImports imp,
		TIncludes inc,
		VGlobalDeps gd
	WHERE
		file1.id = imp.fileid
		/* File1 imports File2 directly */
		AND file2.id = imp.targetid
		/* file3 is included somehow by file2 */
		AND file2.id = inc.fileid
		AND file3.id = inc.includedfileid
		/* file1 needs file3 and therefore the include to file2 */
		AND gd.fileid = file1.id
		AND gd.knownfileid = file3.id			
;



select DISTINCT
	file.pathname AS containing_file_name,
	importedFile.pathname as imported_file_name,
	count (fntif.file1id) as number_of_imports
from
	TImports imp join 
	TFiles file on (imp.fileid = file.id) join
	TFiles importedFile on (imp.targetid = importedfile.id) join
	TModelElements mFile on (imp.fileid = mFile.id 	/* 161 = STATUS_NORMAL */ AND mFile.status = 161) left outer join
	VFileNeedsToImportFile fntif on (fntif.file1id = file.id and fntif.file2id = importedFile.id)
group by
	file.pathname,
	importedFile.pathname
having count(fntif.file1id) = 0
;


drop table vfileneedstoimportfile;
drop table vknowsrel;
drop table VFileUsesType;
drop table VDeclaresEntitiesOfFile;
drop table VGlobalDeps;

