/* $Id: ImportLuege.sql,v 1.1 2009/08/06 18:59:14 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


create table VKnowsRel as 

select distinct 
	res.classId, 
	res.className,
	res.knownClassId, 
	res.knownClassName,
	res.isStatic
from 
	(
	/* Type accesses including declaration type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		con.name = 'TYPEACCESS_STATIC' as IsStatic
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls, 
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = knowncls.id
		
	union
	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		con.name = 'TYPEACCESS_STATIC' as IsStatic
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union	
	/* Accesses to members */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName,
		dm.isStatic = 1 as IsStatic
	from	
		TTypes as cls, 
		TAccesses acc, 
		TMembers as dm, 
		TTypes knowncls
	where	
		cls.id = acc.classId and
		acc.targetId = dm.id and
		dm.classId = knowncls.id
	) as res, 
	TTypes as types, 
	TConstants as c
where	
	res.classId != res.knownClassId and
	res.knownClassId = types.id and
	types.kindOfType = c.value and
	(c.name like '%CLASS' or 
		c.name like '%INTERFACE')
;


/* 
The types, the class imports
*/

(SELECT DISTINCT
	file.pathname AS containing_file_name,
	'TYPE' as kind_of_element,
	importedType.fullname as element_name
FROM 
	TFiles file join
	Timports import on (import.fileid = file.id) join
	TTypes importedType on (import.targetid = importedType.id)

EXCEPT

/* The Types the class really needs */
SELECT DISTINCT
	file.pathname AS containing_file_name,
	'TYPE' as kind_of_element,
	knowsRel.knownclassname as element_name
FROM
	TFiles file join
	TSourceEntities sourceEntities on (file.id = sourceEntities.sourcefileid) join
	TTypes types on (types.id = sourceEntities.id) join
	VKnowsRel knowsRel on (knowsRel.classid = types.id)
)

UNION
(
/* All packages a file imports */
SELECT	DISTINCT
	file.pathname AS containing_file_name,
	'PACKAGE' as kind_of_element,
	importedPackages.fullname as element_name
FROM 
	TFiles file join
	Timports import on (import.fileid = file.id) join
	TPackages importedPackages on (importedPackages.id = import.targetid) 

EXCEPT

/* The packages, that are actually required */
SELECT	DISTINCT
	file.pathname AS containing_file_name,
	'PACKAGE' as kind_of_element,
	importedPackages.fullname as element_name
FROM 
	TFiles file join
	TSourceEntities source on (file.id = source.sourcefileid) join
	TTypes classInFile on (classInFile.id = source.id) join
	Timports import on (import.fileid = file.id) join
	TPackages importedPackages on (importedPackages.id = import.targetid) join
	TTypes importedType on (importedPackages.id = importedType.packageid) join
	VKnowsRel knowsRel on (knowsRel.knownClassId = importedType.id)
WHERE
	knowsRel.classid = classInFile.id
	
)
;

DROP TABLE VKnowsRel;
