/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.Attribute;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.BranchStatement;
import de.fzi.sissy.metamod.CastTypeAccess;
import de.fzi.sissy.metamod.CatchBlock;
import de.fzi.sissy.metamod.CatchParameter;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Clone;
import de.fzi.sissy.metamod.CloneInstance;
import de.fzi.sissy.metamod.Comment;
import de.fzi.sissy.metamod.CompositeAccess;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.DeclarationTypeAccess;
import de.fzi.sissy.metamod.DefaultModelVisitor;
import de.fzi.sissy.metamod.Delegate;
import de.fzi.sissy.metamod.DelegateAccess;
import de.fzi.sissy.metamod.Destructor;
import de.fzi.sissy.metamod.ExceptionHandler;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GenericClass;
import de.fzi.sissy.metamod.GenericConstructor;
import de.fzi.sissy.metamod.GenericEntity;
import de.fzi.sissy.metamod.GenericFunction;
import de.fzi.sissy.metamod.GenericMethod;
import de.fzi.sissy.metamod.GlobalFunction;
import de.fzi.sissy.metamod.GlobalVariable;
import de.fzi.sissy.metamod.Import;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.JumpStatement;
import de.fzi.sissy.metamod.LocalVariable;
import de.fzi.sissy.metamod.LoopStatement;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelVisitor;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.PackageAlias;
import de.fzi.sissy.metamod.ParameterInstanciationTypeAccess;
import de.fzi.sissy.metamod.Property;
import de.fzi.sissy.metamod.PropertyAccess;
import de.fzi.sissy.metamod.Reference;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.RunTimeTypeAccess;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.SimpleStatement;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StaticTypeAccess;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.metamod.Subsystem;
import de.fzi.sissy.metamod.ThrowTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAlias;
import de.fzi.sissy.metamod.TypeParameterClass;
import de.fzi.sissy.metamod.Variable;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.persistence.SQLExportQueryBuilder;
import java.util.Iterator;

public class SQLExportVisitor
extends DefaultModelVisitor
implements ModelVisitor {
    private SQLExportQueryBuilder sqlBuilder;
    private boolean exportCommentTexts;

    public SQLExportVisitor(SQLExportQueryBuilder sqlBuilder, boolean exportCommentTexts) {
        this.sqlBuilder = sqlBuilder;
        this.exportCommentTexts = exportCommentTexts;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int findAccessPosition(Access acc) {
        Iterator it = null;
        int pos = 0;
        if (acc instanceof DeclarationTypeAccess) {
            return 1;
        }
        if (acc.getSurroundingCompositeAccess() != null) {
            pos = SQLExportVisitor.findAccessPosition((Access)acc.getSurroundingCompositeAccess());
            it = acc.getSurroundingCompositeAccess().getAccesses().iterator();
        } else if (acc.getSurroundingStatement() != null) {
            it = acc.getSurroundingStatement().getAccesses().iterator();
        } else if (acc.getSurroundingFunction() != null) {
            if (acc.getSurroundingFunction().getReturnTypeDeclaration() != null) {
                ++pos;
            }
            it = acc.getSurroundingFunction().getAccesses().iterator();
        } else {
            if (acc.getSurroundingClass() == null) {
                return -1;
            }
            it = acc.getSurroundingClass().getInheritanceTypeAccesses().iterator();
        }
        while (it.hasNext()) {
            ++pos;
            Access a = (Access)it.next();
            if (acc == a) {
                return pos;
            }
            if (!(a instanceof CompositeAccess)) continue;
            pos += ((CompositeAccess)a).getAccessCount();
        }
        return -1;
    }

    public static int determineKind(Class c) {
        if (c.isPrimitive()) {
            return 33;
        }
        if (c instanceof TypeParameterClass) {
            return 38;
        }
        if (c instanceof GenericClass) {
            if (c.isInterface()) {
                return 36;
            }
            return 37;
        }
        if (c.getKind().equals((Object)Class.KindOfClass.ENUMTYPE)) {
            return 43;
        }
        if (c.getKind().equals((Object)Class.KindOfClass.STRUCT)) {
            return 44;
        }
        if (c.getKind().equals((Object)Class.KindOfClass.UNION)) {
            return 45;
        }
        if (c.isInterface()) {
            return 34;
        }
        return 35;
    }

    public static int determineKind(Type t) {
        if (t instanceof Class) {
            return SQLExportVisitor.determineKind((Class)t);
        }
        if (t instanceof Array) {
            return 39;
        }
        if (t instanceof TypeAlias) {
            return 40;
        }
        if (t instanceof Delegate) {
            return 49;
        }
        if (t instanceof Reference) {
            if (((Reference)t).isImplicit()) {
                return 41;
            }
            return 42;
        }
        return -1;
    }

    public static int determineKind(Function f) {
        if (f instanceof GenericFunction) {
            return 51;
        }
        if (f instanceof GlobalFunction) {
            if (((GlobalFunction)f).isUnitInitializer()) {
                return 58;
            }
            if (((GlobalFunction)f).isUnitFinalizer()) {
                return 59;
            }
            return 50;
        }
        if (f instanceof GenericConstructor) {
            return 61;
        }
        if (f instanceof Constructor) {
            if (((Constructor)f).isInitializer()) {
                return 55;
            }
            return 53;
        }
        if (f instanceof Destructor) {
            return 54;
        }
        if (f instanceof GenericMethod) {
            return 60;
        }
        if (f instanceof Method) {
            Method m = (Method)f;
            Property prop = m.getSurroundingProperty();
            if (prop != null) {
                if (prop.getGetter() == m) {
                    return 56;
                }
                return 57;
            }
            return 52;
        }
        if (f instanceof Delegate) {
            return 49;
        }
        return -1;
    }

    public static int determineKind(Statement st) {
        if (st instanceof SimpleStatement) {
            return 71;
        }
        if (st instanceof JumpStatement) {
            JumpStatement jst = (JumpStatement)st;
            if (jst.isReturn()) {
                return 73;
            }
            if (jst.isThrow()) {
                return 72;
            }
            return 74;
        }
        if (st instanceof LoopStatement) {
            if (((LoopStatement)st).getKindOfLoop() != null) {
                if (((LoopStatement)st).getKindOfLoop().equals((Object)LoopStatement.LoopStatementKind.FOR)) {
                    return 85;
                }
                if (((LoopStatement)st).getKindOfLoop().equals((Object)LoopStatement.LoopStatementKind.FOREACH)) {
                    return 86;
                }
                if (((LoopStatement)st).getKindOfLoop().equals((Object)LoopStatement.LoopStatementKind.DOWHILE)) {
                    return 87;
                }
                if (((LoopStatement)st).getKindOfLoop().equals((Object)LoopStatement.LoopStatementKind.WHILE)) {
                    return 88;
                }
            }
            return 75;
        }
        if (st instanceof BranchStatement) {
            return 76;
        }
        if (st instanceof ExceptionHandler) {
            return 78;
        }
        if (st instanceof CatchBlock) {
            return 79;
        }
        if (st instanceof BlockStatement) {
            return 77;
        }
        return -1;
    }

    public void visitArray(Array a) {
        this.sqlBuilder.addModelElement((ModelElement)a, 39, 129);
        this.sqlBuilder.addType((Type)a, 39);
    }

    public void visitAttribute(Attribute a) {
        this.visitClass((Class)a);
    }

    public void visitCastTypeAccess(CastTypeAccess cta) {
        if (cta.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)cta, 118, 136, SQLExportVisitor.findAccessPosition((Access)cta));
        } else if (cta.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)cta, 118, 135, SQLExportVisitor.findAccessPosition((Access)cta));
        } else {
            this.sqlBuilder.addAccess((Access)cta, 118, 132, SQLExportVisitor.findAccessPosition((Access)cta));
        }
    }

    public void visitCatchParameter(CatchParameter param) {
        Package pack = null;
        if (param.getSurroundingClass() != null) {
            pack = param.getSurroundingClass().getSurroundingPackage();
        } else if (param.getSurroundingFunction() instanceof GlobalFunction) {
            pack = ((GlobalFunction)param.getSurroundingFunction()).getSurroundingPackage();
        }
        this.sqlBuilder.addVariable((Variable)param, 69, 135, pack, param.getSurroundingClass(), param.getSurroundingFunction(), -1);
    }

    public void visitClass(Class cls) {
        this.sqlBuilder.addClass(cls, SQLExportVisitor.determineKind(cls));
    }

    public void visitClone(Clone cl) {
        this.sqlBuilder.addModelElement((ModelElement)cl, 121, 129);
        this.sqlBuilder.addClone(cl);
    }

    public void visitCloneInstance(CloneInstance ci) {
        this.sqlBuilder.addModelElement((ModelElement)ci, 122, 129);
        this.sqlBuilder.addCloneInstance(ci);
        for (Statement st : ci.getStatements()) {
            this.sqlBuilder.addCloneInstanceStatement(ci, st);
        }
    }

    public void visitComment(Comment c) {
        this.sqlBuilder.addModelElement((ModelElement)c, 4, 137);
        this.sqlBuilder.addSourceEntity((SourceEntity)c);
        this.sqlBuilder.addComment(c, this.exportCommentTexts);
    }

    public void visitCompositeAccess(CompositeAccess ca) {
        if (ca.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)ca, 96, 136, SQLExportVisitor.findAccessPosition((Access)ca));
        } else if (ca.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)ca, 96, 135, SQLExportVisitor.findAccessPosition((Access)ca));
        } else {
            this.sqlBuilder.addAccess((Access)ca, 96, 132, SQLExportVisitor.findAccessPosition((Access)ca));
        }
    }

    public void visitConstructor(Constructor c) {
        int kind = 53;
        if (c.isInitializer()) {
            kind = 55;
        }
        this.sqlBuilder.addFunction((Function)c, kind, 131);
        this.sqlBuilder.addMember((Member)c, kind);
    }

    public void visitDeclarationTypeAccess(DeclarationTypeAccess dta) {
        if (dta.getSurroundingVariable() != null) {
            this.sqlBuilder.addAccess((Access)dta, 117, 134, SQLExportVisitor.findAccessPosition((Access)dta));
        } else if (dta.getSurroundingFunction() != null) {
            this.sqlBuilder.addAccess((Access)dta, 117, 132, SQLExportVisitor.findAccessPosition((Access)dta));
        } else {
            this.sqlBuilder.addAccess((Access)dta, 117, -1, SQLExportVisitor.findAccessPosition((Access)dta));
        }
    }

    public void visitDelegate(Delegate d) {
        if (d.getSurroundingClass() != null) {
            this.sqlBuilder.addFunction((Function)d, 49, 131);
        } else {
            this.sqlBuilder.addFunction((Function)d, 49, 130);
        }
        this.sqlBuilder.addType((Type)d, 49);
        this.sqlBuilder.addSourceEntity((SourceEntity)d);
        this.sqlBuilder.addMember((Member)d, 49);
    }

    public void visitDelegateAccess(DelegateAccess da) {
        if (da.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)da, 98, 136, SQLExportVisitor.findAccessPosition((Access)da));
        } else if (da.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)da, 98, 135, SQLExportVisitor.findAccessPosition((Access)da));
        } else {
            this.sqlBuilder.addAccess((Access)da, 98, 132, SQLExportVisitor.findAccessPosition((Access)da));
        }
    }

    public void visitDestructor(Destructor d) {
        this.sqlBuilder.addFunction((Function)d, 54, 131);
        this.sqlBuilder.addMember((Member)d, 54);
    }

    public void visitField(Field f) {
        if (f.getSurroundingClass() != null) {
            this.sqlBuilder.addVariable((Variable)f, 65, 131, f.getSurroundingClass().getSurroundingPackage(), f.getSurroundingClass(), null, -1);
        } else {
            this.sqlBuilder.addVariable((Variable)f, 65, 131, null, null, null, -1);
        }
        this.sqlBuilder.addMember((Member)f, 65);
    }

    public void visitFile(File f) {
        if (f.isSourceFile()) {
            this.sqlBuilder.addModelElement((ModelElement)f, 2, 129);
        } else {
            this.sqlBuilder.addModelElement((ModelElement)f, 3, 129);
        }
        this.sqlBuilder.addFile(f);
        this.handleIncludedFiles(f);
        this.handlePackageImports(f);
        this.handleTypeImports(f);
        this.handleImportedGlobalFunctions(f);
        this.handleImportedGlobalVariables(f);
    }

    private void handleImportedGlobalVariables(File f) {
        for (Object obj : f.getImportedGlobalVariables()) {
            Import imp = (Import)obj;
            ModelElement elem = imp.getImportedModelElement();
            this.sqlBuilder.addImport(f, elem, 67, imp.isStaticImport(), imp.isMultiImport());
        }
    }

    private void handleImportedGlobalFunctions(File f) {
        for (Object obj : f.getImportedGlobalFunctions()) {
            Import imp = (Import)obj;
            Function elem = (Function)imp.getImportedModelElement();
            this.sqlBuilder.addImport(f, (ModelElement)elem, SQLExportVisitor.determineKind(elem), imp.isStaticImport(), imp.isMultiImport());
        }
    }

    private void handleTypeImports(File f) {
        for (Object obj : f.getTypeImports()) {
            Import imp = (Import)obj;
            Type elem = (Type)imp.getImportedModelElement();
            this.sqlBuilder.addImport(f, (ModelElement)elem, SQLExportVisitor.determineKind(elem), imp.isStaticImport(), imp.isMultiImport());
        }
    }

    private void handlePackageImports(File f) {
        for (Object obj : f.getPackageImports()) {
            Import imp = (Import)obj;
            Package elem = (Package)imp.getImportedModelElement();
            if (elem.getSurroundingPackage() != null) {
                this.sqlBuilder.addImport(f, (ModelElement)elem, 18, imp.isStaticImport(), imp.isMultiImport());
                continue;
            }
            this.sqlBuilder.addImport(f, (ModelElement)elem, 17, imp.isStaticImport(), imp.isMultiImport());
        }
    }

    private void handleIncludedFiles(File f) {
        for (Object obj : f.getIncludedFiles()) {
            ModelElement elem = (ModelElement)obj;
            this.sqlBuilder.addImport(f, elem, 2, false, false);
            this.sqlBuilder.addIncludeClosure(f, (File)elem, new ModelElementList(), 1);
        }
    }

    public void visitFormalParameter(FormalParameter param) {
        Package pack = null;
        if (param.getSurroundingClass() != null) {
            pack = param.getSurroundingClass().getSurroundingPackage();
        } else if (param.getSurroundingFunction() instanceof GlobalFunction) {
            pack = ((GlobalFunction)param.getSurroundingFunction()).getSurroundingPackage();
        }
        int i = 0;
        int pos = -1;
        if (param.getSurroundingFunction() != null) {
            Iterator it = param.getSurroundingFunction().getFormalParameters().iterator();
            while (it.hasNext()) {
                ++i;
                if (it.next() != param) continue;
                pos = i;
            }
        }
        this.sqlBuilder.addVariable((Variable)param, 68, 132, pack, param.getSurroundingClass(), param.getSurroundingFunction(), pos);
    }

    public void visitFunctionAccess(FunctionAccess fa) {
        if (fa.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)fa, 97, 136, SQLExportVisitor.findAccessPosition((Access)fa));
        } else if (fa.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)fa, 97, 135, SQLExportVisitor.findAccessPosition((Access)fa));
        } else {
            this.sqlBuilder.addAccess((Access)fa, 97, 132, SQLExportVisitor.findAccessPosition((Access)fa));
        }
    }

    public void visitGenericClass(GenericClass gc) {
        this.sqlBuilder.addClass((Class)gc, SQLExportVisitor.determineKind((Class)gc));
        this.handleTypeParameters((GenericEntity)gc);
    }

    public void visitGenericFunction(GenericFunction gf) {
        this.sqlBuilder.addFunction((Function)gf, 51, 130);
        this.handleTypeParameters((GenericEntity)gf);
    }

    private void handleTypeParameters(GenericEntity ge) {
        int pos = 0;
        for (Object tpc : ge.getTypeParameters()) {
            this.sqlBuilder.addTypeParameter(ge, (TypeParameterClass)tpc, ++pos);
        }
    }

    public void visitGenericConstructor(GenericConstructor gc) {
        this.sqlBuilder.addFunction((Function)gc, 61, 130);
        this.sqlBuilder.addMember((Member)gc, 60);
        this.handleTypeParameters((GenericEntity)gc);
    }

    public void visitGenericMethod(GenericMethod gm) {
        this.sqlBuilder.addFunction((Function)gm, 60, 130);
        this.sqlBuilder.addMember((Member)gm, 60);
        this.handleTypeParameters((GenericEntity)gm);
    }

    public void visitGlobalFunction(GlobalFunction gf) {
        if (gf.isUnitInitializer()) {
            this.sqlBuilder.addFunction((Function)gf, 58, 130);
        } else if (gf.isUnitFinalizer()) {
            this.sqlBuilder.addFunction((Function)gf, 59, 130);
        } else {
            this.sqlBuilder.addFunction((Function)gf, 50, 130);
        }
    }

    public void visitGlobalVariable(GlobalVariable gv) {
        this.sqlBuilder.addVariable((Variable)gv, 67, 130, gv.getSurroundingPackage(), null, null, -1);
    }

    public void visitInheritanceTypeAccess(InheritanceTypeAccess ita) {
        if (ita.isImplementationInheritance()) {
            this.sqlBuilder.addAccess((Access)ita, 114, 131, SQLExportVisitor.findAccessPosition((Access)ita));
        } else {
            this.sqlBuilder.addAccess((Access)ita, 113, 131, SQLExportVisitor.findAccessPosition((Access)ita));
        }
        this.sqlBuilder.addInheritanceClosure(ita.getSurroundingClass(), ita.getAccessedSuperClass(), 1);
    }

    public void visitLocalVariable(LocalVariable lv) {
        Package pack = null;
        if (lv.getSurroundingClass() != null) {
            pack = lv.getSurroundingClass().getSurroundingPackage();
        } else if (lv.getSurroundingFunction() instanceof GlobalFunction) {
            pack = ((GlobalFunction)lv.getSurroundingFunction()).getSurroundingPackage();
        }
        this.sqlBuilder.addVariable((Variable)lv, 66, 132, pack, lv.getSurroundingClass(), lv.getSurroundingFunction(), -1);
    }

    public void visitMethod(Method m) {
        if (m.isPropertyMethod()) {
            int kind = SQLExportVisitor.determineKind((Function)m);
            this.sqlBuilder.addFunction((Function)m, kind, 133);
            this.sqlBuilder.addMember((Member)m, kind);
        } else {
            this.sqlBuilder.addFunction((Function)m, 52, 131);
            this.sqlBuilder.addMember((Member)m, 52);
        }
    }

    public void visitPackage(Package pack) {
        if (pack.getSurroundingPackage() != null) {
            this.sqlBuilder.addPackage(pack, 18, -1);
        } else {
            this.sqlBuilder.addPackage(pack, 17, -1);
        }
    }

    public void visitPackageAlias(PackageAlias pa) {
        this.sqlBuilder.addPackage((Package)pa, 19, pa.getAliasedPackage().getUniqueId());
    }

    public void visitProperty(Property p) {
        if (p.getSurroundingClass() != null) {
            this.sqlBuilder.addVariable((Variable)p, 70, 131, p.getSurroundingClass().getSurroundingPackage(), p.getSurroundingClass(), null, -1);
        } else {
            this.sqlBuilder.addVariable((Variable)p, 70, 131, null, null, null, -1);
        }
        this.sqlBuilder.addMember((Member)p, 70);
    }

    public void visitPropertyAccess(PropertyAccess pa) {
        int kind = pa.isReadAccess() ? 83 : 84;
        if (pa.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)pa, kind, 136, SQLExportVisitor.findAccessPosition((Access)pa));
        } else if (pa.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)pa, kind, 135, SQLExportVisitor.findAccessPosition((Access)pa));
        } else {
            this.sqlBuilder.addAccess((Access)pa, kind, 132, SQLExportVisitor.findAccessPosition((Access)pa));
        }
    }

    public void visitReference(Reference r) {
        if (r.isImplicit()) {
            this.sqlBuilder.addModelElement((ModelElement)r, 41, 129);
            this.sqlBuilder.addType((Type)r, 41);
        } else {
            this.sqlBuilder.addModelElement((ModelElement)r, 42, 129);
            this.sqlBuilder.addType((Type)r, 42);
        }
    }

    public void visitRoot(Root r) {
        this.sqlBuilder.addModelElement((ModelElement)r, 1, -1);
    }

    public void visitSelfAccess(SelfAccess sa) {
        int kind = 94;
        if (sa.isSuperAccess()) {
            kind = 95;
        }
        if (sa.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)sa, kind, 136, SQLExportVisitor.findAccessPosition((Access)sa));
        } else if (sa.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)sa, kind, 135, SQLExportVisitor.findAccessPosition((Access)sa));
        } else {
            this.sqlBuilder.addAccess((Access)sa, kind, 132, SQLExportVisitor.findAccessPosition((Access)sa));
        }
    }

    public void visitStatement(Statement st) {
        if (st.getContainer() != null) {
            this.sqlBuilder.addModelElement((ModelElement)st, SQLExportVisitor.determineKind(st), 135);
        } else {
            this.sqlBuilder.addModelElement((ModelElement)st, SQLExportVisitor.determineKind(st), 132);
        }
        this.sqlBuilder.addStatement(st);
        this.sqlBuilder.addSourceEntity((SourceEntity)st);
    }

    public void visitStaticTypeAccess(StaticTypeAccess sa) {
        if (sa.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)sa, 120, 136, SQLExportVisitor.findAccessPosition((Access)sa));
        } else if (sa.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)sa, 120, 135, SQLExportVisitor.findAccessPosition((Access)sa));
        } else {
            this.sqlBuilder.addAccess((Access)sa, 120, 132, SQLExportVisitor.findAccessPosition((Access)sa));
        }
    }

    public void visitStructuralAbstraction(StructuralAbstraction sa) {
        this.sqlBuilder.addStructuralAbstraction(sa, 123);
    }

    public void visitSubsystem(Subsystem s) {
        this.sqlBuilder.addStructuralAbstraction((StructuralAbstraction)s, 124);
    }

    public void visitThrowTypeAccess(ThrowTypeAccess tta) {
        if (tta.isDeclared() || tta.getSurroundingStatement() == null) {
            this.sqlBuilder.addAccess((Access)tta, 115, 132, SQLExportVisitor.findAccessPosition((Access)tta));
        } else {
            this.sqlBuilder.addAccess((Access)tta, 116, 135, SQLExportVisitor.findAccessPosition((Access)tta));
        }
    }

    public void visitTypeAlias(TypeAlias ta) {
        if (ta.getSurroundingClass() != null) {
            this.sqlBuilder.addModelElement((ModelElement)ta, 40, 131);
            this.sqlBuilder.addSourceEntity((SourceEntity)ta);
            this.sqlBuilder.addType((Type)ta, 40);
        } else {
            this.sqlBuilder.addModelElement((ModelElement)ta, 40, 130);
            this.sqlBuilder.addSourceEntity((SourceEntity)ta);
            this.sqlBuilder.addType((Type)ta, 40);
        }
    }

    public void visitRunTimeTypeAccess(RunTimeTypeAccess rtta) {
        if (rtta.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)rtta, 119, 136, SQLExportVisitor.findAccessPosition((Access)rtta));
        } else if (rtta.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)rtta, 119, 135, SQLExportVisitor.findAccessPosition((Access)rtta));
        } else {
            this.sqlBuilder.addAccess((Access)rtta, 119, 132, SQLExportVisitor.findAccessPosition((Access)rtta));
        }
    }

    public void visitTypeParameterClass(TypeParameterClass cls) {
        this.sqlBuilder.addClass((Class)cls, 38);
    }

    public void visitVariableAccess(VariableAccess va) {
        int kind = va.isReadAccess() ? 81 : 82;
        if (va.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)va, kind, 136, SQLExportVisitor.findAccessPosition((Access)va));
        } else if (va.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)va, kind, 135, SQLExportVisitor.findAccessPosition((Access)va));
        } else {
            this.sqlBuilder.addAccess((Access)va, kind, 132, SQLExportVisitor.findAccessPosition((Access)va));
        }
    }

    public void visitParameterInstanciationTypeAccess(ParameterInstanciationTypeAccess pa) {
        if (pa.getSurroundingCompositeAccess() != null) {
            this.sqlBuilder.addAccess((Access)pa, 112, 136, SQLExportVisitor.findAccessPosition((Access)pa));
        } else if (pa.getSurroundingStatement() != null) {
            this.sqlBuilder.addAccess((Access)pa, 112, 135, SQLExportVisitor.findAccessPosition((Access)pa));
        } else {
            this.sqlBuilder.addAccess((Access)pa, 112, 132, SQLExportVisitor.findAccessPosition((Access)pa));
        }
    }
}

