/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.persistence.Activator;
import de.fzi.sissy.persistence.JDBCError;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.QueryRunnerConfiguration;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.ParsingErrorHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.postgresql.util.PSQLException;

public class QueryRunner {
    private QueryRunnerConfiguration configuration;
    private JDBCWrapper jdbcWrapper = null;
    private int nextProblemId = 0;
    private int nextPropId = 0;
    private Date now = ParsingErrorHelper.getInstance().getAnalysisTimeStamp();

    public QueryRunner(QueryRunnerConfiguration configuration) {
        this.configuration = configuration;
        this.setupJDBCWrapper();
        List<File> selectedQueryFiles = this.determineSelectedQueryFiles();
        switch (configuration.getQueryRunnerTarget()) {
            case DATABASE: {
                this.handleDatabaseExport(selectedQueryFiles);
                break;
            }
            case CSVFILE: {
                this.handleCSVFileExport(selectedQueryFiles);
                break;
            }
            case TEXTFILE: {
                this.handleTextFileExport(selectedQueryFiles);
            }
        }
    }

    private void setupJDBCWrapper() {
        this.jdbcWrapper = JDBCWrapper.createJDBCWrapper(this.configuration.getDatabaseConfiguration());
        this.jdbcWrapper.getConnection();
    }

    private List<File> determineSelectedQueryFiles() {
        List<String> selectedFileNames = this.configuration.getQueryFilenames();
        List<File> queryFiles = Activator.getDefault().getProblemPatternQueryFiles();
        ArrayList<File> selectedQueryFiles = new ArrayList<File>();
        for (File file : queryFiles) {
            String filename = file.getName();
            if (!selectedFileNames.contains(filename)) continue;
            selectedQueryFiles.add(file);
        }
        return selectedQueryFiles;
    }

    private void handleDatabaseExport(List<File> selectedQueryFiles) {
        ArrayList<String> resultStatements = new ArrayList<String>();
        this.determineNextIds();
        for (File queryFile : selectedQueryFiles) {
            Debug.info((String)("SQL: " + queryFile.getName()));
            this.executeQueryForDatabaseExport(queryFile.getAbsolutePath(), resultStatements);
        }
        this.writeResultsIntoDatabase(resultStatements);
    }

    private void handleCSVFileExport(List<File> selectedQueryFiles) {
        for (File queryFile : selectedQueryFiles) {
            Debug.info((String)("SQL: " + queryFile.getName()));
            this.executeQuery2CSV(queryFile.getAbsolutePath(), this.configuration.getTargetFileNamePath());
        }
    }

    private void handleTextFileExport(List<File> selectedQueryFiles) {
        for (File queryFile : selectedQueryFiles) {
            Debug.info((String)("SQL: " + queryFile.getName()));
            this.executeQueryForTextfile(queryFile.getAbsolutePath(), this.configuration.getTargetFileNamePath());
        }
    }

    private void determineNextIds() {
        Debug.info((String)"Exporting problems to database.");
        try {
            String queryMaximumTProblemId = "select max(id) from tproblems;";
            ResultSet rs = this.jdbcWrapper.executeQuery(queryMaximumTProblemId);
            rs.next();
            this.nextProblemId = rs.getInt(1) + 1;
            String queryMaximumTProblempropertiesId = "select max(id) from tproblemproperties;";
            rs = this.jdbcWrapper.executeQuery(queryMaximumTProblempropertiesId);
            rs.next();
            this.nextPropId = rs.getInt(1) + 1;
        }
        catch (SQLException sQLException) {}
    }

    private void writeResultsIntoDatabase(List<String> resultStatements) {
        Debug.info((String)"Writing results into database...");
        int i = 0;
        while (i < resultStatements.size()) {
            String line = resultStatements.get(i);
            try {
                this.jdbcWrapper.executeQuery(line);
            }
            catch (Exception exception) {
                Debug.info((String)line);
            }
            ++i;
        }
        resultStatements.clear();
    }

    private void executeQueryForDatabaseExport(String sqlFilename, List<String> resultStatements) {
        try {
            List<String> sqlQuery = this.readFile(sqlFilename);
            if (sqlQuery == null || sqlQuery.size() <= 0) {
                return;
            }
            ResultSet rs = null;
            int j = 0;
            while (j < sqlQuery.size()) {
                block14: {
                    try {
                        rs = this.jdbcWrapper.executeQuery(sqlQuery.get(j));
                        if (rs == null) break block14;
                        ResultSetMetaData rsmd = rs.getMetaData();
                        while (rs.next()) {
                            File f = new File(sqlFilename);
                            String kindOfProblem = f.getName();
                            kindOfProblem = kindOfProblem.substring(0, kindOfProblem.indexOf(46));
                            String fileName = "";
                            int lineNumber = 0;
                            try {
                                fileName = rs.getString("file_name");
                                lineNumber = rs.getInt("line_number");
                            }
                            catch (Exception exception) {}
                            if (fileName == null || fileName != null && fileName.equals("")) {
                                fileName = "NULL";
                            }
                            fileName = fileName.replace("\\", "\\\\");
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                            String timestamp = sdf.format(this.now);
                            String lineNumberStr = "NULL";
                            if (lineNumber != 0) {
                                lineNumberStr = Integer.toString(lineNumber);
                            }
                            String resultStmProblems = "insert into TProblems values (" + this.nextProblemId + ",'" + timestamp + "','" + kindOfProblem + "', '" + fileName + "', " + lineNumberStr + ");";
                            resultStatements.add(resultStmProblems);
                            int i = 1;
                            while (i <= rsmd.getColumnCount()) {
                                String propName = rsmd.getColumnName(i);
                                String propValue = rs.getString(i);
                                if (propValue != null) {
                                    propValue = propValue.replace("\\", "\\\\");
                                }
                                String resultStmProperties = "insert into TProblemProperties values (" + this.nextPropId + ", " + this.nextProblemId + ", '" + propName + "','" + propValue + "');";
                                resultStatements.add(resultStmProperties);
                                ++this.nextPropId;
                                ++i;
                            }
                            ++this.nextProblemId;
                        }
                        rs.close();
                    }
                    catch (JDBCError e) {
                        Debug.error((String)("JDBCError executing query " + sqlFilename));
                        e.printStackTrace();
                    }
                    catch (SQLException e) {
                        Debug.error((String)("SQLError executing query " + sqlFilename));
                        e.printStackTrace();
                    }
                }
                ++j;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void executeQueryForTextfile(String sqlFilename, String outFilename) {
        try {
            PrintStream out = new PrintStream(outFilename);
            List<String> sqlQuery = this.readFile(sqlFilename);
            if (sqlQuery == null || sqlQuery.size() <= 0) {
                return;
            }
            ResultSet rs = null;
            int j = 0;
            while (j < sqlQuery.size()) {
                try {
                    String str;
                    rs = this.jdbcWrapper.executeQuery(sqlQuery.get(j));
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    int[] columnSize = new int[columnCount + 1];
                    int i = 1;
                    while (i <= columnCount) {
                        str = rsmd.getColumnLabel(i);
                        columnSize[i] = Math.max(rsmd.getColumnDisplaySize(i), str.length());
                        if (columnSize[i] > 40) {
                            columnSize[i] = 40;
                        }
                        out.print(String.valueOf(QueryRunner.leftJustify(str, columnSize[i], ' ')) + " | ");
                        ++i;
                    }
                    out.println();
                    i = 1;
                    while (i <= columnCount) {
                        out.print(String.valueOf(QueryRunner.leftJustify("", columnSize[i], '=')) + "=+=");
                        ++i;
                    }
                    out.println();
                    while (rs.next()) {
                        i = 1;
                        while (i <= columnCount) {
                            str = rs.getString(i);
                            out.print(String.valueOf(QueryRunner.leftJustify(str, columnSize[i], ' ')) + " | ");
                            ++i;
                        }
                        out.println();
                    }
                }
                catch (JDBCError e) {
                    Debug.error((String)("JDBCError executing query " + sqlFilename));
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    Debug.error((String)("SQLError executing query " + sqlFilename));
                    e.printStackTrace();
                }
                catch (Exception exception) {}
                ++j;
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String leftJustify(String s, int length, char pad) {
        if (s == null) {
            s = "(NULL)";
        }
        StringBuffer buffer = new StringBuffer(s);
        while (buffer.length() < length) {
            buffer.append(pad);
        }
        return buffer.toString();
    }

    private void executeQuery2CSV(String sqlFilename, String outFilename) {
        try {
            PrintStream out = new PrintStream(outFilename);
            List<String> sqlQuery = this.readFile(sqlFilename);
            if (sqlQuery == null || sqlQuery.size() <= 0) {
                return;
            }
            long startMillis = System.currentTimeMillis();
            long rowCount = 0L;
            ResultSet rs = null;
            int j = 0;
            while (j < sqlQuery.size()) {
                try {
                    String str;
                    rs = this.jdbcWrapper.executeQuery(sqlQuery.get(j));
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    int i = 1;
                    while (i <= columnCount) {
                        str = rsmd.getColumnLabel(i);
                        out.print(String.valueOf(str) + ";");
                        ++i;
                    }
                    out.println();
                    while (rs.next()) {
                        i = 1;
                        while (i <= columnCount) {
                            str = rs.getString(i);
                            out.print(String.valueOf(str) + ";");
                            ++i;
                        }
                        out.println();
                        ++rowCount;
                    }
                }
                catch (JDBCError e) {
                    Debug.error((String)("JDBCError executing query " + sqlFilename));
                    e.printStackTrace();
                    Debug.error((String)("Query fragement: " + sqlQuery.get(j)));
                }
                catch (SQLException e) {
                    Debug.error((String)("SQLError executing query " + sqlFilename));
                    e.printStackTrace();
                    Debug.error((String)("Query fragement: " + sqlQuery.get(j)));
                }
                catch (Exception exception) {}
                ++j;
            }
            out.flush();
            out.close();
            long seconds = (System.currentTimeMillis() - startMillis) / 1000L;
            Debug.info((String)("Query returned " + rowCount + " row(s) in " + seconds + " s."));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<String> readFile(String filename) throws IOException {
        int start;
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        while ((line = inputFile.readLine()) != null) {
            start = line.indexOf("--");
            if (start >= 0) {
                line = line.substring(0, start);
            }
            buffer.append(line);
            buffer.append(" ");
        }
        while ((start = buffer.indexOf("/*")) != -1) {
            int end = buffer.indexOf("*/", start) + 2;
            buffer.delete(start, end);
        }
        StringTokenizer tok = new StringTokenizer(buffer.toString(), ";");
        int count = tok.countTokens();
        if (count == 0) {
            return null;
        }
        ArrayList<String> stmts = new ArrayList<String>();
        int i = 0;
        while (i < count) {
            String stmt = tok.nextToken();
            if (!(stmt = stmt.trim()).equals("")) {
                stmts.add(stmt);
            }
            ++i;
        }
        return stmts;
    }

    private int executeQueryCounting(String sqlFilename) {
        int count;
        block15: {
            List<String> sqlQuery;
            block13: {
                count = 0;
                sqlQuery = this.readFile(sqlFilename);
                if (sqlQuery != null && sqlQuery.size() > 0) break block13;
                return -1;
            }
            try {
                int k = 0;
                while (k < sqlQuery.size()) {
                    String stmt = sqlQuery.get(k);
                    if (!stmt.toUpperCase().contains("CREATE") && !stmt.toUpperCase().contains("DROP") && stmt.toUpperCase().contains("SELECT")) {
                        ResultSet rs = this.jdbcWrapper.executeQuery(stmt);
                        if (rs != null) {
                            try {
                                while (rs.next()) {
                                    ++count;
                                }
                            }
                            catch (SQLException e) {
                                Debug.info((String)("SQLError executing query " + sqlFilename));
                                e.printStackTrace();
                            }
                        }
                    } else {
                        try {
                            this.jdbcWrapper.executeQuery(stmt);
                        }
                        catch (JDBCError jDBCError) {}
                    }
                    ++k;
                }
            }
            catch (IOException e) {
                Debug.error((String)("Query execution failed: " + e.getLocalizedMessage()));
            }
            catch (JDBCError e) {
                if (e.getCause() instanceof PSQLException) break block15;
                Debug.error((String)("JDBC Error occured: " + e.getLocalizedMessage()));
            }
        }
        return count;
    }

    private int executeQueryReading(String sqlFilename, int row, int col) {
        block13: {
            List<String> sqlQuery;
            block12: {
                sqlQuery = this.readFile(sqlFilename);
                if (sqlQuery != null && sqlQuery.size() > 0) break block12;
                return -1;
            }
            try {
                int k = 0;
                while (k < sqlQuery.size()) {
                    String stmt = sqlQuery.get(k);
                    if (!stmt.toUpperCase().contains("CREATE") && !stmt.toUpperCase().contains("DROP") && stmt.toUpperCase().contains("SELECT")) {
                        ResultSet rs = this.jdbcWrapper.executeQuery(stmt);
                        try {
                            int i = 1;
                            while (i <= row) {
                                rs.next();
                                ++i;
                            }
                            return rs.getInt(col);
                        }
                        catch (SQLException e) {
                            Debug.info((String)("SQLError executing query " + sqlFilename));
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            this.jdbcWrapper.executeQuery(stmt);
                        }
                        catch (JDBCError jDBCError) {}
                    }
                    ++k;
                }
            }
            catch (IOException e) {
                Debug.error((String)("Query execution failed: " + e.getLocalizedMessage()));
            }
            catch (JDBCError e) {
                if (e.getCause() instanceof PSQLException) break block13;
                Debug.error((String)("JDBC Error occured: " + e.getLocalizedMessage()));
            }
        }
        return -13;
    }
}

