/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.ModelVisitor;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.persistence.ExportConfiguration;
import de.fzi.sissy.persistence.JDBCError;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.SQLExportQueryBuilder;
import de.fzi.sissy.persistence.SQLExportVisitor;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.ParsingErrorHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class ModelExporter {
    private final ExportConfiguration configuration;
    private final JDBCWrapper jdbcWrapper;
    private final Root root;
    static final NumberFormat percentFormat = new DecimalFormat("000");

    public ModelExporter(Root root, ExportConfiguration configuration, IProgressMonitor monitor) {
        this.configuration = configuration;
        this.root = root;
        this.jdbcWrapper = JDBCWrapper.createJDBCWrapper(configuration.getDatabaseConfiguration());
        Debug.println((String)("Model exporter created, Database: " + this.jdbcWrapper.getDBName()));
        Debug.info((String)"Exporting to SQL");
        this.jdbcWrapper.getConnection();
        this.exportToSQL(monitor);
        Debug.info((String)"Exporting finished");
    }

    @Deprecated
    public ModelExporter(Root root, JDBCWrapper jdbcWrapper) {
        this.root = root;
        this.jdbcWrapper = jdbcWrapper;
        this.configuration = null;
        this.exportToSQL(null);
    }

    private void exportToSQL(IProgressMonitor monitor) {
        try {
            this.jdbcWrapper.runScripts();
            this.export(monitor);
        }
        catch (JDBCError e) {
            Debug.error((String)"Failed to export SISSy model to database", (Throwable)e);
            throw new JDBCError(e);
        }
    }

    private void exportParsingErrors(SQLExportQueryBuilder sqlBuilder) {
        Iterator it = ParsingErrorHelper.getInstance().iterator();
        while (it.hasNext()) {
            sqlBuilder.addParsingError((ParsingErrorHelper.TErrorElement)it.next());
        }
    }

    public void export(IProgressMonitor monitor) {
        Connection jdbcConnection = this.jdbcWrapper.getConnection();
        this.setupConnection(jdbcConnection);
        SQLExportQueryBuilder sqlBuilder = new SQLExportQueryBuilder(jdbcConnection, this.configuration.getDatabaseConfiguration());
        SQLExportVisitor exportVisitor = new SQLExportVisitor(sqlBuilder, this.configuration.isExportCommentTextsToDatabase());
        this.exportParsingErrors(sqlBuilder);
        ModelElementRepository rep = this.root.getRepository();
        this.exportModelElements(monitor, sqlBuilder, exportVisitor, rep);
        if (monitor != null) {
            monitor.subTask("Execute Batches");
            sqlBuilder.executeBatches();
        }
        try {
            jdbcConnection.commit();
            jdbcConnection.close();
        }
        catch (SQLException e) {
            Debug.error((String)"Failed to commit DB transaction");
            throw new JDBCError(e);
        }
        Debug.info((String)"\r100% (done)");
    }

    private void exportModelElements(IProgressMonitor monitor, SQLExportQueryBuilder sqlBuilder, SQLExportVisitor exportVisitor, ModelElementRepository rep) {
        Debug.info((String)"Sorting model elements...");
        Iterator it = rep.getModelElements().iterator();
        Debug.info((String)"Done");
        int total = rep.getSize();
        if (monitor != null) {
            monitor.beginTask("export model to database", total);
        }
        int MAX_BATCH = 1000;
        int batchcount = 0;
        int count = 0;
        int lastPercentDone = 0;
        while (it.hasNext() && monitor != null && !monitor.isCanceled()) {
            int percentDone;
            ModelElement elem = (ModelElement)it.next();
            if ((percentDone = (int)Math.round((double)(++count) * 100.0 / (double)total)) != lastPercentDone) {
                Debug.info((String)String.format("%3d%% Exporting id: %4d / %4d", percentDone, count, total));
                lastPercentDone = percentDone;
            }
            elem.acceptVisitor((ModelVisitor)exportVisitor);
            if (batchcount < MAX_BATCH) {
                ++batchcount;
            } else {
                sqlBuilder.executeBatches();
                batchcount = 0;
                Debug.debug((String)"Committing batch of SQL Statements");
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
    }

    private void setupConnection(Connection jdbcConnection) {
        try {
            jdbcConnection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            Debug.error((String)"Failed to set auto commit mode");
            throw new JDBCError(ex);
        }
    }
}

