/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.metrics;

import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metrics.Metric;
import java.util.Collection;

public class TCC
extends Metric {
    private ModelElementList classFieldCache;
    private Class cachedClass;

    public TCC() {
        super("TCC");
    }

    @Override
    public double compute(ModelElement me) throws IllegalArgumentException {
        if (me instanceof Class) {
            Class c = (Class)me;
            ModelElementList methods = c.getMethods().filter("de.fzi.sissy.metamod.Method");
            int connectedMethods = 0;
            Object[] methodArray = methods.toArray();
            int i = 0;
            while (i < methodArray.length) {
                int k = i + 1;
                while (k < methodArray.length) {
                    Method m1 = (Method)methodArray[i];
                    Method m2 = (Method)methodArray[k];
                    if (this.connected(m1, m2)) {
                        ++connectedMethods;
                    }
                    ++k;
                }
                ++i;
            }
            if (connectedMethods == 0 || methods.size() < 2) {
                return 0.0;
            }
            return (double)connectedMethods / (double)(methods.size() * (methods.size() - 1) / 2);
        }
        throw new IllegalArgumentException("Cannot compute TCC for " + me.toString());
    }

    private boolean connected(Method m1, Method m2) {
        if (this.cachedClass != m1.getSurroundingClass()) {
            this.cachedClass = m1.getSurroundingClass();
            this.classFieldCache = m1.getSurroundingClass().getFields();
        }
        if (this.cachedClass.getFields().size() == 0) {
            return false;
        }
        ModelElementList m1Vars = m1.getAccessedVariables(true);
        ModelElementList m2Vars = m2.getAccessedVariables(true);
        m1Vars.retainAll((Collection)m2Vars);
        m1Vars.retainAll((Collection)this.classFieldCache);
        return !m1Vars.isEmpty();
    }
}

