/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors;

import de.fzi.sissy.extractors.CloneAnalysisConfiguration;
import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;
import de.uka.ipd.sdq.workflow.IJobConfiguration;
import java.util.ArrayList;
import java.util.List;

public class ExtractorConfiguration
extends AbstractJobConfiguration
implements IJobConfiguration {
    private CloneAnalysisConfiguration cloneAnalysisConfiguration;
    private boolean runExtraction;
    private List<String> inputDirectoryPaths = new ArrayList<String>();
    private ProgrammingLanguage programmingLanguage;
    private boolean extractComments;
    private List<String> sourceLibraryFilePaths = new ArrayList<String>();
    private List<String> binaryLibraryFilePaths = new ArrayList<String>();
    private List<String> excludeFilePaths = new ArrayList<String>();
    private JavaCodeSourceLevel javaSourceLevel;
    private CDTVersion cdtVersion;
    private boolean omitExternC;
    private boolean extractOnlyCPPFiles;
    private String includeDirectoriesConfigFile;
    private String preprocessorDefinitionsConfigFile;
    private boolean createFakeDependencies;
    private boolean createFakesForProblemBindings;
    private boolean doExtractExpressions;
    private boolean doExtractSubsystems;
    private String subsystemSpecificationFilePath;

    public ExtractorConfiguration() {
        this.cloneAnalysisConfiguration = new CloneAnalysisConfiguration();
        this.setDefaults();
    }

    public boolean isValid() {
        boolean isValid = false;
        if (this.getErrorMessage() == null) {
            isValid = true;
        }
        return isValid;
    }

    public String getErrorMessage() {
        String errorMessage = null;
        boolean languageFound = false;
        ProgrammingLanguage[] programmingLanguageArray = ProgrammingLanguage.values();
        int n = programmingLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgrammingLanguage pl = programmingLanguageArray[n2];
            if (pl == this.programmingLanguage) {
                languageFound = true;
            }
            ++n2;
        }
        if (!languageFound) {
            errorMessage = "Programming language is missing.";
        }
        if (this.inputDirectoryPaths.isEmpty()) {
            errorMessage = errorMessage == null ? "" : String.valueOf(errorMessage) + " ";
            errorMessage = String.valueOf(errorMessage) + "Source folders are missing";
        }
        return errorMessage;
    }

    public void setDefaults() {
        this.runExtraction = true;
        this.inputDirectoryPaths.clear();
        this.programmingLanguage = ProgrammingLanguage.JAVA;
        this.extractComments = true;
        this.javaSourceLevel = JavaCodeSourceLevel.JAVA_5_0;
        this.sourceLibraryFilePaths.clear();
        this.binaryLibraryFilePaths.clear();
        this.excludeFilePaths.clear();
        this.includeDirectoriesConfigFile = "";
        this.preprocessorDefinitionsConfigFile = "";
        this.doExtractSubsystems = false;
        this.subsystemSpecificationFilePath = null;
        this.doExtractExpressions = false;
        this.extractOnlyCPPFiles = false;
        this.cdtVersion = CDTVersion.CDT_3;
        this.omitExternC = false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Extractor Configuration: \n");
        result.append("Run Extraction:       " + this.runExtraction + "\n");
        result.append("Inputpaths:           " + this.nullSafeToString(this.inputDirectoryPaths) + "\n");
        result.append("Programming Language: " + this.programmingLanguage.toString() + "\n");
        result.append("Extract Comments:     " + this.extractComments + "\n");
        result.append("Java Source Level:    " + this.javaSourceLevel.toString() + "\n");
        result.append("Source Library Paths: " + this.nullSafeToString(this.sourceLibraryFilePaths) + "\n");
        result.append("Binary Library Paths: " + this.nullSafeToString(this.binaryLibraryFilePaths) + "\n");
        result.append("Excludes:             " + this.nullSafeToString(this.excludeFilePaths) + "\n");
        result.append("CDT Version:          " + this.cdtVersion.toString() + "\n");
        result.append("Omit Extern C:        " + this.omitExternC + "\n");
        result.append("C++ Includefile:      " + this.nullSafeToString(this.includeDirectoriesConfigFile) + "\n");
        result.append("C++ Preprocessordefs: " + this.nullSafeToString(this.preprocessorDefinitionsConfigFile) + "\n");
        result.append("Extract Expressions:  " + this.doExtractExpressions + "\n");
        result.append("Extract Subsystems:   " + this.doExtractSubsystems + "\n");
        return result.toString();
    }

    private String nullSafeToString(List<String> strings) {
        if (strings == null || strings.size() == 0) {
            return "<not set>";
        }
        StringBuilder builder = new StringBuilder();
        for (String s : strings) {
            builder.append(s);
        }
        return builder.toString();
    }

    private String nullSafeToString(String message) {
        if (message == null) {
            return "<not set>";
        }
        return message;
    }

    public boolean isRunExtraction() {
        return this.runExtraction;
    }

    public void setRunExtraction(boolean runExtraction) {
        this.runExtraction = runExtraction;
    }

    public List<String> getInputDirectoryPaths() {
        return this.inputDirectoryPaths;
    }

    public void setInputDirectoryPaths(List<String> inputDirectoryPaths) {
        this.inputDirectoryPaths = inputDirectoryPaths;
    }

    public ProgrammingLanguage getProgrammingLanguage() {
        return this.programmingLanguage;
    }

    public void setProgrammingLanguage(ProgrammingLanguage programmingLanguage) {
        this.programmingLanguage = programmingLanguage;
    }

    public boolean isExtractComments() {
        return this.extractComments;
    }

    public void setExtractComments(boolean extractComments) {
        this.extractComments = extractComments;
    }

    public List<String> getSourceLibraryFilePaths() {
        return this.sourceLibraryFilePaths;
    }

    public void setSourceLibraryFilePaths(List<String> sourceLibraryFilePaths) {
        this.sourceLibraryFilePaths = sourceLibraryFilePaths;
    }

    public List<String> getBinaryLibraryFilePaths() {
        return this.binaryLibraryFilePaths;
    }

    public void setBinaryLibraryFilePaths(List<String> binaryLibraryFilePaths) {
        this.binaryLibraryFilePaths = binaryLibraryFilePaths;
    }

    public List<String> getExcludeFilePaths() {
        return this.excludeFilePaths;
    }

    public void setExcludeFilePaths(List<String> excludeFilePaths) {
        this.excludeFilePaths = excludeFilePaths;
    }

    public JavaCodeSourceLevel getJavaSourceLevel() {
        return this.javaSourceLevel;
    }

    public void setJavaSourceLevel(JavaCodeSourceLevel javaSourceLevel) {
        this.javaSourceLevel = javaSourceLevel;
    }

    public CDTVersion getCdtVersion() {
        return this.cdtVersion;
    }

    public void setCdtVersion(CDTVersion cdtVersion) {
        this.cdtVersion = cdtVersion;
    }

    public boolean omitExternC() {
        return this.omitExternC;
    }

    public void setOmitExternC(boolean omitExternC) {
        this.omitExternC = omitExternC;
    }

    public String getIncludeDirectoriesConfigFile() {
        return this.includeDirectoriesConfigFile;
    }

    public void setIncludeDirectoriesConfigFile(String includeDirectoriesConfigFile) {
        this.includeDirectoriesConfigFile = includeDirectoriesConfigFile;
    }

    public String getPreprocessorDefinitionsConfigFile() {
        return this.preprocessorDefinitionsConfigFile;
    }

    public void setPreprocessorDefinitionsConfigFile(String preprocessorDefinitionsConfigFile) {
        this.preprocessorDefinitionsConfigFile = preprocessorDefinitionsConfigFile;
    }

    public boolean isDoExtractSubsystems() {
        return this.doExtractSubsystems;
    }

    public void setDoExtractSubsystems(boolean doExtractSubsystems) {
        this.doExtractSubsystems = doExtractSubsystems;
    }

    public String getSubsystemSpecificationFilePath() {
        return this.subsystemSpecificationFilePath;
    }

    public void setSubsystemSpecificationFilePath(String subsystemSpecificationFilePath) {
        this.subsystemSpecificationFilePath = subsystemSpecificationFilePath;
    }

    public CloneAnalysisConfiguration getCloneAnalysisConfiguration() {
        return this.cloneAnalysisConfiguration;
    }

    public boolean isDoExtractExpressions() {
        return this.doExtractExpressions;
    }

    public void setDoExtractExpressions(boolean doExtractExpressions) {
        this.doExtractExpressions = doExtractExpressions;
    }

    public boolean isExtractOnlyCPPFiles() {
        return this.extractOnlyCPPFiles;
    }

    public void setExtractOnlyCPPFiles(boolean extractOnlyCPPFiles) {
        this.extractOnlyCPPFiles = extractOnlyCPPFiles;
    }

    public boolean isCreateFakesForProblemBindings() {
        return this.createFakesForProblemBindings;
    }

    public void setCreateFakesForProblemBindings(boolean createFakesForProblemBindings) {
        this.createFakesForProblemBindings = createFakesForProblemBindings;
    }

    public boolean isCreateFakeDependencies() {
        return this.createFakeDependencies;
    }

    public void setCreateFakeDependencies(boolean createFakeDependencies) {
        this.createFakeDependencies = createFakeDependencies;
    }

    public static enum CDTVersion {
        CDT_3,
        CDT_6;

    }

    public static enum JavaCodeSourceLevel {
        JAVA_5_0,
        JAVA_1_3,
        JAVA_1_4;

    }

    public static enum ProgrammingLanguage {
        JAVA,
        CPP,
        DELPHI;

    }
}

