/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer;

import de.fzi.sissy.dpanalyzer.DesignPatternInstance;
import de.fzi.sissy.dpanalyzer.MetamodRetrievalEngineImplementation;
import de.fzi.sissy.dpanalyzer.roles.Role;
import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Variable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLExporter {
    public static final String DP_LIST_ELEMENT = "designpatternlist";
    public static final String DP_INSTANCE_ELEMENT = "dp-instance";
    public static final String DP_NAME_ATTRIBUTE = "dp-name";
    public static final String ROLE_ELEMENT = "role";
    public static final String ROLE_NAME_ATTRIBUTE = "role-name";
    public static final String ROLE_TYPE_ATTRIBUTE = "role-type";
    public static final String ROLE_MODELELEMENT_ATTRIBUTE = "role-modelelement";
    public static final String ROLE_TYPE_ACCESS = "access";
    public static final String ROLE_TYPE_METHOD = "method";
    public static final String ROLE_TYPE_CONSTRUCTOR = "constructor";
    public static final String ROLE_TYPE_CLASS = "class";
    public static final String ROLE_TYPE_VARIABLE = "variable";
    public static final String ROLE_TYPE_DEFAULT = "default";
    private Vector fullqualifiedlist = new Vector();
    private static XMLExporter singleton;
    private static String linesp;

    static {
        linesp = System.getProperty("line.separator");
    }

    private XMLExporter() {
    }

    public static XMLExporter getSingleton() {
        if (singleton == null) {
            singleton = new XMLExporter();
        }
        return singleton;
    }

    public void exportToXMLFile(Map resultPatternMap) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.createXMLRootElement(document, DP_LIST_ELEMENT);
        for (String dp_name : resultPatternMap.keySet()) {
            Collection dpi_collection = (Collection)resultPatternMap.get(dp_name);
            for (DesignPatternInstance dp_instance : dpi_collection) {
                this.createDPInstanceElement(document, dp_instance);
            }
        }
        if (document != null) {
            this.saveXMLDocument("dpilist.xml", document);
            this.saveListDocument("dpilist.csv");
        }
    }

    private void saveXMLDocument(String file_name, Document document) {
        String linesp = System.getProperty("line.separator");
        FileWriter writer = null;
        try {
            writer = new FileWriter(file_name);
            BufferedWriter bwriter = new BufferedWriter(writer);
            String heading = "<?xml version='1.0' encoding='iso-8859-1' ?>";
            String content = String.valueOf(heading) + linesp;
            content = String.valueOf(content) + this.stringForXMLElement(document.getDocumentElement());
            System.out.println(content);
            bwriter.write(content);
            bwriter.flush();
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveListDocument(String file_name) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file_name);
            BufferedWriter bwriter = new BufferedWriter(writer);
            for (String line : this.fullqualifiedlist) {
                bwriter.write("\"" + line + "\"\n");
            }
            bwriter.flush();
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createXMLRootElement(Document document, String elementName) {
        Element root = document.createElement(elementName);
        document.appendChild(root);
    }

    private void createDPInstanceElement(Document document, DesignPatternInstance dp_instance) {
        Element root = document.getDocumentElement();
        Element dpi_element = document.createElement(DP_INSTANCE_ELEMENT);
        dpi_element.setAttribute(DP_NAME_ATTRIBUTE, dp_instance.getDesignPatternName());
        Map role_map = dp_instance.getRoleToMetamodMapping();
        Iterator role_itr = role_map.keySet().iterator();
        boolean exists_valid_role = false;
        while (role_itr.hasNext()) {
            String role_name = (String)role_itr.next();
            boolean contained = false;
            for (Role role : dp_instance.getDesignPatternDescription().getVisibleRoles()) {
                if (!role.getRoleName().equals(role_name)) continue;
                contained = true;
                break;
            }
            if (!contained) continue;
            Collection mm_collection = (Collection)role_map.get(role_name);
            for (Object obj : mm_collection) {
                SourceEntity se;
                Position pos;
                ModelElement model_obj = (ModelElement)obj;
                if (model_obj instanceof SourceEntity && (pos = (se = (SourceEntity)model_obj).getPosition()).getSourceFile() == null) continue;
                exists_valid_role = true;
                this.createRoleElement(document, dpi_element, role_name, model_obj);
            }
        }
        if (exists_valid_role) {
            root.appendChild(dpi_element);
        }
    }

    private void createRoleElement(Document document, Element dpi_element, String role_name, ModelElement model_obj) {
        Element role_element = document.createElement(ROLE_ELEMENT);
        dpi_element.appendChild(role_element);
        role_element.setAttribute(ROLE_NAME_ATTRIBUTE, role_name);
        String type = "";
        type = model_obj instanceof Method ? ROLE_TYPE_METHOD : (model_obj instanceof Constructor ? ROLE_TYPE_CONSTRUCTOR : (model_obj instanceof Class ? ROLE_TYPE_CLASS : (model_obj instanceof Variable ? ROLE_TYPE_VARIABLE : (model_obj instanceof Access ? ROLE_TYPE_ACCESS : ROLE_TYPE_DEFAULT))));
        role_element.setAttribute(ROLE_TYPE_ATTRIBUTE, type);
        String full_qualified_name = MetamodRetrievalEngineImplementation.getSingleton().getFullQualifiedNameOfMetamodObject(model_obj);
        role_element.setAttribute(ROLE_MODELELEMENT_ATTRIBUTE, full_qualified_name);
        this.fullqualifiedlist.add(full_qualified_name);
    }

    private String stringForXMLElement(Element element) {
        String text = "";
        text = "<" + element.getTagName();
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attrb = (Attr)attributes.item(i);
            text = String.valueOf(text) + " " + attrb.getName() + "=\"" + attrb.getValue() + "\"";
            ++i;
        }
        NodeList childnodes = element.getChildNodes();
        if (childnodes.getLength() > 0) {
            text = String.valueOf(text) + ">" + linesp;
            int j = 0;
            while (j < childnodes.getLength()) {
                Node node = childnodes.item(j);
                if (node instanceof Element) {
                    text = String.valueOf(text) + this.stringForXMLElement((Element)node) + linesp;
                } else if (node instanceof Text) {
                    text = String.valueOf(text) + ((Text)node).getWholeText() + linesp;
                }
                ++j;
            }
            text = String.valueOf(text) + "</" + element.getTagName() + ">" + linesp;
        } else {
            text = String.valueOf(text) + "/>";
        }
        return text;
    }
}

