/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer;

import de.fzi.sissy.dpanalyzer.MetamodRetrievalEngine;
import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StatementTreeWalker;
import de.fzi.sissy.metamod.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class MetamodRetrievalEngineImplementation
implements MetamodRetrievalEngine {
    private static MetamodRetrievalEngineImplementation singleton;
    private ModelElementRepository metamod_repository;

    private MetamodRetrievalEngineImplementation() {
    }

    public static MetamodRetrievalEngineImplementation getSingleton() {
        if (singleton == null) {
            singleton = new MetamodRetrievalEngineImplementation();
        }
        return singleton;
    }

    @Override
    public List getClasses() {
        LinkedList result = new LinkedList();
        result.addAll(this.metamod_repository.getRoot().getClasses());
        return result;
    }

    public ModelElementRepository getMetamodRepository() {
        return this.metamod_repository;
    }

    public void setMetamodRepository(ModelElementRepository metamod_repository) {
        this.metamod_repository = metamod_repository;
    }

    @Override
    public List getMethods() {
        LinkedList result = new LinkedList();
        List class_list = this.getClasses();
        for (Class classobj : class_list) {
            result.addAll(classobj.getMethods());
        }
        return result;
    }

    @Override
    public boolean classIsAbstract(Class class_obj, boolean isTrue) {
        if (isTrue) {
            return class_obj.isAbstract();
        }
        return !class_obj.isAbstract();
    }

    @Override
    public boolean classIsInterface(Class class_obj, boolean isTrue) {
        if (isTrue) {
            return class_obj.isInterface();
        }
        return !class_obj.isInterface();
    }

    @Override
    public boolean classContainsMethod(Class class_obj, Method contained_method_obj) {
        return this.getContainedMethodsOfClass(class_obj).contains(contained_method_obj);
    }

    @Override
    public Collection getContainedMethodsOfClass(Class class_obj) {
        return class_obj.getMethods();
    }

    @Override
    public boolean classHasSubclass(Class class_obj, Class sub_class_obj) {
        return this.getSubclassesOfClass(class_obj).contains(sub_class_obj);
    }

    @Override
    public Collection getSubclassesOfClass(Class class_obj) {
        return class_obj.getAllDescendants();
    }

    @Override
    public boolean classHasSuperclass(Class class_obj, Class super_class_obj) {
        return this.getSuperclassesOfClass(class_obj).contains(super_class_obj);
    }

    @Override
    public Collection getSuperclassesOfClass(Class class_obj) {
        return class_obj.getAllAncestors(true);
    }

    @Override
    public Collection getContainedConstructorsOfClass(Class class_obj) {
        return class_obj.getConstructors();
    }

    @Override
    public boolean classContainsConstructor(Class class_obj, Constructor constructor) {
        return this.getContainedConstructorsOfClass(class_obj).contains(constructor);
    }

    @Override
    public boolean methodIsAbstract(Method method_obj, boolean isTrue) {
        if (isTrue) {
            return method_obj.isAbstract();
        }
        return !method_obj.isAbstract();
    }

    @Override
    public boolean methodContainsFormalParameter(Method method_obj, FormalParameter contained_formalparameter_obj) {
        return this.getFormalParametersOfMethod(method_obj).contains(contained_formalparameter_obj);
    }

    @Override
    public Collection getFormalParametersOfMethod(Method method_obj) {
        return method_obj.getFormalParameters();
    }

    @Override
    public boolean methodContainsFunctionAccess(Method method_obj, FunctionAccess contained_functionaccess_obj) {
        return this.getContainedFunctionAccessesOfMethod(method_obj).contains(contained_functionaccess_obj);
    }

    @Override
    public Collection getContainedFunctionAccessesOfMethod(Method method_obj) {
        return method_obj.getFunctionAccesses();
    }

    @Override
    public boolean methodContainsStatement(Method method_obj, Statement contained_statement_obj) {
        return this.getContainedStatementsOfMethod(method_obj).contains(contained_statement_obj);
    }

    @Override
    public Collection getContainedStatementsOfMethod(Method method_obj) {
        Vector<Statement> result = new Vector<Statement>();
        BlockStatement body = method_obj.getBody();
        if (body == null) {
            return result;
        }
        StatementTreeWalker walker = new StatementTreeWalker((Statement)body);
        do {
            Statement stm = walker.getStatement();
            result.add(stm);
        } while (walker.next());
        return result;
    }

    @Override
    public boolean methodHasNumberOfFormalParameters(Method method_obj, int number_of_formalparameters) {
        return this.getFormalParametersOfMethod(method_obj).size() == number_of_formalparameters;
    }

    @Override
    public boolean methodIsReferencedByFunction(Method method_obj, Function referencing_function_obj) {
        return this.getReferencingFunctionsOfMethod(method_obj).contains(referencing_function_obj);
    }

    @Override
    public Collection getReferencingFunctionsOfMethod(Method method_obj) {
        return method_obj.referencingFunctions();
    }

    @Override
    public Object getReturnTypeOfMethod(Method method) {
        return method.getReturnType();
    }

    @Override
    public boolean methodIsContainedInClass(Method method, Class class1) {
        if (class1 == null) {
            return false;
        }
        return method.getSurroundingClass() == class1;
    }

    @Override
    public boolean methodIsStatic(Method method, boolean isTrue) {
        if (isTrue) {
            return method.isStatic();
        }
        return !method.isStatic();
    }

    @Override
    public int numberOfStatements(Method method) {
        return method.getNumberOfStatements();
    }

    @Override
    public String nameOfMethod(Method method) {
        return method.getSimpleName();
    }

    @Override
    public boolean methodHasReturnType(Method method, boolean isTrue) {
        if (method.getReturnType() == null) {
            return false;
        }
        if (isTrue) {
            return !method.getReturnType().getSimpleName().equals("void");
        }
        return method.getReturnType().getSimpleName().equals("void");
    }

    @Override
    public boolean methodHasBooleanReturnType(Method method, boolean isTrue) {
        boolean hasReturnType = this.methodHasReturnType(method, true);
        if (!hasReturnType && isTrue) {
            return false;
        }
        boolean result = false;
        result = hasReturnType ? method.getReturnType().getSimpleName().equals("boolean") : false;
        if (isTrue) {
            return result;
        }
        return !result;
    }

    @Override
    public boolean methodHasMaxNumberOfFormalParameters(Method method, int number) {
        return this.getFormalParametersOfMethod(method).size() <= number;
    }

    public boolean methodHasMinNumberOfFormalParameters(Method method, int number) {
        return this.getFormalParametersOfMethod(method).size() >= number;
    }

    @Override
    public Collection getContainerClassOfMethod(Method method) {
        Vector<Class> result = new Vector<Class>();
        result.add(method.getSurroundingClass());
        return result;
    }

    @Override
    public Object getContainerClassOfConstructor(Constructor constructor) {
        return constructor.getSurroundingClass();
    }

    @Override
    public boolean formalParameterIsOfType(FormalParameter formalparameter_obj, Type type_of_formalparameter_obj) {
        if (formalparameter_obj.getType() == null) {
            return false;
        }
        return formalparameter_obj.getType() == type_of_formalparameter_obj;
    }

    @Override
    public Collection getTypesOfFormalParameter(FormalParameter parameter) {
        Vector<Type> result = new Vector<Type>();
        if (parameter.getType() != null) {
            result.add(parameter.getType());
        }
        return result;
    }

    @Override
    public boolean functionAccessHasFunctionTarget(FunctionAccess functionaccess_obj, Function target_function_obj) {
        Function target_function_real = functionaccess_obj.getAccessedFunction();
        if (target_function_real == null) {
            return false;
        }
        return target_function_real == target_function_obj;
    }

    @Override
    public boolean functionAccessTargetIsAbstract(FunctionAccess functionaccess_obj, boolean isTrue) {
        Function target_function_real = functionaccess_obj.getAccessedFunction();
        if (target_function_real == null) {
            return false;
        }
        if (target_function_real instanceof Method) {
            return this.methodIsAbstract((Method)target_function_real, isTrue);
        }
        return false;
    }

    @Override
    public boolean functionAccessTargetIsInClassConstraint(FunctionAccess functionaccess_obj, Class container_class_obj) {
        Function target_function_real = functionaccess_obj.getAccessedFunction();
        if (target_function_real == null) {
            System.out.println("functionAccessTargetIsInClassConstraint(): target function null");
            return false;
        }
        if (target_function_real instanceof Method) {
            boolean result = this.classContainsMethod(container_class_obj, (Method)target_function_real);
            return result;
        }
        if (target_function_real instanceof Constructor) {
            boolean result = this.classContainsConstructor(container_class_obj, (Constructor)target_function_real);
            return result;
        }
        System.out.println("functionAccessTargetIsInClassConstraint(): target function not method");
        return false;
    }

    @Override
    public Collection getFunctionTargetsOfFunctionAccess(FunctionAccess access) {
        Vector<Function> result = new Vector<Function>();
        if (access.getAccessedFunction() != null) {
            result.add(access.getAccessedFunction());
        }
        return result;
    }

    @Override
    public Collection getSurroundingClassesOfFunctionAccessTarget(FunctionAccess access) {
        Vector<Class> result = new Vector<Class>();
        if (access.getAccessedFunction() != null && access.getAccessedFunction() instanceof Member) {
            Member member_function = (Member)access.getAccessedFunction();
            if (member_function.getSurroundingClass() != null) {
                result.add(member_function.getSurroundingClass());
            } else {
                System.out.println("getSurroundingClassesOfFunctionAccessTarget(): surrounding class of accessed function was null.");
            }
        } else {
            System.out.println("getSurroundingClassesOfFunctionAccessTarget(): accessed function was null or not member");
        }
        return result;
    }

    @Override
    public boolean statementContainsFunctionAccess(Statement statement_obj, FunctionAccess contained_functionaccess_obj) {
        return this.getContainedFunctionAccessesOfStatement(statement_obj).contains(contained_functionaccess_obj);
    }

    @Override
    public Collection getContainedFunctionAccessesOfStatement(Statement statement_obj) {
        Vector<Access> result = new Vector<Access>();
        StatementTreeWalker walker = new StatementTreeWalker(statement_obj);
        do {
            Statement stm = walker.getStatement();
            ModelElementList accesses = stm.getAccesses();
            for (Access access : accesses) {
                if (!(access instanceof FunctionAccess)) continue;
                result.add(access);
            }
        } while (walker.next());
        return result;
    }

    @Override
    public boolean statementIsOfType(Statement statement_obj, java.lang.Class statement_class) {
        return statement_obj.getClass() == statement_class;
    }

    @Override
    public String getFullQualifiedNameOfMetamodObject(ModelElement obj) {
        if (obj instanceof ModelElement) {
            return MetamodRetrievalEngineImplementation.calculateFullQualifiedName(obj);
        }
        return obj.toString();
    }

    public static String calculateFullQualifiedName(ModelElement nme) {
        String fqn = "";
        if (nme == null) {
            return fqn;
        }
        if (nme instanceof Package) {
            return ((Package)nme).getQualifiedName();
        }
        if (nme instanceof Class) {
            return ((Class)nme).getQualifiedName();
        }
        if (nme instanceof Method) {
            Method method = (Method)nme;
            Iterator itr = method.getFormalParameters().iterator();
            String fp_text = "";
            while (itr.hasNext()) {
                FormalParameter fp = (FormalParameter)itr.next();
                fp_text = String.valueOf(fp_text) + fp.getType().getQualifiedName();
                if (!itr.hasNext()) continue;
                fp_text = String.valueOf(fp_text) + ",";
            }
            return String.valueOf(MetamodRetrievalEngineImplementation.calculateFullQualifiedName((ModelElement)((Method)nme).getSurroundingClass())) + "." + ((Method)nme).getSimpleName() + "(" + fp_text + ")";
        }
        if (nme instanceof Constructor) {
            Constructor constr = (Constructor)nme;
            Iterator itr = constr.getFormalParameters().iterator();
            String fp_text = "";
            while (itr.hasNext()) {
                FormalParameter fp = (FormalParameter)itr.next();
                fp_text = String.valueOf(fp_text) + fp.getType().getQualifiedName();
                if (!itr.hasNext()) continue;
                fp_text = String.valueOf(fp_text) + ",";
            }
            return String.valueOf(MetamodRetrievalEngineImplementation.calculateFullQualifiedName((ModelElement)((Constructor)nme).getSurroundingClass())) + "." + ((Constructor)nme).getSimpleName() + "(" + fp_text + ")";
        }
        if (nme instanceof Field) {
            return String.valueOf(MetamodRetrievalEngineImplementation.calculateFullQualifiedName((ModelElement)((Field)nme).getSurroundingClass())) + "." + ((Field)nme).getSimpleName();
        }
        if (nme instanceof Access) {
            Access access = (Access)nme;
            return "target: " + MetamodRetrievalEngineImplementation.calculateFullQualifiedName((ModelElement)access.getAccessedTarget());
        }
        if (nme instanceof NamedModelElement) {
            return ((NamedModelElement)nme).getSimpleName();
        }
        return nme.toString();
    }

    public static boolean typesAreFitting(Type type1, Type type2) {
        if (type1 instanceof Class && type2 instanceof Class) {
            return ((Class)type1).getAllSuperTypes().contains((Object)type2) || ((Class)type2).getAllSuperTypes().contains((Object)type1) || type1 == type2;
        }
        return false;
    }

    public boolean methodsAreContainedInSameClass(Method method, Method method2) {
        Class class2;
        Class class1 = method.getSurroundingClass();
        return class1.isSubTypeOf(class2 = method2.getSurroundingClass()) || class2.isSubTypeOf(class1) || class1 == class2;
    }

    public boolean methodFormalParametersAreMatching(Method method, Method method2) {
        if (method.getFormalParameters().size() != method2.getFormalParameters().size()) {
            return false;
        }
        boolean matching = true;
        int i = 0;
        while (i < method.getFormalParameters().size()) {
            FormalParameter fp1 = (FormalParameter)method.getFormalParameters().get(i);
            FormalParameter fp2 = (FormalParameter)method2.getFormalParameters().get(i);
            if (fp1.getType() != fp2.getType()) {
                matching = false;
                break;
            }
            ++i;
        }
        return matching;
    }
}

