/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer;

import de.fzi.sissy.commandline.SISSyRunner;
import de.fzi.sissy.dpanalyzer.DesignPatternDescription;
import de.fzi.sissy.dpanalyzer.DesignPatternDescriptionGenerator;
import de.fzi.sissy.dpanalyzer.DesignPatternInstance;
import de.fzi.sissy.dpanalyzer.DesignPatternRetrievalProcess;
import de.fzi.sissy.dpanalyzer.MetamodRetrievalEngineImplementation;
import de.fzi.sissy.dpanalyzer.XMLExporter;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DesignPatternAnalyzer {
    private static Map resultPatternMap;

    public static void main(String[] args) {
        Debug.info((String)"==================================");
        Debug.info((String)"WELCOME TO DESIGN-PATTERN-ANALYZER");
        Debug.info((String)"==================================");
        Debug.info((String)"");
        Debug.info((String)"Extracting Metamod...");
        SISSyRunner.main((String[])args);
        Debug.setDebugLevel((int)6);
        Debug.info((String)"");
        Debug.info((String)"Extracting Metamod...finished");
        ModelElementRepository metamod_repository = ModelElementRepository.getWorkingRepository();
        MetamodRetrievalEngineImplementation metamod_retrieval_engine = MetamodRetrievalEngineImplementation.getSingleton();
        metamod_retrieval_engine.setMetamodRepository(metamod_repository);
        DesignPatternRetrievalProcess retrieval_process = DesignPatternRetrievalProcess.getSingleton();
        resultPatternMap = new HashMap();
        Debug.info((String)"Build DesignPatternDescriptions...");
        DesignPatternDescriptionGenerator.getSingleton().buildDesignPatternDescriptions();
        Iterator dpd_itr = DesignPatternDescriptionGenerator.getSingleton().getDesignPatternDescriptionList().iterator();
        Debug.info((String)"");
        Debug.info((String)"--------------------------------------------------------------------------");
        Debug.info((String)"          STARTING DESIGN-PATTERN-ANALYSES NOW !!!                        ");
        Debug.info((String)"--------------------------------------------------------------------------");
        Debug.info((String)"");
        while (dpd_itr.hasNext()) {
            DesignPatternDescription dpd = (DesignPatternDescription)dpd_itr.next();
            Debug.info((String)("Extracting " + dpd.getDesignPatternName() + ": "));
            retrieval_process.setup(dpd);
            retrieval_process.start();
            Collection dp_instances = retrieval_process.getResultDPInstances();
            if (!dp_instances.isEmpty()) {
                resultPatternMap.put(dpd.getDesignPatternName(), dp_instances);
            } else {
                Debug.info((String)("No DP-Instances found for " + dpd.getDesignPatternName()));
            }
            Debug.info((String)"--------------------------------------------------------------------------");
            Debug.info((String)"");
        }
        XMLExporter.getSingleton().exportToXMLFile(resultPatternMap);
        DesignPatternAnalyzer.printExtractionSummary();
    }

    private static void printExtractionSummary() {
        System.out.println();
        System.out.println("--------------------------------");
        System.out.println("DESIGNPATTERN EXTRACTION-SUMMARY");
        System.out.println("--------------------------------");
        System.out.println();
        for (String dpd_name : resultPatternMap.keySet()) {
            System.out.println("======================================================");
            System.out.println(String.valueOf(dpd_name) + "-Instances:");
            System.out.println("======================================================");
            System.out.println();
            for (DesignPatternInstance dpi : (Collection)resultPatternMap.get(dpd_name)) {
                System.out.println(String.valueOf(dpd_name) + "-Instance:");
                System.out.println();
                System.out.println(dpi.toString());
                System.out.println("-----------------------------------------------------------------------------");
                System.out.println();
            }
            System.out.println();
        }
        for (String dpd_name : resultPatternMap.keySet()) {
            System.out.println("Found " + dpd_name + "-Instances: " + ((Collection)resultPatternMap.get(dpd_name)).size());
        }
        System.out.println();
    }
}

