/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT 
	subclasspackage.fullname as containing_package_name, 
	baseclasspackage.fullname as contained_package_name,
	subclass.name as subclass_full_name,
	baseclass.name as superclass_full_name,
	inheritsfrom.depthofinheritance as depth_of_inheritance,
	subfile.pathname as subclass_file_name,
	subsource.startLine as subclass_line_number,
	basefile.pathname as superclass_file_name,
	basesource.startLine as superclass_line_number
FROM 
	ttypes subclass, 
	ttypes baseclass,
	TModelElements mSubClass,
	TModelElements mBaseClass,
	TConstants cmSubClass,
	TConstants cmBaseClass,
	tinheritances inheritsfrom, 
	tpackages baseclasspackage, 
	tpackages subclasspackage,
	TSourceEntities subsource,
	TFiles subfile,
	TSourceEntities basesource,
	TFiles basefile,
	TPackageContainmentRelations pcr
WHERE 
	subClass.id = mSubClass.id
	AND	mSubClass.status = cmSubClass.value
	AND 	cmSubClass.name = 'STATUS_NORMAL'
	AND 	baseClass.id = mBaseClass.id
	AND	mBaseClass.status = cmBaseClass.value
	AND 	cmBaseClass.name = 'STATUS_NORMAL'
	AND subclass.id = inheritsfrom.classid AND
	baseclass.id = inheritsfrom.superid AND
	baseclasspackage.id = baseclass.packageid AND
	subclasspackage.id = subclass.packageid AND

	/* Nur Source-Pakete analysieren */ 
	subsource.id = subclass.id AND
	subsource.sourcefileid = subfile.id AND
	basesource.id = baseclass.id AND
	basesource.sourcefileid = basefile.id AND
	
	/* Ist im Unterpaket vorhanden */
	baseclasspackage.id != subclasspackage.id AND
	baseclasspackage.fullName != '' AND
	subclasspackage.fullName != '' AND
	pcr.packageid =  baseclasspackage.id AND
	pcr.containingpackageid = subclasspackage.id AND

	/* Keine transitive Vererbung */
	inheritsfrom.depthofinheritance = 1

ORDER BY
	inheritsfrom.depthofinheritance
;
