/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	sub.fullname as abstract_subclass_name,
	super.fullname as non_abstract_superclass_name,
	fSub.pathname as subclass_file_name,
	seSub.startline as subclass_line_number,
	fSuper.pathname as superclass_file_name,
	seSuper.startline as superclass_line_number
FROM
	TTypes as sub,
	TTypes as super,
	TModelElements mSub,
	TModelElements mSuper,
	TConstants cmSub,
	TConstants cmSuper,
	TSourceEntities as seSub,
	TSourceEntities as seSuper,
	TFiles as fSub,
	TFiles as fSuper,
	TInheritances as inh,
	TMembers as memSub,
	TMembers as memSuper,
	TConstants as constTypeClass
WHERE
	sub.id = mSub.id
	AND mSub.status = cmSub.value
	AND cmSub.name = 'STATUS_NORMAL'
	AND super.id = mSuper.id
	AND mSuper.status = cmSuper.value
	AND cmSuper.name = 'STATUS_NORMAL'
	/* all system defined classes that are related */
	AND constTypeClass.name = 'TYPE_CLASS' and
	/* avoid interfaces and others */
	super.kindOfType = constTypeClass.value and 
	inh.superId=super.id and
	inh.classId=sub.id and
	seSub.id = sub.id and
	seSuper.id = super.id and
	seSub.sourceFileId = fSub.id and
	seSuper.sourceFileId = fSuper.id and
	memSub.id = sub.id and
	memSuper.id = super.id and
	memSub.isabstract = 1 and
	memSuper.isabstract = 0
;
