/* $Id: VersteckteKonstantheit.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */


select distinct
        p.fullname as package_full_name,
	C.fullName as class_full_name,
	a.name as variable_name,
        f.pathname as file_name,
        seC.startLine as line_number
from
	TTypes as C,
	TModelElements mC,
	TMembers as a,
	TSourceEntities as seC,
        TPackages as p,
        TFiles as f
where
	mC.id = C.id	
        AND p.id = C.packageid
        AND seC.sourcefileid = f.id

	/* 161 = STATUS_NORMAL */
	AND mC.status = 161

	/* C is a system defined class */
	AND seC.id = C.id and
	seC.sourceFileId >= 0 and
	
	/* 65 = VAR_FIELD */
	a.kindOfMember = 65 and
	a.classId = C.id and
	a.isFinal = 0 and
	a.isStatic = 1


/* take out those that have a write access  pointing to them */
except

select distinct
        p.fullname as package_full_name,
	C.fullName as class_full_name,
	a.name as variable_name,
        f.pathname as file_name,
        seC.startLine as startLine
from
	TTypes as C,
	TMembers as a,
	TSourceEntities as seC,
	TAccesses as acc,
	TFunctions as accBelongsToFunction,
	TConstants as funcType,
        TPackages as p,
        TFiles as f
where
	
	/* C is a system defined class */
	seC.id = C.id
        AND p.id = C.packageid
	AND seC.sourceFileId >= 0 
        AND seC.sourcefileid = f.id
        AND
	
	/* 65 = VAR_FIELD */
	a.kindOfMember = 65 and	
	a.classId = C.id and
	a.isFinal = 0 and
	a.isStatic = 1 and
	
	/* there's a write access to a */
	/* 82 = VARACCESS_READ */
	acc.kindOfAccess = 82 and
	acc.targetId = a.id AND

	/* No access in initializer */
	/* 55 = FUNC_INITIALIZER */
	acc.functionid = accBelongsToFunction.id AND
	accBelongsToFunction.kindoffunction <> 55
;