/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE TABLE VKnowsRel AS 	
	SELECT DISTINCT 
		res.classId
		, res.className
		, res.knownClassId
		, res.knownClassName
	FROM (
		/* Inheritance relations */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TConstants con
			, TAccesses acc
			, TTypes cls
			, TTypes knowncls
		WHERE	
			con.name = 'TYPEACCESS_INHERITANCE' 
			AND con.value = acc.kindOfAccess 
			AND acc.sourceId = cls.id 
			AND acc.targetId = knowncls.id
	
		UNION

	/* Decorated type accesses */
	select distinct	
		cls.id as ClassId, 
		cls.fullName as ClassName,
		knowncls.id as KnownClassId, 
		knowncls.fullName as KnownClassName
	from	
		TConstants con, 
		TAccesses acc,
		TTypes cls,
		TTypes decoratorType,
		TTypes knowncls
	where	
		con.name like 'TYPEACCESS_%' and
		con.value = acc.kindOfAccess and
		acc.classId = cls.id and
		acc.targetId = decoratorType.id
		AND decoratorType.decoratedTypeid = knowncls.id
	union

	
		/* Exception declarations AND casts */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TConstants con
			, TAccesses acc
			, TTypes cls
			, TMembers m
			, TTypes knowncls
		WHERE	
			(con.name = 'TYPEACCESS_THROW' OR
			con.name = 'TYPEACCESS_CAST') 
			AND con.value = acc.kindOfAccess 
			AND acc.functionId = m.id 
			AND m.classId = cls.id 
			AND acc.targetId = knowncls.id
	
		UNION
	
		/* Attributes AND properties */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TTypes AS cls
			, TMembers AS m
			, TVariables AS var
			, TAccesses AS acc
			, TTypes knowncls
		WHERE	
			cls.id = m.classId 
			AND m.id = var.id 
			AND var.typeDeclarationId = acc.id 
			AND acc.targetId = knowncls.id
	
		UNION
	
		/* Formal parameters, catch parameters AND local variables */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM	
			TTypes AS cls
			, TMembers AS m
			, TVariables AS var
			, TAccesses AS acc
			, TTypes knowncls
		WHERE	
			cls.id = m.classId 
			AND m.id = var.functionId 
			AND var.typeDeclarationId = acc.id 
			AND acc.targetId = knowncls.id
		
		UNION
		
		/* Return type */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM
			TTypes AS cls
			, TMembers AS m
			, TFunctions AS func
			, TAccesses AS acc
			, TTypes knowncls
		WHERE	
			cls.id = m.classId 
			AND m.id = func.id 
			AND func.returnTypeDeclarationId = acc.id 
			AND acc.targetId = knowncls.id
	
		UNION
		
		/* Accesses to members */
		SELECT DISTINCT	
			cls.id AS ClassId
			, cls.fullName AS ClassName
			, knowncls.id AS KnownClassId
			, knowncls.fullName AS KnownClassName
		FROM
			TTypes AS cls
			, TMembers AS sm
			, TAccesses acc
			, TMembers AS dm
			, TTypes knowncls
		WHERE	
			cls.id = sm.classId 
			AND acc.functionId = sm.id 
			AND acc.targetId = dm.id 
			AND dm.classId = knowncls.id
	) AS res
	/* no library classes */
/*	JOIN TSourceEntities AS s ON (res.classId = s.id AND s.assemblyFileId = -1) */
		, TTypes AS types
		, TConstants AS c
	WHERE	
		res.classId != res.knownClassId 
		AND res.knownClassId = types.id 
		AND types.kindOfType = c.value 
		AND (
			c.name like '%CLASS' 
			OR c.name like '%INTERFACE'
		)
;



CREATE TABLE TSubsystemKnowsClassBased AS

SELECT
	abstraction1.id AS id1,
	abstraction1.name AS name1,
	abstraction2.id AS id2,
	abstraction2.name AS name2
FROM
	VKnowsRel knowsRel join
	TTypes type1 on (knowsRel.classid = type1.id) join
	TSourceEntities sourceEntity1 on (type1.id = sourceEntity1.id) join
	TFiles file1 on (sourceEntity1.sourcefileid = file1.id) join
	TAbstractionElements abstractionElement1 on (file1.id = abstractionElement1.modelelementid) join 
	TAbstractions abstraction1 on (abstraction1.id = abstractionElement1.abstractionid AND abstraction1.type = 'Subsystem') join
	TTypes type2 on (knowsRel.knownclassid = type2.id) join
	TSourceEntities sourceEntity2 on (type2.id = sourceEntity2.id) join
	TFiles file2 on (sourceEntity2.sourcefileid = file2.id) join
	TAbstractionElements abstractionElement2 on (file2.id = abstractionElement2.modelelementid) join 
	TAbstractions abstraction2 on (abstraction2.id = abstractionElement2.abstractionid AND abstraction2.type = 'Subsystem') 
WHERE
	abstraction1.id <> abstraction2.id

;

CREATE TABLE TSubsystemKnowsFileBased AS

SELECT
	abstraction1.id AS id1,
	abstraction1.name AS name1,
	abstraction2.id AS id2,
	abstraction2.name AS name2
FROM
	TImports imports join
	TFiles file1 on (imports.fileid = file1.id) join
	TAbstractionElements abstractionElement1 on (file1.id = abstractionElement1.modelelementid) join 
	TAbstractions abstraction1 on (abstraction1.id = abstractionElement1.abstractionid AND abstraction1.type = 'Subsystem') join
	TFiles file2 on (imports.targetid = file2.id) join
	TAbstractionElements abstractionElement2 on (file2.id = abstractionElement2.modelelementid) join 
	TAbstractions abstraction2 on (abstraction2.id = abstractionElement2.abstractionid AND abstraction2.type = 'Subsystem') 
WHERE
	abstraction1.id <> abstraction2.id

;


SELECT DISTINCT
	subsystemKnowsClassBased.name1 as subsystem_name_1,
	subsystemKnowsClassBased.name2 as subsystem_name_2
FROM
	TSubsystemKnowsClassBased subsystemKnowsClassBased
WHERE
	subsystemKnowsClassBased.id1 > subsystemKnowsClassBased.id2

UNION

SELECT DISTINCT
	subsystemKnowsFileBased.name1 as subsystem_name_1,
	subsystemKnowsFileBased.name2 as subsystem_name_2
FROM
	TSubsystemKnowsFileBased subsystemKnowsFileBased
WHERE
	subsystemKnowsFileBased.id1 > subsystemKnowsFileBased.id2
;

DROP TABLE TSubsystemKnowsFileBased;
DROP TABLE TSubsystemKnowsClassBased;
DROP TABLE VKnowsRel; 
