/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	packOne.fullname as package_name_1,
	typeOne.fullname as class_name_1,
	sigOne.signature as function_signature_1,
	packTwo.fullname as package_name_2,
	typeTwo.fullname as class_name_2,
	sigTwo.signature as function_signature_2,
	file1.pathname as file_name_1,
	src1.startline as line_number_1,
	file2.pathname as file_name_2,
	src2.startline as line_number_2	
FROM
	TAccesses as accessesOne inner join
	TAccesses as accessesTwo on (accessesOne.targetid = accessesTwo.functionid and accessesTwo.targetid = accessesOne.functionid) inner join
	TFunctions as funcOne on (funcOne.id = accessesOne.functionid) inner join
	TSignatures sigOne on (funcOne.id = sigOne.functionId)  join
	TModelElements m1 on (funcOne.id = m1.id) join
	TConstants cm1 on (cm1.value = m1.status and cm1.name = 'STATUS_NORMAL') join	
	TFunctions as funcTwo on (funcTwo.id = accessesTwo.functionid and funcOne.id < funcTwo.id) inner join
	TSignatures sigTwo on (sigTwo.functionId = funcTwo.id) join
	TModelElements m2 on (funcTwo.id = m2.id) join
	TConstants cm2 on (cm2.value = m2.status and cm2.name = 'STATUS_NORMAL') join	
	TPackages packOne on (funcOne.packageId = packOne.id) join
	TPackages packTwo on (funcTwo.packageId = packTwo.id) left outer join
	TTypes as typeOne on (funcOne.classid = typeOne.id) left outer join
	TTypes as typeTwo on (funcTwo.classid = typeTwo.id) left outer join
	TSourceEntities src1 on (funcOne.id = src1.id) left outer join
	TFiles file1 on (src1.sourceFileId = file1.id) left outer join
	TSourceEntities src2 on (funcTwo.id = src2.id) left outer join
	TFiles file2 on (src2.sourceFileId = file2.id)	
;
