
/* Bestimmen der Anzahl der ffentlichen Methoden pro Klasse*/
create table TPublicMethodsPerClass as

select 
	type.id,
	count (function.id) as count
from
	TTypes type join 
	TModelElements mType on (type.id = mType.id and mType.status = 161 ) join /* 161 = 'STATUS_NORMAL' */
	TFunctions function on (type.id = function.classid) join
	TMembers funcMember on (function.id = funcMember.id and funcMember.visibility = 145 and function.kindoffunction = 52)
	/* 145 = VISIBILITY_PUBLIC 52 = FUNC_METHOD */
group by
	type.id
;


create table vpairswithcommonsupertype as 

	select
		type1.id as type1id,
		type2.id as type2id
	from
		TTypes type1,
		TModelElements mType1,
		TTypes type2,
		TModelElements mType2,
		TInheritances inh
	where
		type1.id = mType1.id
		and mType1.status = 161
		and type2.id = mType2.id
		and mType2.status = 161
		and ((inh.classid = type1.id and inh.superid = type2.id) or
			(inh.classid = type2.id and inh.superid = type1.id))
		
	
	union

	select
		type1.id as type1id,
		type2.id as type2id
	from
		TTypes type1,
		TModelElements mType1,
		TTypes type2,
		TModelElements mType2,
		TTypes type3,
		TInheritances inh,
		TInheritances inh2
	where
		type1.id = mType1.id
		and mType1.status = 161
		and type2.id = mType2.id
		and mType2.status = 161
		and inh.classid = type1.id
		and inh2.classid = type2.id
		and inh.superid = inh2.superid
		and inh2.superid = type3.id
		and type3.fullname <> 'java.lang.Object'
		
;


/* Bestimme die potentiellen Trefferpaare, also alle Paare von Klassen, die nicht in einer (in)direkten Vererbungsbeziehung zueinander stehen, d.h. die auch keine gemeinsame Oberklasse haben */

create table tpotentialpairs as 
select
	clsA.id as Class_A_Id,
	clsB.id as Class_B_Id,
	clsA.fullname as aname,
	clsB.fullname as bname
from
	TTypes clsA 
inner join
	TTypes clsB on (clsB.id > clsA.id and clsA.classid = -1 and clsB.classid = -1)
join	
	TModelElements mTypeA on (clsA.id = mTypeA.id and mTypeA.status = 161) /* 161 = STATUS_NORMAL */
join	
	TModelElements mTypeB on (clsB.id = mTypeB.id and mTypeB.status = 161) /* 161 = STATUS_NORMAL */  
left outer join
	Vpairswithcommonsupertype pairs on (clsA.id = pairs.type1id and clsB.id = pairs.type2id)
group by
	clsA.id,
	clsB.id,
	clsA.fullname,
	clsB.fullname
having count(pairs.type1id) = 0
;




/* Bestimme fr jedes Klassenpaar, die Anzahl der ffentlichen Methoden, deren Signaturen bereinstimmen*/
create Table TCommonMethodsPerClassPair as

select
	tpp.Class_A_Id as Class_A_Id,
	tpp.Class_B_Id as Class_B_id,
	count (funcA.id)
from
	TPotentialPairs tpp
join
	TMembers funcA on tpp.Class_A_Id = funcA.classId and funcA.kindOfMember = 52 and funcA.visibility = 145 /* 52 = FUNC_METHOD 145 = VISIBLITY_PUBLIC*/
inner join
	TSignatures sigA on funcA.id = sigA.functionId
inner join
	TSignatures sigB on (sigA.signature = sigB.signature and sigA.functionId != sigB.functionId)
inner join
	TMembers funcB on (tpp.Class_B_Id = funcB.classId and sigB.functionId = funcB.id and funcB.visibility = 145)
group by
	tpp.Class_A_Id,
	tpp.Class_B_Id
;


/* Bestimme fr die potentiellen Paare die Anzahl der ffentlichen Methoden mit identischen Signaturen */
create table TNumberOfIdenticalSignatures as

select
	sa.id as Class_A_id,
	sb.id as Class_B_id,
	pp.aname,
	pp.bname,
	cmpc.count as numberMethodSignatures
from
	TPotentialPairs pp join
	TCommonMethodsPerClassPair cmpc on (pp.Class_A_Id = cmpc.Class_A_Id and pp.Class_B_id = cmpc.Class_B_id) join
	TSourceEntities as sA on (sA.id = cmpc.Class_A_Id and 	sA.sourceFileId >= 0 ) join
	TSourceEntities as sB on (sB.id = cmpc.Class_B_Id and 	sB.sourceFileId >= 0 )
;


/* Alle Paare ausgeben, die mehr als 50% identische Methoden haben */
select 
        p_A.fullname as package_A_full_name,
        nois.aname as class_A_full_name,
        f_A.pathname as A_file_name,

        p_B.fullname as package_B_full_name,
        nois.bname as class_B_full_name,
        f_B.pathname as B_file_name,

        nois.numberMethodSignatures as number_of_identical_method_signatures,
        pmpcA.count as number_of_public_methods_of_A,
        pmpcB.count as number_of_public_methods_of_B
from
	TNumberOfIdenticalSignatures nois join
	TPublicMethodsPerClass pmpcA on (nois.Class_A_id = pmpcA.id) join
	TPublicMethodsPerClass pmpcB on (nois.Class_B_id = pmpcB.id) join
        TTypes A on (A.id = nois.Class_A_id) join
        TTypes B on (B.id = nois.Class_B_id) join
        TPackages p_A on (p_A.id = A.packageId) join
        TPackages p_B on (p_B.id = B.packageId) join
        TSourceEntities se_A on (se_A.id = A.id) join
        TFiles f_A on (se_A.sourcefileid = f_A.id) join
        TSourceEntities se_B on (se_B.id = B.id) join
        TFiles f_B on (se_B.sourcefileid = f_B.id)
where
   nois.NumberMethodSignatures >= 10 or 
   (
      ((CAST(nois.NumberMethodSignatures as real) / pmpcA.count * 100) > 50) and
      ((CAST(nois.NumberMethodSignatures as real) / pmpcB.count * 100) > 50)
   )
;


drop table TPublicMethodsPerClass;
drop table Vpairswithcommonsupertype;
drop table TPotentialPairs;
drop table TCommonMethodsPerClassPair;
drop table TNumberOfIdenticalSignatures;



