/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE OR REPLACE VIEW VConstants AS

SELECT
	var.id as ConstantId,
	var.name as ConstantName,
	cls.fullname as ClassName,
	pack.fullname as PackageName
FROM
	TVariables var join
	TModelElements meVar on (meVar.id = var.id) join
	TConstants cmVar on (cmVar.value = meVar.status and cmVar.name = 'STATUS_NORMAL') join
	TConstants cVar on (var.kindofvariable = cVar.value) join
	TMembers mVar on (mVar.id = var.id and mVar.isstatic = 1) join
	TConstants cMem on (cMem.value = mVar.visibility) left outer join
	TTypes cls on (mVar.classId = cls.id) left outer join
	TPackages pack on (var.packageId = pack.id)
	
WHERE
	cVar.name = 'VAR_FIELD' AND
	var.isconst = 1 AND
	cMem.name = 'VISIBILITY_PUBLIC'
;

SELECT
	con.ConstantName as constant_name,
	count(con.ConstantName) as number_of_redefinitions
FROM 
	VConstants con
GROUP BY
	con.ConstantName
HAVING 
	count(con.ConstantName) > 1
;

DROP VIEW VConstants;
