/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

CREATE TABLE TImportFrequency AS

SELECT
	file.pathname as file_name,
	importedfile.pathname as imported_file_name,
	COUNT(targetid) as number_of_imports
FROM
	TImports imports,
	TConstants constants,
	TFiles file,
	TFiles importedFile,
	TModelElements mFile,
	TConstants cmFile
WHERE
	constants.value = imports.kindoftarget
	AND constants.name = 'FILE_SOURCE'
	AND imports.fileid = file.id
	AND imports.targetid = importedFile.id
	AND mFile.id = file.id
	AND cmFile.value = mFile.status
	AND cmFile.name = 'STATUS_NORMAL'
GROUP BY
	file.pathname,
	importedfile.pathname

;


SELECT
	*
FROM
	TImportFrequency
WHERE
	number_of_imports > 1

;

DROP TABLE TImportFrequency;
