/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	types.fullname as unused_super_type,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM
	TTypes as types join
	TModelElements mType on (mType.id = types.id) join
	TConstants cmType on (cmType.value = mType.status and cmType.name = 'STATUS_NORMAL') join
	TFunctions as func on (func.classid = types.id) join
	TConstants as con on (con.value = func.kindoffunction and con.name = 'FUNC_METHOD') join
	TMembers as funcMember on (func.id = funcMember.id) join
	TConstants as con2 on (funcMember.visibility = con2.value and con2.name = 'VISIBILITY_PUBLIC') join
	TInheritances as inh on (inh.superid = types.id and inh.depthofinheritance = 1) left outer join
	TSourceEntities sourceEntities on (types.id = sourceEntities.id) left outer join
	TFiles files on (sourceEntities.sourcefileid = files.id) 

EXCEPT

(
/* Do not consider the superclasses, that have a public method, that is accessed from outside the hierarchy */
SELECT DISTINCT
	types.fullname as unused_super_type,
	files.pathname as file_name,
	sourceEntities.startLine as line_number
FROM
	TTypes as types join
	TFunctions as func on (func.classid = types.id) join
	TConstants as con on (con.value = func.kindoffunction and con.name = 'FUNC_METHOD') join
	TMembers as funcMember on (func.id = funcMember.id) join
	TConstants as con2 on (funcMember.visibility = con2.value and con2.name = 'VISIBILITY_PUBLIC') join
	TAccesses as access on (access.targetid = func.id) left outer join
	TSourceEntities sourceEntities on (types.id = sourceEntities.id) left outer join
	TFiles files on (sourceEntities.sourcefileid = files.id) 

WHERE
	NOT EXISTS (
		SELECT
			*
		FROM
			TInheritances accInh
		WHERE
			accInh.superid = types.id
			AND access.classid = accInh.classid
	)
	

)
;
