/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

create table TTypesWithCopyConstructor as 

select
	type.id,
	type.fullname,
	fsType.pathname,
	sType.startline
from
	TTypes type,
	TModelElements mType,
	TSourceEntities sType,
	TFiles fsType,	
	TFunctions function,
	TVariables var,
	TAccesses declarationAccess,
	TTypes targetType
where
	mType.id = type.id
	/* 161 = STATUS_NORMAL */
	AND mType.status = 161
	AND sType.id = type.id
	AND fsType.id = sType.sourcefileid
	AND type.id = function.classid
	/* 53 = FUNC_CONSTRUCTOR */
	AND function.kindoffunction = 53
	AND var.functionid = function.id
	/* 68 = VAR_FORMALPARAM */
	AND var.kindofvariable = 68
	AND declarationAccess.sourceid = var.id
	AND declarationAccess.targetid = targetType.id
	AND targetType.decoratedtypeid = type.id
	AND targetType.isreferencetype = 1
;

create table TClassesWithOperatorEquals as

select
	type.id,
	type.fullname,
	fsType.pathname,
	sType.startline
from
	TTypes type,
	TModelElements mType,
	TSourceEntities sType,
	TFiles fsType,	
	TFunctions operator,
	TVariables varOperator,
	TAccesses operatorDeclarationAccess,
	TTypes operatorTargetType
where

	mType.id = type.id
	/* 161 = STATUS_NORMAL */
	AND mType.status = 161
	AND sType.id = type.id
	AND fsType.id = sType.sourcefileid
	AND operator.classid = type.id
	AND operator.name = 'operator ='
	AND varOperator.functionid = operator.id
	/* 68 = VAR_FORMALPARAM */
	AND varOperator.kindofvariable = 68
	AND operatorDeclarationAccess.sourceid = varOperator.id
	AND operatorDeclarationAccess.targetid = operatorTargetType.id
	AND operatorTargetType.decoratedtypeid = type.id
	AND operatorTargetType.isreferencetype = 1
;


/* CLASSES with a virtual function */

SELECT
	functionType.fullname as class_name,
	fsType.pathname AS file_name,
	sType.startLine as line_number
FROM
	TFunctions function,
	TMembers functionMember,
	TTypes functionType,
	TModelElements m,
	TSourceEntities sType,
	TFiles fsType	
WHERE
	functionType.id = m.id
	/* 161 = STATUS_NORMAL */
	AND m.status = 161
	AND function.classid = functionType.id
	AND functionMember.id = function.id
	AND functionMember.isvirtual = 1
	/* 52 = FUNC_METHOD */
	AND function.kindoffunction = 52
	AND sType.id = functionType.id
	AND fsType.id = sType.sourcefileid

EXCEPT

/* Classes with a virtual constructor can be subtracted */

SELECT
	functionType.fullname as class_name,
	fsType.pathname AS file_name,
	sType.startLine as line_number
FROM
	TFunctions function,
	TMembers functionMember,
	TTypes functionType,
	TSourceEntities sType,
	TFiles fsType	
WHERE
	function.classid = functionType.id
	AND functionMember.id = function.id
	/* 54 = FUNC_DESTRUCTOR */
	AND function.kindoffunction = 54
	AND functionMember.isvirtual = 1
	AND sType.id = functionType.id
	AND fsType.id = sType.sourcefileid



UNION

(

/* Klassen, die mindestens einen der Pr- bzw. Postfixoperatoren implementieren */

select distinct
	type.fullname as class_name,
	fsType.pathname AS file_name,
	sType.startLine as line_number
	
from
	TTypes type,
	TModelElements mType,
	TFunctions func,
	TSignatures sFunc,
	TSourceEntities sType,
	TFiles fsType
where
	type.id = mType.id
	/* 161 = STATUS_NORMAL */
	AND mType.status = 161
	AND func.classid = type.id
	AND func.id = sFunc.functionid
	AND (sFunc.signature = 'operator ++()' 
		OR sFunc.signature ='operator ++(int)'
		OR sFunc.signature ='operator \-\-()'
		OR sFunc.signature ='operator \-\-(int)')
	AND sType.id = type.id
	AND fsType.id = sType.sourcefileid

except

/* Klassen, die sowohl den Postfix als auch den Prfixoperator implementieren sind ok */
	
	
select distinct
	type.fullname as class_name,
	fsType.pathname AS file_name,
	sType.startLine as line_number
from
	TTypes type,
	TModelElements mType,
	TConstants cmType,
	TFunctions func,
	TFunctions func2,
	TSignatures sFunc,
	TSignatures SFunc2,
	TSourceEntities sType,
	TFiles fsType	
where
	type.id = mType.id
	AND mType.status = cmType.value
	AND cmType.name = 'STATUS_NORMAL'
	AND func.classid = type.id
	AND func.id = sFunc.functionid
	AND func2.classid = type.id
	AND func2.id = sFunc2.functionid
	AND ((sFunc.signature = 'operator ++()' AND sFunc2.signature ='operator ++(int)')
		OR (sFunc.signature ='operator \-\-()' AND sFunc2.signature ='operator \-\-(int)'))
	AND sType.id = type.id
	AND fsType.id = sType.sourcefileid
)
UNION

/* identify classes with a copy constructors without operator = */

select
	t1.fullname as class_name,
	t1.pathname AS file_name,
	t1.startline as line_number
from 
	TTypesWithCopyConstructor t1 left outer join
	TClassesWithOperatorEquals t2 on (t1.id = t2.id)
group by
	t1.fullname,
	t1.pathname,
	t1.startline
having count(t2.id) = 0

union

/* identify classes without a copy constructors but with without operator = */

select
	t1.fullname as class_name,
	t1.pathname AS file_name,
	t1.startline as line_number
from 
	TClassesWithOperatorEquals t1 left outer join
	TTypesWithCopyConstructor t2 on (t1.id = t2.id)
group by
	t1.fullname,
	t1.pathname,
	t1.startline
having count(t2.id) = 0

;


drop Table TTypesWithCopyConstructor;
drop Table TClassesWithOperatorEquals;

;