/* $Id: Datenkapselaufbruch.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */

CREATE OR REPLACE VIEW VEncapsulationViolations AS

SELECT DISTINCT
	classOfMethod.id AS ContainingClassIdOfAccessingFunction, 
	classOfMethod.fullname AS ContainingClassNameOfAccessingFunction, 
	method.id as AccessingFunctionId, 
	method.name as AccessingFunctionName, 
        
        classOfField.packageid AS ContaingPackageIdOfField,
	classOfField.id AS ContainingClassIdOfField, 
	classOfField.fullName as ContainingClassNameOfField, 
	field.id AS AccessedFieldId, 
	field.name as AccessedFieldName
FROM   
	TTypes classOfField, 
	TMembers member_classField, 
	TVariables field, 
	TModelElements mField,
	TConstants cmField,
	TConstants constantField, 

	TTypes classOfMethod, 
	TMembers member_classMethod, 
	TFunctions method, 
	TConstants constantPublic, 

	TAccesses tAccesses
WHERE 
	mField.id = field.id
	AND mField.status = cmField.value
	AND cmField.name = 'STATUS_NORMAL'

	/* field */
	AND member_classField.ClassId = classOfField.Id AND 
	field.Id = member_classField.Id AND  
	field.KindOfVariable = constantField.Value AND 
	constantField.Name = 'VAR_FIELD' AND 

	member_classField.visibility = constantPublic.Value AND 
	constantPublic.Name = 'VISIBILITY_PUBLIC' AND 
	NOT (member_classField.isStatic = 1 AND 
       	     member_classField.isFinal = 1) AND

	/* method */
	member_classMethod.classId = classOfMethod.id AND
	method.id = member_classMethod.id AND

	/* method and field of different classes*/
	classOfField.id != classOfMethod.id AND

	/* method access field*/
	tAccesses.targetId = field.id AND
	method.id = tAccesses.functionId AND
	
	/* field class MUST NOT be an inner class */
	classOfField.classid = -1 AND

	/* method class MUST NOT be a sub class of field class*/
	NOT EXISTS (
		SELECT 
			i.classid
		FROM 
			TInheritances i
		WHERE 
			i.classID = classOfMethod.id AND 
			i.superID = classOfField.id

		UNION

		SELECT
			tcr.classid
		FROM
			TClassContainmentRelations tcr
		WHERE
				classOfMethod.id = tcr.classid
			AND	classOfField.id = tcr.containingclassid		
	)
;


/* Nachbearbeitung: Beteiligte Dateien ausgeben */
SELECT DISTINCT	
        p.fullname AS package_full_name,
	violations.ContainingClassNameOfField AS class_full_name,
	violations.AccessedFieldName AS variable_name,
        file_accessed.pathname AS file_name,
        sourceEntity_accessed.startline AS line_number        
FROM
	VEncapsulationViolations as violations join
	TSourceEntities sourceEntity_accessed on (violations.ContainingClassIdOfField = sourceEntity_accessed.id) join
	TFiles file_accessed on (sourceEntity_accessed.sourcefileid = file_accessed.id) join
        TPackages p on (violations.ContaingPackageIdOfField = p.id)

GROUP BY
        package_full_name,
	class_full_name,
	variable_name,
        file_name,
        line_number
;

drop view VEncapsulationViolations;
