create table TModelElements (Id Integer PRIMARY KEY, Name Varchar(256), Status Integer, KindOfElement Integer, Scope Integer, ParentId Integer);
create table TAnnotations (ModelElementId Integer REFERENCES TModelElements, AnnotationId Integer);
create table TSourceEntities (Id Integer PRIMARY KEY REFERENCES TModelElements, SourceFileId Integer, StartLine Integer, StartChar Integer, EndLine Integer, EndChar Integer, AssemblyFileId Integer);
create table TFiles (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfFile Integer, Pathname Varchar(1024), LinesOfCode Integer);
create table TPackages (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfPackage Integer, Name Varchar(256), FullName Varchar(1024), ParentPackageId Integer, AliasedPackageId Integer);
create table TMembers (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfMember Integer, Name Varchar(256), ClassId Integer, Visibility Integer, IsInternal Integer, IsAbstract Integer, IsFinal Integer, IsStatic Integer, IsVirtual Integer, IsExtern Integer, IsNew Integer, IsOverride Integer, IsTypeParamMember Integer, IsIntrospectable Integer, OverridenMemberId Integer);
create table TTypes (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfType Integer, Name Varchar(256), FullName Varchar(1024), PackageId Integer, ClassId Integer, DecoratedTypeId Integer, ArrayDimensions Integer, IsReferenceType Integer);
create table TFriends (TypeId Integer REFERENCES TTypes, KindOfFriend Integer, FriendId Integer);
create table TTypeParameters (TypeParameterId Integer PRIMARY KEY, Position Integer, KindOfGenericElement Integer, GenericElementId Integer);
create table TFunctions (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfFunction Integer, Name Varchar(256), ReturnTypeDeclarationId Integer, PackageId Integer, ClassId Integer, PropertyId Integer, IsOperator Integer, NumberOfStatements Integer, NumberOfLines Integer, NumberOfComments Integer, NumberOfExceptions Integer, MaxNestingLevel Integer, NumberOfNodes Integer, NumberOfEdges Integer);
create table TSignatures (FunctionId Integer PRIMARY KEY REFERENCES TFunctions, Signature Varchar(4096));
create table TVariables (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfVariable Integer, Name Varchar(256), PackageId Integer, ClassId Integer, FunctionId Integer, TypeDeclarationId Integer, Position Integer, IsConst Integer, IsPassedByRef Integer, IsRethrown Integer, ImplementedInterfaceId Integer);
create table TStatements (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfStatement Integer, FunctionId Integer, ParentStatementId Integer, Position Integer);
create table TAccesses (Id Integer PRIMARY KEY REFERENCES TModelElements, KindOfAccess Integer, Position Integer, PackageId Integer, ClassId Integer, FunctionId Integer, StatementId Integer, SourceId Integer, TargetId Integer);
create table TAccessedTargets (AccessId Integer REFERENCES TAccesses, KindOfTarget Integer, TargetId Integer);
create table TTypeArguments (AccessId Integer, TypeParameterId Integer, TargetTypeId Integer);
create table TImports (FileId Integer REFERENCES TFiles, KindOfTarget Integer, TargetId Integer, IsStaticImport Integer, IsMultiImport Integer);
create table TInheritances (ClassId Integer REFERENCES TTypes, SuperId Integer, DepthOfInheritance Integer);
create table TPackageContainmentRelations (PackageId Integer REFERENCES TPackages, ContainingPackageId Integer, DepthOfContainment Integer);
create table TClassContainmentRelations (ClassId Integer REFERENCES TTypes, ContainingClassId Integer, DepthOfContainment Integer);
create table TIncludes (FileId Integer REFERENCES TFiles, IncludedFileId Integer, DepthOfInclusion Integer);
create table TClones (Id Integer PRIMARY KEY REFERENCES TModelElements, NumberOfStatements Integer, NumberOfLines Integer);
create table TCloneInstances (Id Integer PRIMARY KEY REFERENCES TModelElements, CloneId Integer, FunctionId Integer);
create table TCloneInstanceStatements (StatementId Integer REFERENCES TStatements, CloneInstanceId Integer REFERENCES TCloneInstances);
create table TAbstractions (Id Integer PRIMARY KEY REFERENCES TModelElements, Name Varchar(256), KindOfAbstraction Integer, Type Varchar(256));
create table TAbstractionElements (AbstractionId Integer REFERENCES TAbstractions, ModelElementId Integer);
create table TComments (Id Integer PRIMARY KEY REFERENCES TModelElements, IsFormal Integer, NumberOfTodos Integer, NumberOfLines Integer, CommentText Text);
create table TConstants (Name Varchar(256) PRIMARY KEY, Value Integer UNIQUE NOT NULL);

create table TErrors(AnalysisTimeStamp Char(16), KindOfError Integer, Filename Varchar(256), Linenumber Integer, Message Varchar(1024));
create table TProblems (Id Integer PRIMARY KEY, AnalysisTimeStamp Char(16), KindOfProblem Varchar(256), Filename Varchar(256), Linenumber Integer);
create table TProblemProperties(Id Integer PRIMARY KEY, ProblemId Integer REFERENCES TProblems (Id), Name Varchar(256), Value Varchar(1024));

create index TModelElementsIndex on TModelElements (Id, ParentId, KindOfElement, Status, Name);
create index TAnnotationsIndex on TAnnotations (ModelElementId, AnnotationId);
create index TSourceEntitiesIndex on TSourceEntities (Id, SourceFileId, AssemblyFileId);
create index TFilesIndex on TFiles (Id, KindOfFile, Pathname);
create index TPackagesIndex on TPackages (Id, ParentPackageId, AliasedPackageId, Name, FullName);
create index TMembersIndex on TMembers (Id, ClassId, Visibility, OverridenMemberId, KindOfMember, Name);
create index TTypesIndex on TTypes (Id, PackageId, ClassId, DecoratedTypeId, Name, FullName);
create index TFriendsIndex on TFriends (TypeId, FriendId);
create index TTypeParametersIndex on TTypeParameters (TypeParameterId, GenericElementId);
create index TFunctionsIndex on TFunctions (Id, PackageId, ClassId, KindOfFunction, PropertyId, ReturnTypeDeclarationId, Name);
create index TSignaturesIndex on TSignatures (FunctionId, Signature);
create index TVariablesIndex on TVariables (Id, PackageId, ClassId, FunctionId, TypeDeclarationId, ImplementedInterfaceId, Name);
create index TStatementsIndex on TStatements (Id, FunctionId, ParentStatementId);
create index TAccessesIndex on TAccesses (Id, PackageId, ClassId, FunctionId, StatementId, SourceId, TargetId);
create index TAccessedTargetsIndex on TAccessedTargets (AccessId, TargetId);
create index TTypeArgumentsIndex on TTypeArguments (AccessId, TypeParameterId, TargetTypeId);
create index TImportsIndex on TImports (FileId, TargetId);
create index TInheritancesIndex on TInheritances (ClassId, SuperId);
create index TPackageContainmentRelationsIndex on TPackageContainmentRelations (PackageId, ContainingPackageId);
create index TClassContainmentRelationsIndex on TClassContainmentRelations (ClassId, ContainingClassId);
create index TIncludesIndex on TIncludes (FileId, IncludedFileId);
create index TClonesIndex on TClones (Id);
create index TCloneInstancesIndex on TCloneInstances (Id, CloneId, FunctionId);
create index TCloneInstanceStatementsIndex on TCloneInstanceStatements (StatementId, CloneInstanceId);
create index TAbstractionsIndex on TAbstractions (Id);
create index TAbstractionElementsIndex on TAbstractionElements (AbstractionId, ModelElementId);
create index TCommentsIndex on TComments (Id);
create index TConstantsIndex on TConstants (value, name);

insert into TConstants values ('ROOT', 1);
insert into TConstants values ('FILE_SOURCE', 2);
insert into TConstants values ('FILE_ASSEMBLY', 3);
insert into TConstants values ('COMMENT', 4);
insert into TConstants values ('PACK_PACKAGE', 17);
insert into TConstants values ('PACK_SUBPACKAGE', 18);
insert into TConstants values ('PACK_PACKAGEALIAS', 19);
insert into TConstants values ('TYPE_PRIMITIVE', 33);
insert into TConstants values ('TYPE_INTERFACE', 34);
insert into TConstants values ('TYPE_CLASS', 35);
insert into TConstants values ('TYPE_GENERICINTERFACE', 36);
insert into TConstants values ('TYPE_GENERICCLASS', 37);
insert into TConstants values ('TYPE_TYPEPARAMCLASS', 38);
insert into TConstants values ('TYPE_ARRAY', 39);
insert into TConstants values ('TYPE_TYPEALIAS', 40);
insert into TConstants values ('TYPE_IMPLICITREFERENCE', 41);
insert into TConstants values ('TYPE_EXPLICITREFERENCE', 42);
insert into TConstants values ('FUNC_TYPE_DELEGATE', 49);
insert into TConstants values ('FUNC_GLOBALFUNC', 50);
insert into TConstants values ('FUNC_GENERICFUNC', 51);
insert into TConstants values ('FUNC_METHOD', 52);
insert into TConstants values ('FUNC_CONSTRUCTOR', 53);
insert into TConstants values ('FUNC_DESTRUCTOR', 54);
insert into TConstants values ('FUNC_INITIALIZER', 55);
insert into TConstants values ('FUNC_PROPGETTER', 56);
insert into TConstants values ('FUNC_PROPSETTER', 57);
insert into TConstants values ('FUNC_UNITINITIALIZER', 58);
insert into TConstants values ('FUNC_UNITFINALIZER', 59);
insert into TConstants values ('FUNC_GENERICMETHOD', 60);
insert into TConstants values ('FUNC_GENERICCONSTRUCTOR', 61);
insert into TConstants values ('VAR_FIELD', 65);
insert into TConstants values ('VAR_LOCALVAR', 66);
insert into TConstants values ('VAR_GLOBALVAR', 67);
insert into TConstants values ('VAR_FORMALPARAM', 68);
insert into TConstants values ('VAR_CATCHPARAM', 69);
insert into TConstants values ('VAR_PROPERTY', 70);
insert into TConstants values ('STATEMENT_SIMPLE', 71);
insert into TConstants values ('STATEMENT_THROW', 72);
insert into TConstants values ('STATEMENT_RETURN', 73);
insert into TConstants values ('STATEMENT_JUMP', 74);
insert into TConstants values ('STATEMENT_LOOP', 75);
insert into TConstants values ('STATEMENT_BRANCH',76);
insert into TConstants values ('STATEMENT_BLOCK', 77);
insert into TConstants values ('STATEMENT_EXCEPTIONHANDLER', 78);
insert into TConstants values ('STATEMENT_CATCHBLOCK', 79);
insert into TConstants values ('VARACCESS_READ', 81);
insert into TConstants values ('VARACCESS_WRITE', 82);
insert into TConstants values ('PROPACCESS_READ', 83);
insert into TConstants values ('PROPACCESS_WRITE', 84);
insert into TConstants values ('SELFACCESS_THIS', 94);
insert into TConstants values ('SELFACCESS_SUPER', 95);
insert into TConstants values ('COMPOSITEACCESS', 96);
insert into TConstants values ('FUNCACCESS', 97);
insert into TConstants values ('DELEGATEACCESS', 98);
insert into TConstants values ('TYPEACCESS_PARAMETERINSTANCIATION', 112);
insert into TConstants values ('TYPEACCESS_INTERFACEINHERITANCE', 113);
insert into TConstants values ('TYPEACCESS_IMPLEMENTATIONINHERITANCE', 114);
insert into TConstants values ('TYPEACCESS_DECLAREDTHROW', 115);
insert into TConstants values ('TYPEACCESS_THROW', 116);
insert into TConstants values ('TYPEACCESS_DECLARATION', 117);
insert into TConstants values ('TYPEACCESS_CAST', 118);
insert into TConstants values ('TYPEACCESS_RTTI', 119);
insert into TConstants values ('TYPEACCESS_STATIC', 120);
insert into TConstants values ('CLONE_CLONE', 121);
insert into TConstants values ('CLONE_INSTANCE', 122);
insert into TConstants values ('ABSTRACTION_STRUCTURALABSTRACTION', 123);	
insert into TConstants values ('ABSTRACTION_SUBSYSTEM', 124);	
insert into TConstants values ('SCOPE_GLOBAL', 129);
insert into TConstants values ('SCOPE_PACKAGE', 130);
insert into TConstants values ('SCOPE_CLASS', 131);
insert into TConstants values ('SCOPE_LOCAL', 132);
insert into TConstants values ('SCOPE_PROPERTY', 133);
insert into TConstants values ('SCOPE_DECLARATION', 134);
insert into TConstants values ('SCOPE_STATEMENT', 135);
insert into TConstants values ('SCOPE_ACCESS', 136);
insert into TConstants values ('SCOPE_FILE', 137);
insert into TConstants values ('VISIBILITY_PUBLIC', 145);
insert into TConstants values ('VISIBILITY_PROTECTED', 146);
insert into TConstants values ('VISIBILITY_STRICTPROTECTED', 147);
insert into TConstants values ('VISIBILITY_PACKAGE', 148);
insert into TConstants values ('VISIBILITY_PRIVATE', 149);
insert into TConstants values ('STATUS_NORMAL', 161);
insert into TConstants values ('STATUS_LIBRARY', 162);
insert into TConstants values ('STATUS_IMPLICIT', 163);
insert into TConstants values ('STATUS_FAILEDDEP', 164);
