/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.commentanalyzer;

import de.fzi.sissy.commentanalyzer.ConsoleConfig;
import de.fzi.sissy.commentanalyzer.IConfig;
import de.fzi.sissy.commentanalyzer.SourceEntityFilenameComparator;
import de.fzi.sissy.commentanalyzer.SourceEntityStartLineComparator;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Comment;
import de.fzi.sissy.metamod.ModelAnnotation;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.utils.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    static final int NORMAL = 0;
    static final int INFORMAL_COMMENT = 1;
    static final int FORMAL_COMMENT = 2;
    private int state = 0;
    private IConfig config;
    private Pattern[] patterns;
    private String lineStart;
    private String normalStart;
    private String normalEnd;
    private String formalStart;
    private String formalEnd;
    private int loc;
    private HashMap fileMap = new HashMap();
    private HashMap locMap = new HashMap();
    private static int numFiles = 0;

    public Main(IConfig conf) {
        this.config = conf;
        this.patterns = new Pattern[this.config.getTodoPatterns().length];
        int i = 0;
        while (i < this.config.getTodoPatterns().length) {
            this.patterns[i] = Pattern.compile(".*" + this.config.getTodoPatterns()[i] + ".*");
            ++i;
        }
        this.lineStart = this.config.getLineCommentStart();
        this.normalStart = this.config.getNormalBlockCommentStart();
        this.normalEnd = this.config.getNormalBlockCommentEnd();
        this.formalStart = this.config.getFormalBlockCommentStart();
        this.formalEnd = this.config.getFormalBlockCommentEnd();
    }

    public HashMap getFileMap() {
        return this.fileMap;
    }

    private int indexOfNormalStart(String line, int startpos) {
        String[] starts = this.config.getNormalBlockCommentStarts();
        int[] indices = new int[starts.length];
        int i = 0;
        while (i < starts.length) {
            indices[i] = line.indexOf(starts[i], startpos);
            ++i;
        }
        Arrays.sort(indices);
        return indices[indices.length - 1];
    }

    private int indexOfNormalEnd(String line, int startpos) {
        String[] ends = this.config.getNormalBlockCommentEnds();
        int[] indices = new int[ends.length];
        int i = 0;
        while (i < ends.length) {
            indices[i] = line.indexOf(ends[i], startpos);
            ++i;
        }
        Arrays.sort(indices);
        return indices[indices.length - 1];
    }

    public void analyze(File file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ArrayList<Comment> comments = new ArrayList<Comment>();
            ArrayList<String> commentLines = new ArrayList<String>();
            int linepos = 0;
            int colpos = -1;
            int endpos = -1;
            int startpos = -1;
            Comment c = null;
            Position pos = null;
            this.state = 0;
            ++numFiles;
            while ((line = reader.readLine()) != null) {
                startpos = 0;
                colpos = 0;
                ++linepos;
                while (startpos < line.length()) {
                    if (this.state == 0) {
                        colpos = this.indexOfNormalStart(line, startpos);
                        if (colpos > -1) {
                            this.state = 1;
                        }
                        int tmppos = line.indexOf(this.formalStart, startpos);
                        if (colpos == -1 || tmppos <= colpos && tmppos > -1) {
                            colpos = tmppos;
                            this.state = colpos > -1 ? 2 : 0;
                            tmppos = line.indexOf(this.lineStart, startpos);
                            if ((colpos == -1 || tmppos < colpos && tmppos > -1) && (colpos = tmppos) > -1) {
                                this.state = 0;
                                pos = new Position(null, linepos, colpos, linepos, line.length());
                                c = new Comment(false, line.substring(colpos), this.countTodos(line.substring(colpos)));
                                c.setPosition(pos);
                                comments.add(c);
                            }
                        }
                        if (this.state != 0) {
                            pos = new Position(null, linepos, colpos, 0, 0);
                        } else {
                            startpos = line.length();
                        }
                    }
                    if (this.state == 0) continue;
                    endpos = -1;
                    int diff = 0;
                    if (this.state == 2) {
                        if (linepos == pos.getStartLine()) {
                            diff = 3;
                        }
                        endpos = line.indexOf(this.formalEnd, colpos + diff);
                    }
                    if (endpos > -1) {
                        pos.setEndLine(linepos);
                        pos.setEndColumn(endpos + this.formalEnd.length() - 1);
                        commentLines.add(line.substring(colpos, endpos + this.formalEnd.length()));
                        c = new Comment(true, commentLines, this.countTodos(commentLines));
                        c.setPosition(pos);
                        comments.add(c);
                        this.state = 0;
                        startpos = endpos + this.formalEnd.length();
                        commentLines = new ArrayList();
                        continue;
                    }
                    if (linepos == pos.getStartLine()) {
                        diff = 2;
                    }
                    if ((endpos = this.indexOfNormalEnd(line, colpos + diff)) > -1) {
                        pos.setEndLine(linepos);
                        pos.setEndColumn(endpos + this.normalEnd.length());
                        commentLines.add(line.substring(colpos, endpos + this.normalEnd.length()));
                        c = new Comment(false, commentLines, this.countTodos(commentLines));
                        c.setPosition(pos);
                        comments.add(c);
                        this.state = 0;
                        startpos = endpos + this.normalEnd.length();
                        commentLines = new ArrayList();
                        continue;
                    }
                    commentLines.add(line.substring(colpos));
                    startpos = line.length();
                }
            }
            this.fileMap.put(file.getCanonicalPath().toUpperCase(), comments);
            this.locMap.put(file.getCanonicalPath().toUpperCase(), new Integer(linepos));
        }
        catch (FileNotFoundException e) {
            Debug.error((String)("File '" + file.getAbsolutePath() + "' not found."));
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private boolean accept(File f) {
        Matcher m = this.config.getFileFilter().matcher(f.getAbsolutePath());
        return m.matches();
    }

    private void readRecursive(File f) {
        if (!f.isDirectory()) {
            if (this.accept(f)) {
                this.analyze(f);
            } else {
                Debug.verbose((String)("File not accepted: " + f));
            }
        } else {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                this.readRecursive(files[i]);
                ++i;
            }
        }
    }

    private int countTodos(ArrayList lines) {
        int count = 0;
        for (String tmp : lines) {
            count += this.countTodos(tmp);
        }
        return count;
    }

    private boolean containsTodoTag(String line) {
        boolean flag = false;
        return flag;
    }

    private int countTodos(String line) {
        int count = 0;
        Matcher m = null;
        int i = 0;
        while (i < this.patterns.length) {
            m = this.patterns[i].matcher(line);
            while (m.find()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void extractComments(File file) {
        this.readRecursive(file);
        for (String fileName : this.fileMap.keySet()) {
            Debug.verbose((String)("Comments for file " + fileName + ":"));
            Collection comments = (Collection)this.fileMap.get(fileName);
            for (Comment c : comments) {
                Debug.verbose((String)c.toString());
            }
        }
    }

    private static void addCommentsToSourceEntity(Collection comments, SourceEntity entity) {
        for (Comment c : comments) {
            if (!entity.getPosition().contains(c.getPosition()) && !c.isDirectlyInFrontOf(entity.getPosition())) continue;
            Debug.verbose((String)("Adding comment to entity '" + entity + "':"));
            Debug.verbose((String)c.toString());
            entity.addAnnotation((ModelAnnotation)c);
        }
    }

    private static void addCommentsToSourceEntities(Collection comments, ModelElementList modelElements) {
        for (ModelElement element : modelElements) {
            if (!(element instanceof SourceEntity)) continue;
            SourceEntity entity = (SourceEntity)element;
            Main.addCommentsToSourceEntity(comments, entity);
        }
    }

    public void addCommentsToModel(Root root) {
        Comment c;
        Iterator cs;
        Collection comments;
        String pathName;
        ArrayList modelElements = new ArrayList();
        ModelElementList allClasses = new ModelElementList();
        allClasses.addAll((Collection)root.getClasses());
        this.addInnerClasses(allClasses, allClasses);
        for (Class c2 : allClasses) {
            modelElements.addAll(c2.getFields());
            modelElements.addAll(c2.getMethods());
            modelElements.addAll(c2.getProperties());
        }
        modelElements.addAll(root.getFunctions());
        modelElements.addAll(root.getGlobalFunctions());
        modelElements.addAll(root.getGlobalVariables());
        ModelElementList otherTypes = new ModelElementList();
        ModelElementList rootTypes = root.getTypes();
        for (Type t : rootTypes) {
            if (t instanceof Class || !(t instanceof SourceEntity)) continue;
            otherTypes.add((Object)t);
        }
        HashSet<ModelElement> ents = new HashSet<ModelElement>();
        for (ModelElement e : modelElements) {
            if (!(e instanceof SourceEntity)) continue;
            ents.add(e);
        }
        Object[] entsArray = ents.toArray();
        Arrays.sort(entsArray, new SourceEntityFilenameComparator());
        Arrays.sort(entsArray, new SourceEntityStartLineComparator());
        int i = 0;
        while (i < entsArray.length) {
            SourceEntity entity = (SourceEntity)entsArray[i];
            Debug.verbose((String)("Entity: " + entity.toString()));
            if (entity instanceof NamedModelElement) {
                Debug.verbose((String)("Name: " + ((NamedModelElement)entity).getSimpleName()));
            }
            try {
                de.fzi.sissy.metamod.File srcFile = entity.getPosition().getSourceFile();
                pathName = srcFile.getPathName();
                if (pathName.startsWith("FILE:")) {
                    pathName = pathName.substring(5);
                }
                pathName = pathName.toUpperCase();
                Debug.verbose((String)pathName);
                comments = (Collection)this.fileMap.get(pathName);
                Debug.verbose((String)(String.valueOf(comments.size()) + " comments for file " + pathName));
                if (comments.size() > 0) {
                    cs = comments.iterator();
                    while (cs.hasNext()) {
                        c = (Comment)cs.next();
                        Position cpos = c.getPosition();
                        cpos.setSourceFile(srcFile);
                        if ((c.getPosition().getStartLine() > entity.getPosition().getEndLine() || c.getPosition().getEndLine() < entity.getPosition().getStartLine() - 2) && (c.getPosition().getStartLine() < entity.getPosition().getStartLine() || c.getPosition().getEndLine() > entity.getPosition().getEndLine())) continue;
                        Debug.verbose((String)("Adding comment to entity '" + entity + "':"));
                        Debug.verbose((String)c.toString());
                        entity.addAnnotation((ModelAnnotation)c);
                        cs.remove();
                    }
                }
                Debug.verbose((String)(String.valueOf(((Collection)this.fileMap.get(pathName)).size()) + " comments for file " + pathName + " left."));
            }
            catch (NullPointerException nullPointerException) {}
            ++i;
        }
        Object[] classesArray = allClasses.toArray();
        Arrays.sort(classesArray, new SourceEntityFilenameComparator());
        Arrays.sort(classesArray, new SourceEntityStartLineComparator());
        int i2 = 0;
        while (i2 < classesArray.length) {
            Class entity = (Class)classesArray[i2];
            Debug.verbose((String)("Class: " + entity.getSimpleName()));
            try {
                pathName = entity.getPosition().getSourceFile().getPathName();
                if (pathName.startsWith("FILE:")) {
                    pathName = pathName.substring(5);
                }
                pathName = pathName.toUpperCase();
                Debug.verbose((String)pathName);
                comments = (Collection)this.fileMap.get(pathName);
                Debug.verbose((String)(String.valueOf(comments.size()) + " comments for file " + pathName));
                if (comments.size() > 0) {
                    cs = comments.iterator();
                    while (cs.hasNext()) {
                        c = (Comment)cs.next();
                        if ((c.getPosition().getStartLine() > entity.getPosition().getEndLine() || c.getPosition().getEndLine() < entity.getPosition().getStartLine() - 2) && (c.getPosition().getStartLine() < entity.getPosition().getStartLine() || c.getPosition().getEndLine() > entity.getPosition().getEndLine())) continue;
                        Debug.verbose((String)("Adding comment to entity '" + entity + "':"));
                        Debug.verbose((String)c.toString());
                        entity.addAnnotation((ModelAnnotation)c);
                        cs.remove();
                    }
                }
                Debug.verbose((String)(String.valueOf(((Collection)this.fileMap.get(pathName)).size()) + " comments for file " + pathName + " left."));
            }
            catch (NullPointerException nullPointerException) {}
            ++i2;
        }
    }

    private void addInnerClasses(ModelElementList allClasses, ModelElementList classes) {
        int i = 0;
        while (i < classes.size()) {
            Class c = (Class)classes.get(i);
            if (c.getInnerClasses().size() > 0) {
                allClasses.addAll((Collection)c.getInnerClasses());
                this.addInnerClasses(allClasses, c.getInnerClasses());
            }
            ++i;
        }
    }

    private void addLOCToFiles(Root root) {
        for (de.fzi.sissy.metamod.File f : root.getFiles()) {
            Integer loc;
            String name = f.getPathName();
            if (!f.isSourceFile()) continue;
            if (name.startsWith("FILE:")) {
                name = name.substring(5);
            }
            if ((loc = (Integer)this.locMap.get(name = name.toUpperCase())) == null) continue;
            f.setLinesOfCode(loc.intValue());
        }
    }

    public static void main(String[] args) {
        Debug.pushDebugLevel();
        Debug.setDebugLevel((int)7);
        IConfig conf = ConsoleConfig.readInstanceConsole(args);
        Root root = ModelElementRepository.getWorkingRepository().getRoot();
        Main main = new Main(conf);
        List fileList = ModelElementRepository.getWorkingRepository().getFileList();
        int i = 0;
        while (i < fileList.size()) {
            main.extractComments(new File((String)fileList.get(i)));
            ++i;
        }
        Debug.verbose((String)("#Files analyzed: " + numFiles));
        Debug.info((String)("Comments Extracted (Number of Files: " + numFiles + ")"));
        main.addCommentsToModel(root);
        main.addLOCToFiles(root);
        Debug.popDebugLevel();
    }

    private static String[] calculatePathArray(String pathList) {
        StringTokenizer pathTokenizer = new StringTokenizer(pathList, File.pathSeparator, false);
        String[] pathArray = new String[pathTokenizer.countTokens()];
        int i = 0;
        while (pathTokenizer.hasMoreTokens()) {
            String token;
            pathArray[i] = token = pathTokenizer.nextToken();
            ++i;
        }
        return pathArray;
    }
}

