/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.commentanalyzer;

import de.fzi.sissy.commentanalyzer.Activator;
import de.fzi.sissy.commentanalyzer.GenericConfig;
import de.fzi.sissy.commentanalyzer.IConfig;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.FileLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.osgi.framework.Bundle;

public class ConsoleConfig
extends GenericConfig {
    public static IConfig readInstanceConsole(String[] cmds) {
        GenericConfig configInstance = new GenericConfig();
        String value = null;
        int i = 1;
        while (i < cmds.length) {
            Bundle bundle;
            File propFile;
            String[] list;
            if (cmds[i].equals("-l")) {
                value = cmds[++i];
                configInstance.setLineCommentStart(value);
            } else if (cmds[i].equals("-ns")) {
                if ((value = cmds[++i]).indexOf(44) != -1) {
                    list = value.split(",");
                    configInstance.setNormalBlockCommentStarts(list);
                    configInstance.setNormalBlockCommentStart(list[0]);
                } else {
                    list = new String[]{value};
                    configInstance.setNormalBlockCommentStart(value);
                    configInstance.setNormalBlockCommentStarts(list);
                }
            } else if (cmds[i].equals("-ne")) {
                if ((value = cmds[++i]).indexOf(44) != -1) {
                    list = value.split(",");
                    configInstance.setNormalBlockCommentEnds(list);
                    configInstance.setNormalBlockCommentEnd(list[0]);
                } else {
                    list = new String[]{value};
                    configInstance.setNormalBlockCommentEnd(value);
                    configInstance.setNormalBlockCommentEnds(list);
                }
            } else if (cmds[i].equals("-fs")) {
                value = cmds[++i];
                configInstance.setFormalBlockCommentStart(value);
            } else if (cmds[i].equals("-fe")) {
                value = cmds[++i];
                configInstance.setFormalBlockCommentEnd(value);
            } else if (cmds[i].equals("-f")) {
                value = cmds[++i];
                configInstance.setFileFilter(value);
            } else if (cmds[i].equals("-c")) {
                value = cmds[++i];
                ConsoleConfig.readCommentSpec(configInstance, value);
            } else if (cmds[i].equals("-todos")) {
                value = cmds[++i];
                ConsoleConfig.readTodoPatterns(configInstance, value);
            } else if (cmds[i].equals("-all") && FileLoader.exists((File)(propFile = new File(value = cmds[++i])), (Bundle)(bundle = Activator.getDefault().getBundle()))) {
                Properties props = new Properties();
                try {
                    props.load(FileLoader.openAsInputStream((File)propFile, (Bundle)bundle));
                    Debug.info((String)"General config property file successfully loaded.");
                    Enumeration<?> names = props.propertyNames();
                    while (names.hasMoreElements()) {
                        String key = (String)names.nextElement();
                        String val = props.getProperty(key);
                        Debug.info((String)(String.valueOf(key) + " = " + val));
                        if (key.equals("TODO_SPEC")) {
                            ConsoleConfig.readTodoPatterns(configInstance, val);
                            continue;
                        }
                        if (key.equals("COMMENT_SPEC")) {
                            ConsoleConfig.readCommentSpec(configInstance, val);
                            continue;
                        }
                        if (!key.equals("FILE_FILTER")) continue;
                        configInstance.setFileFilter(val);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            ++i;
        }
        Debug.info((String)configInstance.toString());
        return configInstance;
    }

    private static void readCommentSpec(GenericConfig configInstance, String value) {
        File propFile = new File(value);
        Bundle bundle = Activator.getDefault().getBundle();
        if (FileLoader.exists((File)propFile, (Bundle)bundle)) {
            Properties props = new Properties();
            try {
                props.load(FileLoader.openAsInputStream((File)propFile, (Bundle)bundle));
                Debug.info((String)"Comment property file successfully loaded.");
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String[] list;
                    String key = (String)names.nextElement();
                    String val = props.getProperty(key);
                    Debug.info((String)(String.valueOf(key) + " = " + val));
                    if (key.equals("LINE_COMMENT_START")) {
                        configInstance.setLineCommentStart(val);
                        continue;
                    }
                    if (key.equals("NORMAL_BLOCK_COMMENT_START")) {
                        if (val.indexOf(44) != -1) {
                            list = val.split(",");
                            configInstance.setNormalBlockCommentStart(list[0]);
                            configInstance.setNormalBlockCommentStarts(list);
                            continue;
                        }
                        configInstance.setNormalBlockCommentStart(val);
                        list = new String[]{val};
                        configInstance.setNormalBlockCommentStarts(list);
                        continue;
                    }
                    if (key.equals("NORMAL_BLOCK_COMMENT_END")) {
                        if (val.indexOf(44) != -1) {
                            list = val.split(",");
                            configInstance.setNormalBlockCommentEnd(list[0]);
                            configInstance.setNormalBlockCommentEnds(list);
                            continue;
                        }
                        configInstance.setNormalBlockCommentEnd(val);
                        list = new String[]{val};
                        configInstance.setNormalBlockCommentEnds(list);
                        continue;
                    }
                    if (key.equals("FORMAL_BLOCK_COMMENT_START")) {
                        configInstance.setFormalBlockCommentStart(val);
                        continue;
                    }
                    if (!key.equals("FORMAL_BLOCK_COMMENT_END")) continue;
                    configInstance.setFormalBlockCommentEnd(val);
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static void readTodoPatterns(GenericConfig configInstance, String value) {
        ArrayList<String> regexps = new ArrayList<String>();
        try {
            Bundle bundle = Activator.getDefault().getBundle();
            BufferedReader reader = new BufferedReader(FileLoader.openAsInputStreamReader((String)value, (Bundle)bundle));
            String regexp = null;
            while ((regexp = reader.readLine()) != null) {
                regexps.add(regexp);
            }
        }
        catch (FileNotFoundException e) {
            Debug.error((String)("File '" + value + "' not found."));
            e.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        configInstance.setTodoPatterns(regexps.toArray(new String[0]));
    }
}

