/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.PortEnabledEntity;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.InterfaceSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.IInterfacePortBuilderStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.InterfacesBoundInConnectorFilter;
import org.somox.configuration.SoMoXConfiguration;

public class NonDuplicatingInterfacePortBuilder
extends AbstractBuilder
implements IInterfacePortBuilderStrategy {
    static final Logger logger = Logger.getLogger(NonDuplicatingInterfacePortBuilder.class);
    private boolean isProvidedBuilder;

    public NonDuplicatingInterfacePortBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult, boolean isProvidedBuilder) {
        super(gastModel, somoxConfiguration, analysisResult);
        this.isProvidedBuilder = isProvidedBuilder;
    }

    @Override
    public void buildInterfacePort(ComponentImplementingClassesLink componentLink) {
        if (componentLink.getComponent() instanceof CompositeComponent) {
            CompositeComponent resultCompositeComponent = (CompositeComponent)componentLink.getComponent();
            Collection<SubComponentInformation> allSubComponentInterfaceLinks = this.collectInterfaceLinksOfSubComponents(componentLink, this.isProvidedBuilder);
            Collection<EndPoint> connectorEndpoints = this.collectConnectorEndpoints(resultCompositeComponent);
            InterfacesBoundInConnectorFilter filter = new InterfacesBoundInConnectorFilter(connectorEndpoints);
            Iterable interfaceLinksNotUsedInConnectors = filter.filter(allSubComponentInterfaceLinks);
            for (SubComponentInformation currentInterfaceLink : interfaceLinksNotUsedInConnectors) {
                if (this.isProvidedBuilder) {
                    this.createProvidedInterfacePortAndConnector(componentLink, currentInterfaceLink);
                    continue;
                }
                this.createRequiredInterfacePortAndConnector(componentLink, currentInterfaceLink);
            }
        } else {
            logger.warn((Object)"Only composite components should use this builder.");
        }
    }

    private Collection<EndPoint> collectConnectorEndpoints(CompositeComponent resultCompositeComponent) {
        ArrayList<EndPoint> connectorEndpoints = new ArrayList<EndPoint>();
        for (Connector currentConnector : resultCompositeComponent.getConnector()) {
            if (currentConnector.getEndpoints().size() > 2) {
                throw new RuntimeException("n to m connectors (n/m > 2) not supported!");
            }
            for (EndPoint currentEndPoint : currentConnector.getEndpoints()) {
                connectorEndpoints.add(currentEndPoint);
            }
        }
        return connectorEndpoints;
    }

    private Collection<SubComponentInformation> collectInterfaceLinksOfSubComponents(ComponentImplementingClassesLink componentLink, boolean collectProvided) {
        ArrayList<SubComponentInformation> allInterfaceLinks = new ArrayList<SubComponentInformation>();
        for (ComponentImplementingClassesLink currentSubComponentLink : componentLink.getSubComponents()) {
            EList interfaceLinkSubList = collectProvided ? currentSubComponentLink.getProvidedInterfaces() : currentSubComponentLink.getRequiredInterfaces();
            for (InterfaceSourceCodeLink currentInterfaceLinkSub : interfaceLinkSubList) {
                SubcomponentInstance matchingSubComponentInstance = this.getSubComponentInstance((CompositeComponent)componentLink.getComponent(), currentSubComponentLink);
                InterfacePort interfacePort = this.getInterfacePort(currentSubComponentLink, currentInterfaceLinkSub, collectProvided);
                allInterfaceLinks.add(new SubComponentInformation(currentInterfaceLinkSub, interfacePort, matchingSubComponentInstance));
            }
        }
        return allInterfaceLinks;
    }

    private InterfacePort getInterfacePort(ComponentImplementingClassesLink subComponentLink, InterfaceSourceCodeLink interfaceLinkSub, boolean searchProvidedPort) {
        EList interfacePorts = searchProvidedPort ? subComponentLink.getComponent().getProvided() : subComponentLink.getComponent().getRequired();
        for (InterfacePort currentInterfacePort : interfacePorts) {
            if (!interfaceLinkSub.getInterface().equals(currentInterfacePort.getInterfaceType())) continue;
            return currentInterfacePort;
        }
        logger.warn((Object)"should find an interface port");
        return null;
    }

    private SubcomponentInstance getSubComponentInstance(CompositeComponent outerCompositeComponent, ComponentImplementingClassesLink subComponentLink) {
        for (SubcomponentInstance currentComponentInstance : outerCompositeComponent.getSubcomponents()) {
            if (!currentComponentInstance.getRealizedBy().equals(subComponentLink.getComponent())) continue;
            return currentComponentInstance;
        }
        logger.warn((Object)"no subcomponent instance found");
        return null;
    }

    private void createProvidedInterfacePortAndConnector(ComponentImplementingClassesLink compositeComponentLink, SubComponentInformation subComponentInformation) {
        if (!(compositeComponentLink.getComponent() instanceof CompositeComponent)) {
            throw new RuntimeException("must be a composite component");
        }
        Set<Interface> allRequiredInterfaces = this.collectInterfacesForComponent(compositeComponentLink, true);
        if (!allRequiredInterfaces.contains(subComponentInformation.getInterfaceSourceCodeLink().getInterface())) {
            InterfacePort newProvidedPort = StaticstructureFactory.eINSTANCE.createInterfacePort();
            newProvidedPort.setInterfaceType(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
            newProvidedPort.setName(subComponentInformation.getInterfaceSourceCodeLink().getInterface().getName());
            newProvidedPort.setProvidingComponentType((PortEnabledEntity)compositeComponentLink.getComponent());
            compositeComponentLink.getComponent().getProvided().add((Object)newProvidedPort);
            this.createDelegationConnector(compositeComponentLink, newProvidedPort, subComponentInformation, true);
            if (subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null && subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null) {
                InterfaceSourceCodeLink newInterfaceLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
                newInterfaceLink.setInterface(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
                newInterfaceLink.setGastClass(subComponentInformation.getInterfaceSourceCodeLink().getGastClass());
                compositeComponentLink.getProvidedInterfaces().add((Object)newInterfaceLink);
                SourceCodeDecoratorRepository parentRepository = (SourceCodeDecoratorRepository)compositeComponentLink.eContainer();
                parentRepository.getInterfaceSourceCodeLink().add((Object)newInterfaceLink);
            } else {
                logger.warn((Object)"Source code decorator: InterfaceLink had no interface or class set.");
            }
        }
    }

    private void createRequiredInterfacePortAndConnector(ComponentImplementingClassesLink compositeComponentLink, SubComponentInformation subComponentInformation) {
        InterfacePort requiredPort = null;
        Set<Interface> allRequiredInterfaces = this.collectInterfacesForComponent(compositeComponentLink, false);
        if (!allRequiredInterfaces.contains(subComponentInformation.getInterfaceSourceCodeLink().getInterface())) {
            requiredPort = StaticstructureFactory.eINSTANCE.createInterfacePort();
            requiredPort.setInterfaceType(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
            requiredPort.setName(subComponentInformation.getInterfaceSourceCodeLink().getInterface().getName());
            requiredPort.setRequiringComponentType((PortEnabledEntity)compositeComponentLink.getComponent());
            compositeComponentLink.getComponent().getRequired().add((Object)requiredPort);
            if (subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null && subComponentInformation.getInterfaceSourceCodeLink().getInterface() != null) {
                InterfaceSourceCodeLink newInterfaceLink = SourceCodeDecoratorFactory.eINSTANCE.createInterfaceSourceCodeLink();
                newInterfaceLink.setInterface(subComponentInformation.getInterfaceSourceCodeLink().getInterface());
                newInterfaceLink.setGastClass(subComponentInformation.getInterfaceSourceCodeLink().getGastClass());
                compositeComponentLink.getRequiredInterfaces().add((Object)newInterfaceLink);
                SourceCodeDecoratorRepository parentRepository = (SourceCodeDecoratorRepository)compositeComponentLink.eContainer();
                parentRepository.getInterfaceSourceCodeLink().add((Object)newInterfaceLink);
            } else {
                logger.warn((Object)"Source code decorator: InterfaceLink had no interface or class set.");
            }
        } else {
            for (InterfacePort currentRequiredInterfacePort : compositeComponentLink.getComponent().getRequired()) {
                if (!currentRequiredInterfacePort.getInterfaceType().equals(subComponentInformation.getInterfaceSourceCodeLink().getInterface())) continue;
                requiredPort = currentRequiredInterfacePort;
            }
        }
        if (requiredPort != null) {
            this.createDelegationConnector(compositeComponentLink, requiredPort, subComponentInformation, false);
        } else {
            logger.warn((Object)"Could not find a required interface port which should have existed.");
        }
    }

    private void createDelegationConnector(ComponentImplementingClassesLink compositeComponentLink, InterfacePort newOuterPort, SubComponentInformation subComponentInformation, boolean isProvidedDelegationConnector) {
        Connector delegationConnector = StaticstructureFactory.eINSTANCE.createConnector();
        ((CompositeComponent)compositeComponentLink.getComponent()).getConnector().add((Object)delegationConnector);
        String documentation = "";
        documentation = isProvidedDelegationConnector ? String.valueOf(documentation) + "provided" : String.valueOf(documentation) + "required";
        documentation = String.valueOf(documentation) + " delegation connector " + compositeComponentLink.getComponent().getName() + " to " + subComponentInformation.getSubComponentInstance().getRealizedBy().getName();
        delegationConnector.setDocumentation(documentation);
        ComponentEndpoint componentEndpoint = StaticstructureFactory.eINSTANCE.createComponentEndpoint();
        componentEndpoint.setPort((Port)newOuterPort);
        delegationConnector.getEndpoints().add((Object)componentEndpoint);
        SubcomponentEndpoint subcomponentEndpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        subcomponentEndpoint.setPort((Port)subComponentInformation.getInterfacePort());
        subcomponentEndpoint.setSubcomponent(subComponentInformation.getSubComponentInstance());
        delegationConnector.getEndpoints().add((Object)subcomponentEndpoint);
    }

    private Set<Interface> collectInterfacesForComponent(ComponentImplementingClassesLink compositeComponentLink, boolean collectProvided) {
        HashSet<Interface> returnInterfaces = new HashSet<Interface>();
        EList ifLinks = collectProvided ? compositeComponentLink.getProvidedInterfaces() : compositeComponentLink.getRequiredInterfaces();
        for (InterfaceSourceCodeLink currentIfLink : ifLinks) {
            returnInterfaces.add(currentIfLink.getInterface());
        }
        return returnInterfaces;
    }

    public class SubComponentInformation {
        InterfaceSourceCodeLink interfaceSourceCodeLink;
        InterfacePort interfacePort;
        SubcomponentInstance subComponentInstance;

        public SubComponentInformation(InterfaceSourceCodeLink interfaceSourceCodeLink, InterfacePort componentLink, SubcomponentInstance subComponentInstance) {
            this.interfaceSourceCodeLink = interfaceSourceCodeLink;
            this.interfacePort = componentLink;
            this.subComponentInstance = subComponentInstance;
        }

        public InterfaceSourceCodeLink getInterfaceSourceCodeLink() {
            return this.interfaceSourceCodeLink;
        }

        public InterfacePort getInterfacePort() {
            return this.interfacePort;
        }

        public SubcomponentInstance getSubComponentInstance() {
            return this.subComponentInstance;
        }
    }
}

