/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import org.apache.log4j.Logger;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.configuration.SoMoXConfiguration;

public class ConnectorBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(ConnectorBuilder.class);

    public ConnectorBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void createAssemblyConnector(CompositeComponent component, Port requiredPort, Port providedPort, ComponentType requiredComponentType, ComponentType providedComponentType) {
        logger.debug((Object)("Creating new assembly connector from " + requiredComponentType.getName() + " to " + providedComponentType.getName()));
        Connector newConnector = StaticstructureFactory.eINSTANCE.createConnector();
        component.getConnector().add((Object)newConnector);
        newConnector.setDocumentation("Assembly Connector");
        SubcomponentEndpoint sourceEndpoint = this.addSubcomponentEndpoint(newConnector, component, requiredComponentType);
        sourceEndpoint.setPort(requiredPort);
        SubcomponentEndpoint targetEndpoint = this.addSubcomponentEndpoint(newConnector, component, providedComponentType);
        targetEndpoint.setPort(providedPort);
    }

    private SubcomponentEndpoint addSubcomponentEndpoint(Connector newConnector, CompositeComponent component, ComponentType componentTypeOfPort) {
        SubcomponentEndpoint endpoint = StaticstructureFactory.eINSTANCE.createSubcomponentEndpoint();
        boolean found = false;
        for (SubcomponentInstance subcomponentInstance : component.getSubcomponents()) {
            if (!subcomponentInstance.getRealizedBy().equals(componentTypeOfPort)) continue;
            if (found) {
                throw new IllegalArgumentException("Assumption on input model does not hold. Only one instance per component type per composite component assumed!");
            }
            endpoint.setSubcomponent(subcomponentInstance);
            found = true;
        }
        newConnector.getEndpoints().add((Object)endpoint);
        return endpoint;
    }
}

