/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import de.fzi.gast.core.Root;
import de.fzi.gast.types.GASTClass;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import eu.qimpress.sourcecodedecorator.FileLevelSourceCodeLink;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorDeFactoStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.AssemblyConnectorsInsideCompositeComponentStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentAndTypeNaming;
import org.somox.analyzer.simplemodelanalyzer.builder.ConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.IInterfacePortBuilderStrategy;
import org.somox.analyzer.simplemodelanalyzer.builder.InterfaceBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.NonDuplicatingInterfacePortBuilder;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ClusteringRelation;

public class ComponentBuilder
extends AbstractBuilder {
    private ComponentAndTypeNaming componentNamingStrategy = null;
    private InterfaceBuilder interfaceBuilder = null;
    private IAssemblyConnectorStrategy assemblyConnectorDeFactoBuilder = null;
    private IAssemblyConnectorStrategy assemblyConnectorInnerBuilder = null;
    private IInterfacePortBuilderStrategy providedInterfaceBuilder = null;
    private IInterfacePortBuilderStrategy requiredInterfaceBuilder;
    private static Logger logger = Logger.getLogger(ComponentBuilder.class);

    public ComponentBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
        logger.debug((Object)"Initialising SAMM model builder");
        this.componentNamingStrategy = new ComponentAndTypeNaming();
        this.interfaceBuilder = new InterfaceBuilder(gastModel, somoxConfiguration, analysisResult);
        ConnectorBuilder connectorBuilder = new ConnectorBuilder(gastModel, somoxConfiguration, analysisResult);
        this.assemblyConnectorDeFactoBuilder = new AssemblyConnectorDeFactoStrategy(connectorBuilder);
        this.assemblyConnectorInnerBuilder = new AssemblyConnectorsInsideCompositeComponentStrategy(connectorBuilder);
        this.providedInterfaceBuilder = new NonDuplicatingInterfacePortBuilder(gastModel, somoxConfiguration, analysisResult, true);
        this.requiredInterfaceBuilder = new NonDuplicatingInterfacePortBuilder(gastModel, somoxConfiguration, analysisResult, false);
        if (somoxConfiguration.isReverseEngineerInterfacesNotAssignedToComponent()) {
            this.interfaceBuilder.reverseEngineerRemainingInterfacesAsFreeFloatingInterfaces(analysisResult, gastModel);
        }
    }

    public ComponentImplementingClassesLink createPrimitiveComponentFromGASTClass(GASTClass gastClass) {
        String componentName = this.componentNamingStrategy.createSimpleComponentName(gastClass);
        logger.info((Object)("Creating primitive component " + componentName));
        ComponentImplementingClassesLink newPrimitiveComponent = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)newPrimitiveComponent);
        PrimitiveComponent newComponentType = StaticstructureFactory.eINSTANCE.createPrimitiveComponent();
        newComponentType.setName(componentName);
        this.analysisResult.getInternalArchitectureModel().getComponenttype().add((Object)newComponentType);
        newPrimitiveComponent.setComponent((ComponentType)newComponentType);
        newPrimitiveComponent.getImplementingClasses().addAll(this.getInnerClasses(gastClass, (ComponentType)newComponentType));
        this.interfaceBuilder.findAndAddRequiredInterfaces(newPrimitiveComponent);
        this.interfaceBuilder.addProvidedInterfaces(newPrimitiveComponent);
        return newPrimitiveComponent;
    }

    public ComponentImplementingClassesLink createCompositeComponent(Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        String componentName = this.componentNamingStrategy.createCompositeComponentName(compositeComponentSubgraph.vertexSet());
        logger.info((Object)("Creating composite component with name: " + componentName));
        ComponentImplementingClassesLink result = SourceCodeDecoratorFactory.eINSTANCE.createComponentImplementingClassesLink();
        CompositeComponent newComponentType = StaticstructureFactory.eINSTANCE.createCompositeComponent();
        newComponentType.setName(componentName);
        for (ComponentImplementingClassesLink innerComponent : compositeComponentSubgraph.vertexSet()) {
            SubcomponentInstance subcomponentInstance = StaticstructureFactory.eINSTANCE.createSubcomponentInstance();
            subcomponentInstance.setRealizedBy(innerComponent.getComponent());
            subcomponentInstance.setName(this.componentNamingStrategy.createComponentInstanceName(innerComponent.getComponent()));
            newComponentType.getSubcomponents().add((Object)subcomponentInstance);
        }
        result.setComponent((ComponentType)newComponentType);
        result.getSubComponents().addAll((Collection)compositeComponentSubgraph.vertexSet());
        this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink().add((Object)result);
        this.analysisResult.getInternalArchitectureModel().getComponenttype().add((Object)newComponentType);
        this.assemblyConnectorDeFactoBuilder.buildAssemblyConnectors(result, compositeComponentSubgraph);
        this.assemblyConnectorInnerBuilder.buildAssemblyConnectors(result, compositeComponentSubgraph);
        this.providedInterfaceBuilder.buildInterfacePort(result);
        this.requiredInterfaceBuilder.buildInterfacePort(result);
        return result;
    }

    private Set<GASTClass> getInnerClasses(GASTClass element, ComponentType newComponentType) {
        HashSet<GASTClass> currentList = new HashSet<GASTClass>();
        currentList.add(element);
        this.storeFileLocationInSourceCodeDecorator(element, newComponentType);
        EList innerClasses = element.getInnerClasses();
        if (innerClasses != null) {
            currentList.addAll((Collection<GASTClass>)innerClasses);
        }
        for (GASTClass innerClass : innerClasses) {
            currentList.addAll(this.getInnerClasses(innerClass, newComponentType));
        }
        return currentList;
    }

    private void storeFileLocationInSourceCodeDecorator(GASTClass gastClass, ComponentType newComponent) {
        FileLevelSourceCodeLink link = SourceCodeDecoratorFactory.eINSTANCE.createFileLevelSourceCodeLink();
        link.setComponentType(newComponent);
        if (gastClass.getPosition() != null && gastClass.getPosition().getSourceFile() != null) {
            link.setFile(gastClass.getPosition().getSourceFile());
        }
        this.analysisResult.getSourceCodeDecoratorRepository().getFileLevelSourceCodeLink().add((Object)link);
    }
}

