/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.somox.analyzer.simplemodelanalyzer.builder.ConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.metrics.ClusteringRelation;

public class AssemblyConnectorsInsideCompositeComponentStrategy
implements IAssemblyConnectorStrategy {
    private ConnectorBuilder connectorBuilder;

    public AssemblyConnectorsInsideCompositeComponentStrategy(ConnectorBuilder connectorBuilder) {
        this.connectorBuilder = connectorBuilder;
    }

    @Override
    public void buildAssemblyConnectors(ComponentImplementingClassesLink compositeComponentCandidate, Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        this.establishAssemblyConnectorsForNonConnectedPorts(compositeComponentCandidate);
    }

    private void establishAssemblyConnectorsForNonConnectedPorts(ComponentImplementingClassesLink compositeComponentCandidate) {
        if (!(compositeComponentCandidate.getComponent() instanceof CompositeComponent)) {
            throw new IllegalArgumentException("must be a composite component!");
        }
        CompositeComponent outerComposite = (CompositeComponent)compositeComponentCandidate.getComponent();
        for (ComponentImplementingClassesLink firstComponent : compositeComponentCandidate.getSubComponents()) {
            for (InterfacePort requiredPort : firstComponent.getComponent().getRequired()) {
                if (this.isBoundInConnector((EList<Connector>)outerComposite.getConnector(), requiredPort)) continue;
                this.findMatchingProvidedPortAndCreateAssemblyConnector(compositeComponentCandidate, outerComposite, firstComponent, requiredPort);
            }
        }
    }

    private void findMatchingProvidedPortAndCreateAssemblyConnector(ComponentImplementingClassesLink compositeComponentCandidate, CompositeComponent outerComposite, ComponentImplementingClassesLink requiringComponent, InterfacePort requiredPort) {
        for (ComponentImplementingClassesLink providingComponent : compositeComponentCandidate.getSubComponents()) {
            for (InterfacePort providedPort : providingComponent.getComponent().getProvided()) {
                if (!requiredPort.getInterfaceType().equals(providedPort)) continue;
                this.connectorBuilder.createAssemblyConnector(outerComposite, (Port)requiredPort, (Port)providedPort, requiringComponent.getComponent(), providingComponent.getComponent());
            }
        }
    }

    private boolean isBoundInConnector(EList<Connector> connectors, InterfacePort port) {
        for (Connector currentConnectors : connectors) {
            for (EndPoint endpoint : currentConnectors.getEndpoints()) {
                if (!endpoint.getPort().equals(port)) continue;
                return true;
            }
        }
        return false;
    }
}

