/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Port;
import eu.qimpress.sourcecodedecorator.ComponentImplementingClassesLink;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.Graph;
import org.somox.analyzer.simplemodelanalyzer.builder.ConnectorBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.IAssemblyConnectorStrategy;
import org.somox.metrics.ClusteringRelation;

public class AssemblyConnectorDeFactoStrategy
implements IAssemblyConnectorStrategy {
    private ConnectorBuilder connectorBuilder;

    public AssemblyConnectorDeFactoStrategy(ConnectorBuilder connectorBuilder) {
        this.connectorBuilder = connectorBuilder;
    }

    @Override
    public void buildAssemblyConnectors(ComponentImplementingClassesLink compositeComponentCandidate, Graph<ComponentImplementingClassesLink, ClusteringRelation> compositeComponentSubgraph) {
        if (!compositeComponentCandidate.isCompositeComponent()) {
            throw new IllegalArgumentException("Add assembly connectors not allowed for primitive components");
        }
        for (ClusteringRelation edge : compositeComponentSubgraph.edgeSet()) {
            this.probeAssemblyConnector((CompositeComponent)compositeComponentCandidate.getComponent(), (ComponentImplementingClassesLink)compositeComponentSubgraph.getEdgeSource((Object)edge), (ComponentImplementingClassesLink)compositeComponentSubgraph.getEdgeTarget((Object)edge));
        }
    }

    private void probeAssemblyConnector(CompositeComponent component, ComponentImplementingClassesLink edgeSource, ComponentImplementingClassesLink edgeTarget) {
        EList requiredRoles = edgeSource.getComponent().getRequired();
        EList providedRoles = edgeTarget.getComponent().getProvided();
        for (InterfacePort requiredRole : requiredRoles) {
            for (InterfacePort providedRole : providedRoles) {
                if (requiredRole.getInterfaceType() != providedRole.getInterfaceType()) continue;
                this.connectorBuilder.createAssemblyConnector(component, (Port)requiredRole, (Port)providedRole, edgeSource.getComponent(), edgeTarget.getComponent());
            }
        }
    }
}

