/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.qabstractor.integration;

import de.fzi.gast.core.Root;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.ow2.dsrg.fm.qabstractor.Transformer;
import org.ow2.dsrg.fm.qabstractor.extract.GastServiceExtractorLoader;
import org.ow2.dsrg.fm.qabstractor.extract.MetadataExtractor;

public class GAST2TBPJob
implements IJob {
    private Logger logger = Logger.getLogger(GAST2TBPJob.class);
    private URI sammInstanceURI;
    private URI gastBehaviourURI;
    private URI sourcecodeDecoratorURI;
    private URI gastURI;
    private static final String GAST_STUB_BEHAVIOUR_EXTENSION = "samm_gastbehaviour";
    private static final String SOURCECODE_DECORATOR_EXTENSION = "sourcecodedecorator";
    private static final String TBP_FOLDER = "Tbp";
    private static final String GAST_FILE = "gastmodel.gast";
    private Resource gastConnection;
    private Resource sammInstance;
    private Resource sourceCodeDecoratorInstance;
    private Resource gast;
    private String outputPath;
    private ResourceSet resourceSet = new ResourceSetImpl();

    public GAST2TBPJob(URI sammInstanceURI) {
        this(sammInstanceURI, sammInstanceURI.trimFileExtension().appendFileExtension(GAST_STUB_BEHAVIOUR_EXTENSION), sammInstanceURI.trimFileExtension().appendFileExtension(SOURCECODE_DECORATOR_EXTENSION), sammInstanceURI.trimSegments(1).appendSegment(GAST_FILE));
    }

    public GAST2TBPJob(URI sammInstanceURI, URI gastBehaviourRepositoryURI, URI sourcecodeDecoratorURI, URI gastURI) {
        this.sammInstanceURI = sammInstanceURI;
        this.gastBehaviourURI = gastBehaviourRepositoryURI;
        this.sourcecodeDecoratorURI = sourcecodeDecoratorURI;
        this.gastURI = gastURI;
        this.outputPath = gastURI.trimSegments(1).toFileString();
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        this.logger.debug((Object)"GAST2TBP started...");
        this.sammInstance = this.loadResource(this.sammInstanceURI);
        this.gastConnection = this.loadResource(this.gastBehaviourURI);
        this.gast = this.loadResource(this.gastURI);
        this.sourceCodeDecoratorInstance = this.loadResource(this.sourcecodeDecoratorURI);
        SourceCodeDecoratorRepository scdrep = (SourceCodeDecoratorRepository)this.sourceCodeDecoratorInstance.getContents().get(0);
        if (scdrep == null) {
            this.logger.warn((Object)"Failed to load sourcecode decorator repository, exiting.");
            return;
        }
        Root r = (Root)this.gast.getContents().get(0);
        if (r == null) {
            this.logger.warn((Object)"Failed to load gast model, exiting.");
            return;
        }
        GastServiceExtractorLoader gse = new GastServiceExtractorLoader(scdrep);
        MetadataExtractor mde = gse.load();
        try {
            Transformer.transform((String)this.outputPath, (Root)r, (MetadataExtractor)mde);
        }
        catch (IOException e) {
            this.logger.warn((Object)e.getMessage());
            return;
        }
        this.logger.debug((Object)"GAST2TBP finished.");
    }

    public String getName() {
        return "GAST2TBP Transformation Job";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private Resource loadResource(URI uri) throws JobFailedException {
        Resource resource = this.resourceSet.getResource(uri, true);
        return resource;
    }

    private Resource createResource(URI uri) {
        Resource resource = this.resourceSet.createResource(uri);
        return resource;
    }

    private void saveResource(Resource resource) throws JobFailedException {
        try {
            resource.save(new HashMap());
        }
        catch (IOException e) {
            throw new JobFailedException("Saving model output failed", (Throwable)e);
        }
    }
}

