/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.reverseengineering.gast2seff.jobs;

import de.fzi.gast.statements.BlockStatement;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import eu.qimpress.qimpressgast.GASTBehaviour;
import eu.qimpress.qimpressgast.GASTBehaviourRepository;
import eu.qimpress.reverseengineering.gast2seff.visitors.BasicFunctionClassificationStrategy;
import eu.qimpress.reverseengineering.gast2seff.visitors.FunctionCallClassificationVisitor;
import eu.qimpress.reverseengineering.gast2seff.visitors.GastStatementVisitor;
import eu.qimpress.samm.behaviour.Behaviour;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.GastBehaviourStub;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.AbstractAction;
import eu.qimpress.seff.ResourceDemandingBehaviour;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.StartAction;
import eu.qimpress.seff.StopAction;
import eu.qimpress.seff.seffFactory;
import eu.qimpress.sourcecodedecorator.SourceCodeDecoratorRepository;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class GAST2SEFFJob
implements IJob {
    private Logger logger = Logger.getRootLogger();
    private ResourceSet resourceSet = new ResourceSetImpl();
    private ECrossReferenceAdapter adapter;
    private Resource sammInstance = null;
    private Resource gastBehaviourRepository = null;
    private Resource seffBehaviourRepository = null;
    private GASTBehaviourRepository gastBehaviourRepositoryModel = null;
    private Resource sourceCodeDecorator = null;
    private SourceCodeDecoratorRepository sourceCodeDecoratorModel = null;
    private static final String SEFF_BEHAVIOUR_EXTENSION = "samm_seff";
    private static final String GAST_BEHAVIOUR_EXTENSION = "samm_gastbehaviour";
    private static final String SOURCE_CODE_DECORATOR_EXTENSION = "sourcecodedecorator";
    private FunctionCallClassificationVisitor typeVisitor = new FunctionCallClassificationVisitor(new BasicFunctionClassificationStrategy());
    private URI sammInstanceURI;
    private URI gastBehaviourRepositoryURI;
    private URI seffBehaviourRepositoryURI;
    private URI sourceCodeDecoratorURI;

    public GAST2SEFFJob(URI sammInstanceURI) {
        this(sammInstanceURI, sammInstanceURI.trimFileExtension().appendFileExtension(GAST_BEHAVIOUR_EXTENSION), sammInstanceURI.trimFileExtension().appendFileExtension(SEFF_BEHAVIOUR_EXTENSION), sammInstanceURI.trimFileExtension().appendFileExtension(SOURCE_CODE_DECORATOR_EXTENSION));
    }

    public GAST2SEFFJob(URI sammInstanceURI, URI gastBehaviourRepositoryURI, URI seffBehaviourRepositoryURI, URI sourceCodeDecoratorURI) {
        this.logger.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n")));
        HashMap cache = new HashMap();
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(cache);
        this.sammInstanceURI = sammInstanceURI;
        this.gastBehaviourRepositoryURI = gastBehaviourRepositoryURI;
        this.seffBehaviourRepositoryURI = seffBehaviourRepositoryURI;
        this.sourceCodeDecoratorURI = sourceCodeDecoratorURI;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.sammInstanceURI.isEmpty() || !this.sammInstanceURI.isFile() || this.gastBehaviourRepositoryURI.isEmpty() || !this.gastBehaviourRepositoryURI.isFile()) {
            String error = "missing model files (samm or gast behaviour repository) to apply GAST2SEFF";
            this.logger.error((Object)error);
            throw new JobFailedException(error);
        }
        this.sammInstance = this.loadResource(this.sammInstanceURI);
        this.gastBehaviourRepository = this.loadResource(this.gastBehaviourRepositoryURI);
        this.gastBehaviourRepositoryModel = (GASTBehaviourRepository)this.gastBehaviourRepository.getContents().get(0);
        this.sourceCodeDecorator = this.loadResource(this.sourceCodeDecoratorURI);
        this.sourceCodeDecoratorModel = (SourceCodeDecoratorRepository)this.sourceCodeDecorator.getContents().get(0);
        this.seffBehaviourRepository = this.createResource(this.seffBehaviourRepositoryURI);
        SeffRepository seffRepository = seffFactory.eINSTANCE.createSeffRepository();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        TreeIterator iterator = this.sammInstance.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof GastBehaviourStub)) continue;
            this.logger.info((Object)"Found GAST behaviour, generating SEFF behaviour for it");
            ResourceDemandingSEFF resourceDemandingSEFF = this.generateSEFFForGASTBehaviour((GastBehaviourStub)eObject);
            seffRepository.getResourceDemandingSeff().add((Object)resourceDemandingSEFF);
            monitor.worked(1);
        }
        subMonitor.done();
        this.seffBehaviourRepository.getContents().add((Object)seffRepository);
        this.saveResource(this.seffBehaviourRepository);
    }

    public String getName() {
        return "GAST2SEFF Transformation Job";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    private Resource loadResource(URI uri) throws JobFailedException {
        this.logger.debug((Object)("load start " + uri));
        HashMap cache = new HashMap();
        ((ResourceSetImpl)this.resourceSet).setURIResourceMap(cache);
        Resource resource = this.resourceSet.createResource(uri);
        Map loadOptions = ((XMLResourceImpl)resource).getDefaultLoadOptions();
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(new HashMap());
        try {
            resource.load(loadOptions);
        }
        catch (IOException e) {
            throw new JobFailedException("Loading of a required resource failed", (Throwable)e);
        }
        this.logger.debug((Object)"load end");
        return resource;
    }

    private Resource createResource(URI uri) {
        Resource resource = this.resourceSet.createResource(uri);
        return resource;
    }

    private void saveResource(Resource resource) throws JobFailedException {
        try {
            resource.save(new HashMap());
        }
        catch (IOException e) {
            throw new JobFailedException("Saving model output failed", (Throwable)e);
        }
    }

    private ResourceDemandingSEFF createSeff(GastBehaviourStub gastBehaviourStub, ResourceDemandingSEFF seff) throws JobFailedException {
        StartAction start = seffFactory.eINSTANCE.createStartAction();
        StopAction stop = seffFactory.eINSTANCE.createStopAction();
        seff.getSteps().add((Object)start);
        BlockStatement body = this.findBody(gastBehaviourStub);
        if (body != null) {
            this.typeVisitor.doSwitch((EObject)body);
            GastStatementVisitor visitor = new GastStatementVisitor(this.typeVisitor.getAnnotations(), (ResourceDemandingBehaviour)seff, this.sourceCodeDecoratorModel, (PrimitiveComponent)gastBehaviourStub.eContainer());
            visitor.doSwitch((EObject)body);
        } else {
            this.logger.warn((Object)("Found GAST behaviour (" + gastBehaviourStub.getName() + ") without a method body... Skipping it..."));
        }
        seff.getSteps().add((Object)stop);
        GAST2SEFFJob.connectActions((ResourceDemandingBehaviour)seff);
        return seff;
    }

    private BlockStatement findBody(GastBehaviourStub gastBehaviourStub) throws JobFailedException {
        for (GASTBehaviour behaviour : this.gastBehaviourRepositoryModel.getGastbehaviour()) {
            if (!behaviour.getGastbehaviourstub().getId().equals(gastBehaviourStub.getId())) continue;
            return behaviour.getBlockstatement();
        }
        this.logger.warn((Object)("Checked gastBehaviourRepository for " + gastBehaviourStub.getName() + " " + gastBehaviourStub.getId() + " but found none"));
        return null;
    }

    public static void connectActions(ResourceDemandingBehaviour seff) {
        AbstractAction previous = null;
        for (AbstractAction a : seff.getSteps()) {
            a.setPredecessor_AbstractAction(previous);
            previous = a;
        }
    }

    private ResourceDemandingSEFF generateSEFFForGASTBehaviour(GastBehaviourStub gastBehaviourStub) throws JobFailedException {
        ResourceDemandingSEFF resourceDemandingSEFF = seffFactory.eINSTANCE.createResourceDemandingSEFF();
        this.createSeff(gastBehaviourStub, resourceDemandingSEFF);
        SeffBehaviourStub seffBehaviourStub = this.findOrCreateBehaviourStub(gastBehaviourStub);
        resourceDemandingSEFF.setSeffBehaviourStub(seffBehaviourStub);
        return resourceDemandingSEFF;
    }

    private SeffBehaviourStub findOrCreateBehaviourStub(GastBehaviourStub gastBehaviourStub) {
        PrimitiveComponent parentComponent = (PrimitiveComponent)gastBehaviourStub.eContainer();
        SeffBehaviourStub seffBehaviourStub = null;
        for (Behaviour behaviour : parentComponent.getOperationBehaviour()) {
            SeffBehaviourStub candidateStub;
            if (!(behaviour instanceof SeffBehaviourStub) || (candidateStub = (SeffBehaviourStub)behaviour).getOperation() != gastBehaviourStub.getOperation()) continue;
            this.logger.debug((Object)"Found SEFF behaviour stub, reusing it...");
            seffBehaviourStub = candidateStub;
            break;
        }
        if (seffBehaviourStub == null) {
            seffBehaviourStub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
        }
        seffBehaviourStub.setOperation(gastBehaviourStub.getOperation());
        parentComponent.getOperationBehaviour().add((Object)seffBehaviourStub);
        return seffBehaviourStub;
    }
}

