/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.visualizations.resultviewer.ui;

import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.visualizations.resultviewer.ui.ResultViewerComposite;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.AnalysisResult;
import eu.qimpress.resultmodel.CpuResourceUtilization;
import eu.qimpress.resultmodel.MaintainabilityPredictionResult;
import eu.qimpress.resultmodel.PerformancePredictionResult;
import eu.qimpress.resultmodel.Reliability;
import eu.qimpress.resultmodel.ReliabilityPredictionResult;
import eu.qimpress.resultmodel.ResponseTime;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class ResultViewerView
extends ViewPart {
    private IQRepository repos;
    private ResultViewerComposite rvc;

    public void createPartControl(Composite parent) {
        this.rvc = new ResultViewerComposite(parent, 0);
    }

    public void setFocus() {
    }

    public void setRepository(IQRepository repos) {
        String DEFAULT_FMT = "%.3f";
        this.repos = repos;
        this.rvc.repos = repos;
        this.rvc.resultList.getColumn(0).setText("Result");
        this.rvc.resultList.getColumn(1).setText("10% Quantile");
        this.rvc.resultList.getColumn(2).setText("90% Quantile");
        this.rvc.resultList.getColumn(3).setText("Mean");
        this.rvc.resultList.getColumn(4).setText("Median");
        this.rvc.resultList.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = ((ResultViewerView)ResultViewerView.this).rvc.resultList.getItem(point);
                if (item != null) {
                    while (item.getParentItem() != null) {
                        item = item.getParentItem();
                    }
                    ResultViewerView.this.rvc.displayAlternativeData(item);
                }
            }
        });
        new Vector();
        try {
            List aevals = repos.getAllAlternativeEvaluations();
            for (AlternativeEvaluation ae : aevals) {
                TreeItem item = new TreeItem(this.rvc.resultList, 0);
                item.setText(String.valueOf(ae.getName()) + " " + ae.getId());
                for (AnalysisResult ar : ae.getAnalysisResults()) {
                    TreeItem subItem2;
                    Iterator subItem1;
                    TreeItem subItem;
                    PerformancePredictionResult res;
                    if (ar instanceof PerformancePredictionResult) {
                        res = (PerformancePredictionResult)ar;
                        subItem = new TreeItem(item, 0);
                        subItem.setText("Performance");
                        subItem.setGrayed(true);
                        subItem1 = new TreeItem(subItem, 0);
                        subItem1.setText(new String[]{"CPU Resource Utilizations"});
                        subItem1.setGrayed(true);
                        for (CpuResourceUtilization res1 : res.getResourceUtilizations()) {
                            TreeItem subItem11 = new TreeItem((TreeItem)subItem1, 0);
                            subItem11.setText(new String[]{String.format("Usage resource %d", res1.getExecutionResource().getCoreId()), String.format(DEFAULT_FMT, res1.getResultDistribution().get_10PercentQuantile()), String.format(DEFAULT_FMT, res1.getResultDistribution().get_90PercentQuantile()), String.format(DEFAULT_FMT, res1.getResultDistribution().getArithmeticMean()), String.format(DEFAULT_FMT, res1.getResultDistribution().getMedian())});
                            subItem11.setGrayed(true);
                        }
                        subItem2 = new TreeItem(subItem, 0);
                        subItem2.setText(new String[]{"Response Times"});
                        subItem2.setGrayed(true);
                        for (ResponseTime res1 : res.getResponseTimes()) {
                            TreeItem subItem21 = new TreeItem(subItem2, 0);
                            subItem21.setText(new String[]{"System Call " + res1.getUsageScenario().getName(), String.format(DEFAULT_FMT, res1.getResultDistribution().get_10PercentQuantile()), String.format(DEFAULT_FMT, res1.getResultDistribution().get_90PercentQuantile()), String.format(DEFAULT_FMT, res1.getResultDistribution().getArithmeticMean()), String.format(DEFAULT_FMT, res1.getResultDistribution().getMedian())});
                            subItem21.setGrayed(true);
                        }
                        continue;
                    }
                    if (ar instanceof ReliabilityPredictionResult) {
                        res = (ReliabilityPredictionResult)ar;
                        for (Reliability res1 : res.getReliabilities()) {
                            TreeItem subItem3 = new TreeItem(item, 0);
                            subItem3.setText(new String[]{"Reliability", String.format(DEFAULT_FMT, res1.getResultDistribution().get_10PercentQuantile()), String.format(DEFAULT_FMT, res1.getResultDistribution().get_90PercentQuantile()), String.format(DEFAULT_FMT, res1.getResultDistribution().getArithmeticMean()), String.format(DEFAULT_FMT, res1.getResultDistribution().getMedian())});
                            subItem3.setGrayed(true);
                        }
                        continue;
                    }
                    if (!(ar instanceof MaintainabilityPredictionResult)) continue;
                    res = (MaintainabilityPredictionResult)ar;
                    subItem = new TreeItem(item, 0);
                    subItem.setText("Maintainability");
                    subItem.setGrayed(true);
                    subItem1 = new TreeItem(subItem, 0);
                    subItem1.setText(new String[]{"Costs", String.format(DEFAULT_FMT, res.getAggregatedCosts())});
                    subItem1.setGrayed(true);
                    subItem2 = new TreeItem(subItem, 0);
                    subItem2.setText(new String[]{"Time Effort", String.format(DEFAULT_FMT, res.getAggregatedTimeEffort())});
                    subItem2.setGrayed(true);
                }
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }
}

