/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.visualizations.resultviewer.ui;

import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.tradeoff.ahp.AHPWizard;
import eu.qimpress.resultmodel.AlternativeEvaluation;
import java.util.ArrayList;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ResultViewerComposite
extends Composite {
    private Label resultListLabel = null;
    public Tree resultList = null;
    private Composite composite1 = null;
    private Button btnRunAhp = null;
    private Button btnCheckAll = null;
    private Button btnCheckNone = null;
    private Button btnInvertSelection = null;
    public IQRepository repos;
    private Text txtAlternativeEvaluationDescription = null;

    public ResultViewerComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.resultListLabel = new Label((Composite)this, 0);
        this.resultListLabel.setText("Results");
        new Label((Composite)this, 0);
        this.resultList = new Tree((Composite)this, 32);
        this.resultList.setHeaderVisible(true);
        this.resultList.setLayoutData((Object)gridData);
        this.resultList.setLinesVisible(true);
        TreeColumn treeColumn = new TreeColumn(this.resultList, 0);
        treeColumn.setWidth(300);
        TreeColumn treeColumn1 = new TreeColumn(this.resultList, 0);
        treeColumn1.setWidth(60);
        TreeColumn treeColumn2 = new TreeColumn(this.resultList, 0);
        treeColumn2.setWidth(60);
        TreeColumn treeColumn3 = new TreeColumn(this.resultList, 0);
        treeColumn3.setWidth(60);
        TreeColumn treeColumn4 = new TreeColumn(this.resultList, 0);
        treeColumn4.setWidth(60);
        this.setLayout((Layout)gridLayout);
        this.createComposite1();
        this.setSize(new Point(622, 236));
    }

    private void createComposite1() {
        GridData gridData6 = new GridData();
        gridData6.grabExcessVerticalSpace = true;
        gridData6.verticalAlignment = 4;
        gridData6.horizontalAlignment = 1;
        gridData6.widthHint = 220;
        GridData gridData5 = new GridData();
        gridData5.grabExcessHorizontalSpace = true;
        gridData5.verticalAlignment = 2;
        gridData5.horizontalAlignment = 1;
        gridData5.widthHint = 100;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.verticalSpacing = 5;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 1;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.verticalAlignment = 2;
        gridData4.widthHint = 100;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 1;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        gridData3.widthHint = 100;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 1;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalIndent = 0;
        gridData2.verticalAlignment = 2;
        gridData2.widthHint = 100;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 4;
        gridData1.grabExcessVerticalSpace = true;
        this.composite1 = new Composite((Composite)this, 0);
        this.composite1.setLayoutData((Object)gridData1);
        this.composite1.setLayout((Layout)gridLayout1);
        this.btnCheckAll = new Button(this.composite1, 0);
        this.btnCheckAll.setText("Check All");
        this.btnCheckAll.setLayoutData((Object)gridData4);
        this.btnCheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ResultViewerComposite.this.resultList.getItemCount()) {
                    ResultViewerComposite.this.resultList.getItem(i).setChecked(true);
                    ++i;
                }
            }
        });
        this.btnCheckNone = new Button(this.composite1, 0);
        this.btnCheckNone.setText("Check None");
        this.btnCheckNone.setLayoutData((Object)gridData3);
        this.btnInvertSelection = new Button(this.composite1, 0);
        this.btnInvertSelection.setText("Invert Selection");
        this.btnInvertSelection.setLayoutData((Object)gridData5);
        this.btnInvertSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ResultViewerComposite.this.resultList.getItemCount()) {
                    ResultViewerComposite.this.resultList.getItem(i).setChecked(!ResultViewerComposite.this.resultList.getItem(i).getChecked());
                    ++i;
                }
            }
        });
        this.btnCheckNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ResultViewerComposite.this.resultList.getItemCount()) {
                    ResultViewerComposite.this.resultList.getItem(i).setChecked(false);
                    ++i;
                }
            }
        });
        this.btnRunAhp = new Button(this.composite1, 0);
        this.btnRunAhp.setText("Run AHP");
        this.btnRunAhp.setLayoutData((Object)gridData2);
        this.txtAlternativeEvaluationDescription = new Text(this.composite1, 578);
        this.txtAlternativeEvaluationDescription.setLayoutData((Object)gridData6);
        this.btnRunAhp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<AlternativeEvaluation> selectedEvaluations = new ArrayList<AlternativeEvaluation>();
                int i = 0;
                while (i < ResultViewerComposite.this.resultList.getItemCount()) {
                    if (ResultViewerComposite.this.resultList.getItem(i).getChecked()) {
                        String str = ResultViewerComposite.this.resultList.getItem(i).getText();
                        try {
                            for (AlternativeEvaluation ae : ResultViewerComposite.this.repos.getAllAlternativeEvaluations()) {
                                if (!ae.getId().equals(str.substring(str.lastIndexOf(32) + 1))) continue;
                                selectedEvaluations.add(ae);
                            }
                        }
                        catch (RepositoryException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ++i;
                }
                WizardDialog dialog = new WizardDialog(ResultViewerComposite.this.getShell(), (IWizard)new AHPWizard(selectedEvaluations));
                dialog.open();
            }
        });
    }

    public void displayAlternativeData(TreeItem item) {
        String str = item.getText();
        str = str.substring(str.lastIndexOf(32) + 1);
        try {
            for (AlternativeEvaluation ae : this.repos.getAllAlternativeEvaluations()) {
                if (!ae.getId().equals(str)) continue;
                this.txtAlternativeEvaluationDescription.setText(String.format("Alternative ID: %s\nUsageModel: %s", ae.getAlternativeId(), ae.getUsageModel().getName()));
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }
}

