/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.ui.tabs.AlternativeSelectionListener;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QImpressAlternativeSelectionTab
extends AbstractLaunchConfigurationTab {
    public static final String SELECTED_ALTERNATIVE_GUID = "eu.qimpress.reverseengineering.alternativeselection";
    private CheckboxTreeViewer myAlternativesViewer;
    private Label selectionText;
    private transient Vector<AlternativeSelectionListener> alternativeListeners = new Vector();

    public void createControl(Composite parent) {
        Composite myTabControl = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        myTabControl.setLayout((Layout)gridLayout);
        this.setControl((Control)myTabControl);
        Group grpSelectQimpressAlternative = new Group(myTabControl, 4);
        grpSelectQimpressAlternative.setText("Select Q-ImPrESS Alternative");
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        grpSelectQimpressAlternative.setLayout((Layout)fillLayout);
        grpSelectQimpressAlternative.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.myAlternativesViewer = (CheckboxTreeViewer)QAlternativesTreeViewerFactory.createTreeViewer((Composite)grpSelectQimpressAlternative, QAlternativesTreeViewerFactory.SelectAlternativesEnum.SELECT_ONE).getTreeViewer();
        this.myAlternativesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof IQAlternative) {
                    if (event.getChecked()) {
                        IQAlternative alt = (IQAlternative)event.getElement();
                        QImpressAlternativeSelectionTab.this.selectionText.setText(alt.getInfo().getDescription());
                        QImpressAlternativeSelectionTab.this.fireAlternativeSelected(alt);
                    } else {
                        QImpressAlternativeSelectionTab.this.selectionText.setText("<none>");
                        QImpressAlternativeSelectionTab.this.fireAlternativeSelected(null);
                    }
                    QImpressAlternativeSelectionTab.this.setDirty(true);
                    QImpressAlternativeSelectionTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.myAlternativesViewer.expandAll();
        Label selection = new Label(myTabControl, 0);
        selection.setText("Selected Top-Level Alternative: ");
        selection.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.selectionText = new Label(myTabControl, 0);
        this.selectionText.setText("<none>");
        this.selectionText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
    }

    public String getName() {
        return "QImPrESS Alternative";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        IQApplicationModel model;
        IQElement alternative;
        String guid = "";
        try {
            guid = configuration.getAttribute(SELECTED_ALTERNATIVE_GUID, "");
        }
        catch (CoreException coreException) {}
        if (!guid.equals("") && (alternative = (model = (IQApplicationModel)this.myAlternativesViewer.getInput()).getElementByID(guid)) != null) {
            this.myAlternativesViewer.expandAll();
            this.myAlternativesViewer.setChecked((Object)alternative, true);
            this.fireAlternativeSelected((IQAlternative)alternative);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object[] elements = this.myAlternativesViewer.getCheckedElements();
        if (elements.length != 1 || !(elements[0] instanceof IQAlternative)) {
            configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
        } else {
            IQAlternative selectedAlternative = (IQAlternative)elements[0];
            configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, selectedAlternative.getInfo().getId());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        Object[] elements = this.myAlternativesViewer.getCheckedElements();
        if (elements.length != 1) {
            return "Select a single alternative";
        }
        if (!(elements[0] instanceof IQAlternative)) {
            return "Selection is not an alternative";
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SELECTED_ALTERNATIVE_GUID, "");
    }

    public void addAlternativeSelectionListener(AlternativeSelectionListener listener) {
        this.alternativeListeners.addElement(listener);
    }

    public void removeAlternativeSelectionListener(AlternativeSelectionListener listener) {
        this.alternativeListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAlternativeSelected(IQAlternative alternative) {
        if (this.alternativeListeners != null && !this.alternativeListeners.isEmpty()) {
            Vector targets;
            Vector<AlternativeSelectionListener> vector = this.alternativeListeners;
            synchronized (vector) {
                targets = (Vector)this.alternativeListeners.clone();
            }
            Enumeration e = targets.elements();
            while (e.hasMoreElements()) {
                AlternativeSelectionListener l = (AlternativeSelectionListener)e.nextElement();
                l.alternativeSelected(alternative);
            }
        }
    }
}

