/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.internal.filters;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.ui.internal.filters.IQFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.TreePath;

public class QFilter
implements IQFilter {
    String name;
    String pattern;
    boolean global;
    Pattern compiledPattern;

    public QFilter(String name, String pattern, boolean global) {
        this.name = name;
        this.pattern = pattern;
        this.global = global;
        this.compiledPattern = Pattern.compile(this.pattern);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public boolean select(Object parent, Object element) {
        TreePath tpath;
        if (!this.isGlobal() && parent instanceof TreePath && !((tpath = (TreePath)parent).getLastSegment() instanceof IQAlternative)) {
            return true;
        }
        IResource resource = this.getResource(element);
        if (resource != null) {
            Matcher matcher = this.compiledPattern.matcher(resource.getName());
            return !matcher.matches();
        }
        return true;
    }

    private IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }
}

