/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class QElementSelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    protected static final IQElement[] EMPTY_SELECTION = new IQElement[0];
    private IQElement[] selectedElements;
    private IStructuredSelection selection;
    private IWorkbenchSite workbenchSite;
    private ISetSelectionTarget selectionTarget;

    public QElementSelectionDispatchAction() {
        this(null, null);
    }

    public QElementSelectionDispatchAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
        this.workbenchSite = site;
        this.selectionTarget = selectionTarget;
    }

    public QElementSelectionDispatchAction(IWorkbenchSite site) {
        this(site, null);
    }

    public void run() {
        if (this.selectedElements.length > 0) {
            IQElement.ElementType commonElementType = this.selectedElements[0].getElementType();
            switch (commonElementType) {
                case Q_ALTERNATIVE: {
                    this.runInternal((IQAlternative[])Arrays.copyOf(this.selectedElements, this.selectedElements.length, IQAlternative[].class));
                    break;
                }
                case Q_REPOSITORY: {
                    this.runInternal((IQRepository[])Arrays.copyOf(this.selectedElements, this.selectedElements.length, IQRepository[].class));
                    break;
                }
                case Q_MODEL: {
                    this.runInternal((IQModel[])Arrays.copyOf(this.selectedElements, this.selectedElements.length, IQModel[].class));
                }
            }
        }
    }

    protected void runInternal(IQRepository[] repository) {
    }

    protected void runInternal(IQAlternative[] alternative) {
    }

    protected void runInternal(IQModel[] model) {
    }

    protected Shell getShell() {
        return this.workbenchSite != null ? this.workbenchSite.getShell() : Display.getDefault().getActiveShell();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.selectedElements = null;
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            this.selectedElements = ((IStructuredSelection)selection).size() > 0 && this.selectedSameTypeElements((IStructuredSelection)selection) ? ((IStructuredSelection)selection).toList().toArray(new IQElement[((IStructuredSelection)selection).size()]) : EMPTY_SELECTION;
        }
        this.postSelectionChanged(this.selectedElements);
    }

    private boolean selectedSameTypeElements(IStructuredSelection selection) {
        Object o = selection.getFirstElement();
        if (!(o instanceof IQElement)) {
            return false;
        }
        IQElement.ElementType commonType = ((IQElement)o).getElementType();
        for (Object so : selection) {
            if (so instanceof IQElement && ((IQElement)so).getElementType() == commonType) continue;
            return false;
        }
        return true;
    }

    protected void postSelectionChanged(IQElement[] element) {
    }

    protected IQElement[] getSelectedElement() {
        return this.selectedElements;
    }

    protected IWorkbenchSite getSite() {
        return this.workbenchSite;
    }

    protected void reportError(String msg, Throwable t) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Error occured", (String)msg);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected void unselect() {
        if (this.selectionTarget != null) {
            this.selectionTarget.selectReveal((ISelection)StructuredSelection.EMPTY);
        }
    }
}

