/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.actions.QElementSelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class DeleteAlternativeAction
extends QElementSelectionDispatchAction {
    public DeleteAlternativeAction(IWorkbenchSite site) {
        super(site);
        this.setText("Delete alternative");
        this.setDescription("Delete selected alternative");
        this.setToolTipText("Deletes selected alternative with no children. Does not delete models in the alternative.");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    @Override
    protected void runInternal(IQAlternative[] alternatives) {
        if (this.canDelete(alternatives)) {
            try {
                IQAlternative[] iQAlternativeArray = alternatives;
                int n = alternatives.length;
                int n2 = 0;
                while (n2 < n) {
                    IQAlternative alternative = iQAlternativeArray[n2];
                    alternative.getRepository().deleteAlternative(alternative);
                    ++n2;
                }
                QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
            }
            catch (RepositoryException repositoryException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot delete alternative");
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Delete alternative", (String)"Successfully deleted.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canDelete(IQAlternative[] alternatives) {
        try {
            IQAlternative[] iQAlternativeArray = alternatives;
            int n = alternatives.length;
            int n2 = 0;
            while (n2 < n) {
                IQAlternative alternative = iQAlternativeArray[n2];
                IQAlternative[] children = alternative.getRepository().getChildren(alternative);
                if (children.length != 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot delete - there are child alternatives.");
                    return false;
                }
                ++n2;
            }
        }
        catch (RepositoryException repositoryException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot obtain info about child alternatives");
            return false;
        }
        if (alternatives.length == 1) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Delete alternative", (String)("Do you want really delete alternative: " + alternatives[0].getInfo().getDescription() + "?"));
        }
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Delete alternative", (String)"Do you want really delete selecetd alternatives?");
    }

    @Override
    protected void postSelectionChanged(IQElement[] elements) {
        if (elements.length > 0 && elements[0].getElementType() == IQElement.ElementType.Q_ALTERNATIVE) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

