/*
 * Decompiled with CFR 0.152.
 */
package org.somox.configuration;

import java.util.Map;
import org.apache.log4j.Logger;
import org.somox.common.SoMoXProjectPreferences;
import org.somox.configuration.ClusteringConfiguration;
import org.somox.configuration.SoMoXConfiguration;

public class SOMOXConfigurationBuilderByPreferences {
    private static Logger logger = Logger.getLogger(SOMOXConfigurationBuilderByPreferences.class);

    public SoMoXConfiguration createSOMOXConfiguration(Map attributes) {
        SoMoXConfiguration somoxConfiguration = new SoMoXConfiguration();
        if (attributes != null) {
            this.initializeConfiguration(somoxConfiguration, attributes);
        }
        return somoxConfiguration;
    }

    public void initializeConfiguration(SoMoXConfiguration somoxConfiguration, Map attributes) {
        if (somoxConfiguration == null) {
            return;
        }
        if (attributes == null) {
            return;
        }
        if (attributes.get(SoMoXProjectPreferences.SOMOX_PROJECT_NAME) != null) {
            String projectIdentifier = (String)attributes.get(SoMoXProjectPreferences.SOMOX_PROJECT_NAME);
            somoxConfiguration.getFileLocations().setProjectName(projectIdentifier);
        }
        somoxConfiguration.getFileLocations().setOutputFolder("/model");
        if (attributes.get(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE) != null) {
            String inputfile = (String)attributes.get(SoMoXProjectPreferences.SOMOX_ANALYZER_INPUT_FILE);
            somoxConfiguration.getFileLocations().setAnalyserInputFile(inputfile);
        }
        if (attributes.get("org.somox.metrics.wildcards") != null) {
            String wildcardkey = (String)attributes.get("org.somox.metrics.wildcards");
            String additionalWildcardkey = (String)attributes.get("org.somox.metrics.wildcards.additional");
            somoxConfiguration.setWildcardKey(wildcardkey, additionalWildcardkey);
        }
        if (attributes.get("org.somox.metrics.nameResemblance.excludedPrefixes") != null) {
            String nameResemblancePrefixString = (String)attributes.get("org.somox.metrics.nameResemblance.excludedPrefixes");
            somoxConfiguration.setExcludedPrefixesForNameResemblance(nameResemblancePrefixString);
        }
        if (attributes.get("org.somox.metrics.nameResemblance.excludedSuffixes") != null) {
            String nameResemblanceSuffixString = (String)attributes.get("org.somox.metrics.nameResemblance.excludedSuffixes");
            somoxConfiguration.setExcludedSuffixesForNameResemblance(nameResemblanceSuffixString);
        }
        for (Object key : attributes.keySet()) {
            String keyname = key.toString();
            if (!keyname.contains("org.somox")) continue;
            logger.debug((Object)(key + "=" + attributes.get(key)));
        }
        logger.debug(attributes.values());
        somoxConfiguration.setWeightDirectoryMapping(Double.parseDouble((String)attributes.get("org.somox.directoryMapping.weightDirectoryMapping")));
        somoxConfiguration.setWeightDMS(Double.parseDouble((String)attributes.get("org.somox.dms.weightDMS")));
        somoxConfiguration.setWeightHighCoupling(Double.parseDouble((String)attributes.get("org.somox.nameResemblance.weightHighCoupling")));
        somoxConfiguration.setWeightHighestNameResemblance(Double.parseDouble((String)attributes.get("org.somox.nameResemblance.weightHighestNameResemblance")));
        somoxConfiguration.setWeightHighNameResemblance(Double.parseDouble((String)attributes.get("org.somox.nameResemblance.weightHighNameResemblance")));
        somoxConfiguration.setWeightHighSLAQ(Double.parseDouble((String)attributes.get("org.somox.subsystemComponent.weightHighSLAQ")));
        somoxConfiguration.setWeightInterfaceViolationIrrelevant(Double.parseDouble((String)attributes.get("org.somox.interfaceViolation.weightInterfaceViolationIrrelevant")));
        somoxConfiguration.setWeightInterfaceViolationRelevant(Double.parseDouble((String)attributes.get("org.somox.interfaceViolation.weightInterfaceViolationRelevant")));
        somoxConfiguration.setWeightLowCoupling(Double.parseDouble((String)attributes.get("org.somox.nameResemblance.weightLowCoupling")));
        somoxConfiguration.setWeightLowNameResemblance(Double.parseDouble((String)attributes.get("org.somox.nameResemblance.weightLowNameResemblance")));
        somoxConfiguration.setWeightLowSLAQ(Double.parseDouble((String)attributes.get("org.somox.subsystemComponent.weightLowSLAQ")));
        somoxConfiguration.setWeightMidNameResemblance(Double.parseDouble((String)attributes.get("org.somox.nameResemblance.weightMidNameResemblance")));
        somoxConfiguration.setWeightPackageMapping(Double.parseDouble((String)attributes.get("org.somox.packageMapping.weightPackageMapping")));
        this.createClusteringConfiguration(somoxConfiguration, attributes);
    }

    private void createClusteringConfiguration(SoMoXConfiguration somoxConfiguration, Map attributes) {
        ClusteringConfiguration clusteringConfiguration = somoxConfiguration.getClusteringConfig();
        clusteringConfiguration.setMaxClusteringThreshold(Double.parseDouble((String)attributes.get("org.somox.clusteringThresholdMax")) / 100.0);
        clusteringConfiguration.setMinClusteringThreshold(Double.parseDouble((String)attributes.get("org.somox.clusteringThresholdMin")) / 100.0);
        clusteringConfiguration.setClusteringThresholdDecrement(Double.parseDouble((String)attributes.get("org.somox.clusteringThresholdDecrement")) / 100.0);
    }
}

